/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.runners.SimpleIronpythonRunner;
import org.python.pydev.ast.runners.SimpleJythonRunner;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.newconsole.env.ChooseProcessTypeDialog;
import org.python.pydev.debug.newconsole.env.JythonEclipseProcess;
import org.python.pydev.debug.newconsole.env.PydevSpawnedInterpreterProcess;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsoleUMDPrefs;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.net.SocketUtil;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterPreferencesPage;

public class PydevIProcessFactory {
    private List<IPythonNature> naturesUsed;
    public static final String INTERACTIVE_LAUNCH_PORT = "INTERACTIVE_LAUNCH_PORT";

    public List<IPythonNature> getNaturesUsed() {
        return this.naturesUsed;
    }

    public Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public PydevConsoleLaunchInfo createInteractiveLaunch() throws UserCanceledException, Exception {
        IWorkbenchWindow workbenchWindow = EditorUtils.getActiveWorkbenchWindow();
        ITextEditor activeEditor = EditorUtils.getActiveEditor();
        PyEdit edit = null;
        if (activeEditor instanceof PyEdit) {
            edit = (PyEdit)activeEditor;
        }
        ChooseProcessTypeDialog dialog = new ChooseProcessTypeDialog(this.getShell(), edit);
        String rep = InteractiveConsolePrefs.getDefaultInteractiveConsole();
        boolean hasPrefs = false;
        if (!rep.isEmpty()) {
            dialog.create();
            hasPrefs = dialog.setInteractiveConsoleInterpreterPref(rep);
            if (hasPrefs) {
                dialog.okPressed();
            }
        }
        if (hasPrefs || dialog.open() == 0) {
            IInterpreterInfo[] interpreters;
            PyStackFrame selectedFrame = dialog.getSelectedFrame();
            if (selectedFrame != null) {
                String encoding = PydevIProcessFactory.getEncodingFromFrame(selectedFrame);
                return new PydevConsoleLaunchInfo(null, null, 0, null, selectedFrame, new String[]{"Debug connection (no command line)"}, null, encoding);
            }
            IInterpreterManager interpreterManager = dialog.getInterpreterManager();
            if (interpreterManager == null) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreter manager for creating console", (String)"No interpreter manager was available for creating a console.");
            }
            if ((interpreters = interpreterManager.getInterpreterInfos()) == null || interpreters.length == 0) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreters for creating console", (String)"No interpreter available for creating a console.");
                return null;
            }
            IInterpreterInfo interpreter = null;
            if (interpreters.length == 1) {
                interpreter = interpreters[0];
            }
            if (interpreter == null) {
                PythonNature pythonNature;
                if ("active_editor".equals(dialog.getSelectedInteractiveConsoleInterpreterRep()) && edit != null && (pythonNature = PythonNature.getPythonNature((IProject)edit.getProject())) != null) {
                    interpreter = pythonNature.getProjectInterpreter();
                }
                if (interpreter == null) {
                    SelectionDialog listDialog = AbstractInterpreterPreferencesPage.createChooseIntepreterInfoDialog((IWorkbenchWindow)workbenchWindow, (IInterpreterInfo[])interpreters, (String)"Select interpreter to be used.", (boolean)false);
                    int open = listDialog.open();
                    if (open != 0 || listDialog.getResult().length > 1) {
                        return null;
                    }
                    Object[] result = listDialog.getResult();
                    interpreter = result == null || result.length == 0 ? interpreters[0] : (IInterpreterInfo)result[0];
                }
            }
            if (interpreter == null) {
                return null;
            }
            Tuple<Collection<String>, IPythonNature> pythonpathAndNature = dialog.getPythonpathAndNature(interpreter);
            if (pythonpathAndNature == null) {
                return null;
            }
            return this.createLaunch(interpreterManager, interpreter, (Collection)pythonpathAndNature.o1, (IPythonNature)pythonpathAndNature.o2, dialog.getNatures());
        }
        return null;
    }

    public static String getEncodingFromFrame(PyStackFrame selectedFrame) {
        ILaunch launch;
        block7: {
            IProcess process;
            block6: {
                IDebugTarget adapter;
                block5: {
                    try {
                        adapter = selectedFrame.getAdapter(IDebugTarget.class);
                        if (adapter != null) break block5;
                        return "UTF-8";
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        return "UTF-8";
                    }
                }
                process = adapter.getProcess();
                if (process != null) break block6;
                return "UTF-8";
            }
            launch = process.getLaunch();
            if (launch != null) break block7;
            Log.log((String)("Unable to get launch for: " + process));
            return "UTF-8";
        }
        return PydevIProcessFactory.getEncodingFromLaunch(launch);
    }

    public static String getEncodingFromLaunch(ILaunch launch) {
        String encoding;
        block3: {
            try {
                encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
                if (encoding != null) break block3;
                Log.log((String)"Unable to get: org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING from launch.");
                return "UTF-8";
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return "UTF-8";
            }
        }
        return encoding;
    }

    private static ILaunchConfiguration createLaunchConfig() {
        ILaunchConfigurationWorkingCopy newInstance;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = manager.getLaunchConfigurationType("org.python.pydev.debug.interactiveConsoleConfigurationType");
        try {
            newInstance = launchConfigurationType.newInstance(null, manager.generateLaunchConfigurationName("PyDev Interactive Launch"));
        }
        catch (CoreException e) {
            return null;
        }
        newInstance.setAttribute("org.eclipse.debug.ui.private", true);
        return newInstance;
    }

    public PydevConsoleLaunchInfo createLaunch(IInterpreterManager interpreterManager, IInterpreterInfo interpreter, Collection<String> pythonpath, IPythonNature nature, List<IPythonNature> naturesUsed) throws Exception {
        String[] env;
        String[] cmdLine;
        String[] commandLine;
        Process process = null;
        this.naturesUsed = naturesUsed;
        Integer[] ports = SocketUtil.findUnusedLocalPorts((int)2);
        int port = ports[0];
        int clientPort = ports[1];
        Launch launch = new Launch(PydevIProcessFactory.createLaunchConfig(), "interactive", null);
        launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        launch.setAttribute(INTERACTIVE_LAUNCH_PORT, "" + port);
        File scriptWithinPySrc = CorePlugin.getScriptWithinPySrc((String)"pydevconsole.py");
        String pythonpathEnv = SimpleRunner.makePythonPathEnvFromPaths(pythonpath);
        switch (interpreterManager.getInterpreterType()) {
            case 0: {
                commandLine = SimplePythonRunner.makeExecutableCommandStr((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 2: {
                commandLine = SimpleIronpythonRunner.makeExecutableCommandStr((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 1: {
                String vmArgs = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INTERACTIVE_CONSOLE_VM_ARGS");
                commandLine = SimpleJythonRunner.makeExecutableCommandStrWithVMArgs((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String)pythonpathEnv, (String)vmArgs, (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 3: {
                commandLine = null;
                break;
            }
            default: {
                throw new RuntimeException("Expected interpreter manager to be Python or Jython or IronPython related.");
            }
        }
        String encoding = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INTERACTIVE_CONSOLE_ENCODING");
        if (encoding.trim().length() == 0) {
            encoding = "UTF-8";
        }
        if (interpreterManager.getInterpreterType() == 3) {
            process = new JythonEclipseProcess(scriptWithinPySrc.getAbsolutePath(), port, clientPort);
            cmdLine = new String[]{"Internal Jython process (no command line)"};
            env = null;
        } else {
            env = SimpleRunner.createEnvWithPythonpath((String)pythonpathEnv, (String)interpreter.getExecutableOrJar(), (IInterpreterManager)interpreterManager, (IPythonNature)nature);
            String[] s = new String[env.length + 5];
            System.arraycopy(env, 0, s, 0, env.length);
            s[s.length - 5] = "PYDEV_ECLIPSE_PID=" + PlatformUtils.getPid();
            s[s.length - 4] = "PYTHONIOENCODING=" + encoding;
            s[s.length - 3] = "PYDEV_UMD_ENABLED=" + Boolean.toString(InteractiveConsoleUMDPrefs.isUMDEnabled());
            s[s.length - 2] = "PYDEV_UMD_NAMELIST=" + InteractiveConsoleUMDPrefs.getUMDExcludeModules();
            s[s.length - 1] = "PYDEV_UMD_VERBOSE=" + Boolean.toString(InteractiveConsoleUMDPrefs.isUMDVerbose());
            env = s;
            cmdLine = commandLine;
            process = SimpleRunner.createProcess((String[])commandLine, (String[])env, null);
        }
        PydevSpawnedInterpreterProcess newProcess = new PydevSpawnedInterpreterProcess((ILaunch)launch, process, interpreter.getNameForUI(), encoding);
        launch.addProcess((IProcess)newProcess);
        return new PydevConsoleLaunchInfo(launch, process, clientPort, interpreter, null, cmdLine, env, encoding);
    }

    public static final class PydevConsoleLaunchInfo {
        public final Launch launch;
        public final Process process;
        public final int clientPort;
        public final IInterpreterInfo interpreter;
        public final PyStackFrame frame;
        public final String[] cmdLine;
        public final String[] env;
        public final String encoding;

        public PydevConsoleLaunchInfo(Launch launch, Process process, int clientPort, IInterpreterInfo interpreter, PyStackFrame frame, String[] cmdLine, String[] env, String encoding) {
            this.launch = launch;
            this.process = process;
            this.clientPort = clientPort;
            this.interpreter = interpreter;
            this.frame = frame;
            this.cmdLine = cmdLine;
            this.env = env;
            this.encoding = encoding;
        }
    }
}

