/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IExecuteLineAction;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.path_watch.IPathWatch;
import org.python.pydev.shared_core.path_watch.PathWatch;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.preferences.ScopedPreferences;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.bindings.BindKeysHelper;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class InteractiveConsoleCommand {
    public static final String USER_COMMAND_PREFIX = "org.python.pydev.custom.interactive_console.user_command.InteractiveConsoleUserCommand";
    public final String name;
    public String keybinding = "";
    public String commandText = "";
    private static final CallbackWithListeners<Object> interactiveConsoleCommandsChanged = new CallbackWithListeners();
    private static final IFilesystemChangesListener pathChangesListener = new IFilesystemChangesListener(){

        public void removed(File file) {
            interactiveConsoleCommandsChanged.call(null);
        }

        public void added(File file) {
            interactiveConsoleCommandsChanged.call(null);
        }
    };
    private static IPathWatch watcher = null;
    private static final Object lock = new Object();
    private static ICallbackListener<Object> syncCommands = new ICallbackListener<Object>(){

        public Object call(Object obj) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    InteractiveConsoleCommand.syncCommands();
                }
            };
            RunInUiThread.async((Runnable)r, (boolean)false);
            return null;
        }
    };
    private static boolean alreadyListening = false;
    public static final CallbackWithListeners<Object> onCommandIdToHandlerChanged = new CallbackWithListeners();
    private static Map<String, InteractiveCommandCustomHandler> commandIdToHandler = new HashMap<String, InteractiveCommandCustomHandler>();

    public InteractiveConsoleCommand(String name) {
        Assert.isNotNull((Object)name);
        Assert.isTrue((name.length() > 0 ? 1 : 0) != 0);
        this.name = name;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("keybinding", this.keybinding);
        map.put("commandText", this.commandText);
        return map;
    }

    public static InteractiveConsoleCommand createFromMap(Map<String, Object> map) {
        String name = (String)map.get("name");
        if (name == null || name.length() == 0) {
            return null;
        }
        String keybinding = (String)map.get("keybinding");
        if (keybinding == null) {
            return null;
        }
        String commandText = (String)map.get("commandText");
        if (commandText == null) {
            return null;
        }
        InteractiveConsoleCommand ret = new InteractiveConsoleCommand(name);
        ret.keybinding = keybinding;
        ret.commandText = commandText;
        return ret;
    }

    public static List<InteractiveConsoleCommand> loadExistingCommands() {
        ArrayList<InteractiveConsoleCommand> ret = new ArrayList<InteractiveConsoleCommand>();
        try {
            Object commands;
            IScopedPreferences scopedPreferences = InteractiveConsoleCommand.getScopedPreferences();
            File workspaceSettingsLocation = scopedPreferences.getWorkspaceSettingsLocation();
            Map contentsAsMap = scopedPreferences.getYamlFileContents(workspaceSettingsLocation);
            if (contentsAsMap != null && (commands = contentsAsMap.get("commands")) instanceof Collection) {
                Collection collection = (Collection)commands;
                for (Object object : collection) {
                    Map map;
                    InteractiveConsoleCommand created;
                    if (!(object instanceof Map) || (created = InteractiveConsoleCommand.createFromMap(map = (Map)object)) == null) continue;
                    ret.add(created);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    public static IScopedPreferences getScopedPreferences() {
        return ScopedPreferences.get((String)"org.python.pydev.interactive_console.commands");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerOnCommandsChangedCallback(ICallbackListener<Object> iCallbackListener) {
        final File workspaceSettingsLocation = InteractiveConsoleCommand.getScopedPreferences().getWorkspaceSettingsLocation();
        File folderToTrack = workspaceSettingsLocation.getParentFile();
        if (folderToTrack.exists()) {
            if (!folderToTrack.isDirectory()) {
                folderToTrack.delete();
                folderToTrack.mkdirs();
            }
        } else {
            folderToTrack.mkdirs();
        }
        interactiveConsoleCommandsChanged.registerListener(iCallbackListener);
        Object object = lock;
        synchronized (object) {
            if (watcher != null && !watcher.hasTracker(folderToTrack, pathChangesListener)) {
                watcher.dispose();
                watcher = null;
            }
            if (watcher == null) {
                watcher = new PathWatch();
                watcher.setDirectoryFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.equals(workspaceSettingsLocation);
                    }
                }, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return false;
                    }
                });
                watcher.track(folderToTrack, pathChangesListener);
            }
        }
    }

    public static void unregisterOnCommandsChangedCallback(ICallbackListener<Object> iCallbackListener) {
        interactiveConsoleCommandsChanged.unregisterListener(iCallbackListener);
    }

    public static void keepBindingsUpdated() {
        if (alreadyListening) {
            return;
        }
        alreadyListening = true;
        try {
            InteractiveConsoleCommand.registerOnCommandsChangedCallback(syncCommands);
            syncCommands.call(null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    protected static InteractiveCommandCustomHandler createHandler(InteractiveConsoleCommand interactiveConsoleCommand) {
        return new InteractiveCommandCustomHandler(interactiveConsoleCommand);
    }

    private static void syncCommands() {
        IWorkbench workbench;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Throwable e) {
            return;
        }
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        Category pydevCommandsCategory = commandService.getCategory("org.python.pydev.ui.category.source");
        if (!pydevCommandsCategory.isDefined()) {
            Log.log((String)"Expecting org.python.pydev.ui.category.source to be a a defined commands category.");
            return;
        }
        final HashSet<KeySequence> removeKeySequences = new HashSet<KeySequence>();
        List<InteractiveConsoleCommand> existingCommands = InteractiveConsoleCommand.loadExistingCommands();
        for (InteractiveConsoleCommand interactiveConsoleCommand : existingCommands) {
            try {
                removeKeySequences.add(KeyBindingHelper.getKeySequence((String)interactiveConsoleCommand.keybinding));
            }
            catch (Exception e) {
                Log.log((String)("Error resolving: " + interactiveConsoleCommand.keybinding), (Throwable)e);
            }
        }
        BindKeysHelper bindKeysHelper = new BindKeysHelper("org.python.pydev.ui.editor.scope");
        bindKeysHelper.removeUserBindingsWithFilter(new BindKeysHelper.IFilter(){

            public boolean removeBinding(Binding binding) {
                TriggerSequence triggerSequence = binding.getTriggerSequence();
                if (removeKeySequences.contains(triggerSequence)) {
                    return true;
                }
                ParameterizedCommand command = binding.getParameterizedCommand();
                if (command == null) {
                    return false;
                }
                String id = command.getId();
                return id.startsWith(InteractiveConsoleCommand.USER_COMMAND_PREFIX);
            }
        });
        HashMap<String, InteractiveCommandCustomHandler> commandIdToHandler = new HashMap<String, InteractiveCommandCustomHandler>();
        int i = 0;
        for (InteractiveConsoleCommand interactiveConsoleCommand : existingCommands) {
            try {
                KeySequence keySequence;
                String commandId = USER_COMMAND_PREFIX + i;
                Command cmd = commandService.getCommand(commandId);
                if (!cmd.isDefined()) {
                    cmd.define(interactiveConsoleCommand.name, interactiveConsoleCommand.name, pydevCommandsCategory);
                }
                InteractiveCommandCustomHandler handler = InteractiveConsoleCommand.createHandler(interactiveConsoleCommand);
                commandIdToHandler.put(commandId, handler);
                cmd.setHandler((IHandler)handler);
                try {
                    if (interactiveConsoleCommand.keybinding == null || interactiveConsoleCommand.keybinding.length() == 0) continue;
                    keySequence = KeyBindingHelper.getKeySequence((String)interactiveConsoleCommand.keybinding);
                }
                catch (IllegalArgumentException | ParseException e) {
                    Log.log((String)("Error resolving: " + interactiveConsoleCommand.keybinding), (Throwable)e);
                    continue;
                }
                bindKeysHelper.addUserBindings(keySequence, new ParameterizedCommand(cmd, null));
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            ++i;
        }
        while (i < 100) {
            Command cmd = commandService.getCommand(USER_COMMAND_PREFIX + i);
            if (cmd.isDefined()) {
                cmd.undefine();
            }
            ++i;
        }
        bindKeysHelper.saveIfChanged();
        InteractiveConsoleCommand.setCommandIdToHandler(commandIdToHandler);
    }

    private static void setCommandIdToHandler(Map<String, InteractiveCommandCustomHandler> commandIdToHandler0) {
        commandIdToHandler = commandIdToHandler0;
        onCommandIdToHandlerChanged.call(commandIdToHandler0);
    }

    public static Map<String, InteractiveCommandCustomHandler> getCommandIdToHandler() {
        return commandIdToHandler;
    }

    public boolean isValid() {
        if (this.name != null && this.name.trim().length() > 0 && this.keybinding != null && this.keybinding.trim().length() > 0 && this.commandText != null) {
            try {
                KeyBindingHelper.getKeySequence((String)this.keybinding);
            }
            catch (IllegalArgumentException | ParseException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static final class InteractiveCommandCustomHandler
    extends AbstractHandler {
        private final InteractiveConsoleCommand interactiveConsoleCommand;

        public InteractiveCommandCustomHandler(InteractiveConsoleCommand interactiveConsoleCommand) {
            this.interactiveConsoleCommand = interactiveConsoleCommand;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            Object applicationContext = event.getApplicationContext();
            if (applicationContext instanceof IEvaluationContext) {
                IEvaluationContext iEvaluationContext = (IEvaluationContext)applicationContext;
                Object activeEditor = iEvaluationContext.getVariable("activeEditor");
                if (activeEditor instanceof PyEdit) {
                    PyEdit pyEdit = (PyEdit)activeEditor;
                    this.execute(pyEdit);
                } else {
                    Log.log((String)("Expected PyEdit. Found: " + activeEditor));
                }
            }
            return null;
        }

        public void execute(PyEdit pyEdit) {
            IAction action = pyEdit.getAction("org.python.pydev.editor.actions.execLineInConsole");
            if (action instanceof IExecuteLineAction) {
                String selectedText;
                IExecuteLineAction executeLineAction = (IExecuteLineAction)action;
                String commandText = this.interactiveConsoleCommand.commandText;
                TextSelectionUtils ts = pyEdit.createTextSelectionUtils();
                try {
                    selectedText = ts.getSelectedText();
                }
                catch (BadLocationException e) {
                    selectedText = "";
                }
                if (selectedText.length() == 0) {
                    selectedText = ts.getCursorLineContents();
                }
                executeLineAction.executeText(new FastStringBuffer(commandText, selectedText.length() * 2).replaceAll("${text}", selectedText).toString());
            } else {
                Log.log((String)("Expected: " + action + " to implement IExecuteLineAction."));
            }
        }
    }
}

