/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.processfactory;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.jvnet.process_factory.AbstractProcess;
import org.jvnet.process_factory.ProcessFactory;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.ui.RunPreferencesPage;

public class PyProcessFactory
implements IProcessFactory {
    public static final String PROCESS_FACTORY_ID = "org.python.pydev.debug.processfactory.PyProcessFactory";

    public IProcess newProcess(ILaunch launch, Process process, String label, Map attributes) {
        return new RuntimeProcess(launch, (Process)new ProcessWrapper(process), label, attributes);
    }

    static class ProcessWrapper
    extends Process {
        private Process process;

        public ProcessWrapper(Process process) {
            this.process = process;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.process.waitFor();
        }

        @Override
        public int exitValue() {
            return this.process.exitValue();
        }

        @Override
        public void destroy() {
            if (RunPreferencesPage.getKillSubprocessesWhenTerminatingProcess()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            AbstractProcess p = ProcessFactory.createProcess((Process)process);
                            p.killRecursively();
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }.start();
                try {
                    this.process.waitFor(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.process.destroyForcibly();
        }
    }
}

