/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.profile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.python.pydev.debug.profile.PyProfilePreferences;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.FileFieldEditorCustom;

public class ProfileView
extends ViewPart {
    private BooleanFieldEditorCustom profileForNewLaunches;
    private FileFieldEditorCustom pyvmmonitorUiLocation;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>();

    protected void addField(FieldEditor editor, Composite parent) {
        this.addField(editor, parent, PyProfilePreferences.getTemporaryPreferenceStore());
    }

    protected void addField(final FieldEditor editor, Composite parent, IPreferenceStore preferenceStore) {
        this.fields.add(editor);
        editor.setPreferenceStore(preferenceStore);
        editor.load();
        editor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                editor.store();
            }
        });
        if (editor instanceof BooleanFieldEditorCustom) {
            editor.fillIntoGrid(parent, 2);
        } else {
            editor.fillIntoGrid(parent, 1);
        }
    }

    public void createPartControl(Composite parent) {
        Composite checkParent = new Composite(parent, 0);
        checkParent.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        checkParent.setLayout((Layout)new GridLayout(2, false));
        this.profileForNewLaunches = new BooleanFieldEditorCustom("ENABLE_PROFILING_FOR_NEW_LAUNCHES", "Enable profiling for new launches?", 1, checkParent);
        this.addField((FieldEditor)this.profileForNewLaunches, checkParent);
        String[][] ENTRIES_AND_VALUES = new String[][]{{"Deterministic (profile)", Integer.toString(1)}, {"Sampling (yappi)", Integer.toString(0)}, {"Don't start profiling", Integer.toString(2)}};
        ComboFieldEditor editor = new ComboFieldEditor("PROFILE_MODE", "Initial profile mode: ", ENTRIES_AND_VALUES, parent);
        this.addField((FieldEditor)editor, parent, PyProfilePreferences.getPermanentPreferenceStore());
        Composite composite = new Composite(parent, 0);
        GridData spacingLayoutData = new GridData();
        spacingLayoutData.heightHint = 8;
        composite.setLayoutData((Object)spacingLayoutData);
        this.pyvmmonitorUiLocation = new FileFieldEditorCustom("PYVMMONITOR_UI_LOCATION", "pyvmmonitor-ui (executable) location", parent);
        this.addField((FieldEditor)this.pyvmmonitorUiLocation, parent, PyProfilePreferences.getPermanentPreferenceStore());
        GridLayout layout = GridLayoutFactory.swtDefaults().create();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
    }

    public void setFocus() {
        this.profileForNewLaunches.getCheckBox().setFocus();
    }
}

