/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.pyunit.PyUnitViewTestsHolder;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_ui.ImageCache;

public class PinHistoryAction
extends Action {
    private WeakReference<PyUnitView> view;

    public PinHistoryAction(PyUnitView pyUnitView) {
        this.view = new WeakReference<PyUnitView>(pyUnitView);
        this.updateState();
    }

    private void setInitialTooltipText() {
        this.setToolTipText("Click to mark the currently selected run as the base-run.");
    }

    public void run() {
        try {
            if (this.isChecked()) {
                if (this.view == null) {
                    return;
                }
                PyUnitView pyUnitView = (PyUnitView)((Object)this.view.get());
                if (pyUnitView == null) {
                    return;
                }
                PyUnitTestRun currentTestRun = pyUnitView.getCurrentTestRun();
                if (currentTestRun != null) {
                    PyUnitViewTestsHolder.setCurrentPinned(currentTestRun);
                }
            } else {
                PyUnitViewTestsHolder.setCurrentPinned(null);
            }
        }
        finally {
            this.updateState();
        }
    }

    private void updateState() {
        PyUnitTestRun currentPinned = PyUnitViewTestsHolder.getCurrentPinned();
        ImageCache imageCache = PydevDebugPlugin.getImageCache();
        if (currentPinned == null) {
            if (imageCache != null) {
                this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)imageCache.getDescriptor("icons/pin.png")));
            }
            this.setInitialTooltipText();
            this.setChecked(false);
        } else {
            if (imageCache != null) {
                this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)imageCache.getDescriptor("icons/pin_arrow.png")));
            }
            this.setToolTipText("Currently pin: " + currentPinned.name + ". Click again to unpin.");
            this.setChecked(true);
        }
    }
}

