/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.PyUnitLaunch;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.pyunit.PyUnitTestStarted;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PyUnitTestRun {
    private final ArrayList<PyUnitTestResult> results;
    private final Map<Tuple<String, String>, PyUnitTestStarted> testsRunning;
    private final Object resultsLock = new Object();
    private final Object testsRunningLock = new Object();
    public final String name;
    private static int currentRun = 0;
    private static Object lock = new Object();
    private int numberOfErrors;
    private int numberOfFailures;
    private String totalNumberOfRuns = "0";
    private boolean finished;
    private IPyUnitLaunch pyUnitLaunch;
    private int nextIndex = 0;
    private String totalTime;
    public Integer savedDiskIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyUnitTestRun(IPyUnitLaunch server) {
        Object object = lock;
        synchronized (object) {
            this.name = "Test Run: " + currentRun;
            ++currentRun;
        }
        this.pyUnitLaunch = server;
        this.results = new ArrayList();
        this.testsRunning = new LinkedHashMap<Tuple<String, String>, PyUnitTestStarted>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PyUnitTestStarted> getTestsRunning() {
        Object object = this.testsRunningLock;
        synchronized (object) {
            return new ArrayList<PyUnitTestStarted>(this.testsRunning.values());
        }
    }

    public void setTotalNumberOfRuns(String totalNumberOfRuns) {
        this.totalNumberOfRuns = totalNumberOfRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addResult(PyUnitTestResult result) {
        if (result.status.equals("fail")) {
            ++this.numberOfFailures;
        } else if (result.status.equals("error")) {
            ++this.numberOfErrors;
        } else if (!result.isOk() && !result.isSkip()) {
            Log.log((String)("Unexpected status: " + result.status));
        }
        Tuple key = new Tuple((Object)result.location, (Object)result.test);
        Object object = this.testsRunningLock;
        synchronized (object) {
            this.testsRunning.remove(key);
        }
        object = this.resultsLock;
        synchronized (object) {
            this.results.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStartTest(PyUnitTestStarted result) {
        Tuple key = new Tuple((Object)result.location, (Object)result.test);
        Object object = this.testsRunningLock;
        synchronized (object) {
            this.testsRunning.put((Tuple<String, String>)key, result);
        }
    }

    public List<PyUnitTestResult> getSharedResultsList() {
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRuns() {
        Object object = this.resultsLock;
        synchronized (object) {
            return this.results.size();
        }
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public String getTotalNumberOfRuns() {
        return this.totalNumberOfRuns;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void stop() {
        IPyUnitLaunch s;
        if (this.pyUnitLaunch != null && (s = this.pyUnitLaunch) != null) {
            s.stop();
        }
    }

    public void relaunch() {
        IPyUnitLaunch s;
        if (this.pyUnitLaunch != null && (s = this.pyUnitLaunch) != null) {
            s.relaunch();
        }
    }

    public String toString() {
        return "PyUnitTestResult.\n    Finished: " + this.finished + "\n" + "    Number of runs: " + this.results.size() + "    Number of failures:" + this.numberOfFailures + "\n" + "    Number of errors: " + this.numberOfErrors + "\n";
    }

    public void relaunchOnlyErrors() {
        IPyUnitLaunch s = this.pyUnitLaunch;
        if (s != null) {
            ArrayList<PyUnitTestResult> arrayList = new ArrayList<PyUnitTestResult>(this.results.size());
            for (PyUnitTestResult pyUnitTestResult : this.results) {
                if (pyUnitTestResult.isOk() || pyUnitTestResult.isSkip()) continue;
                arrayList.add(pyUnitTestResult);
            }
            s.relaunchTestResults(arrayList);
        }
    }

    public void relaunch(List<PyUnitTestResult> resultsToRelaunch, String mode) {
        IPyUnitLaunch s = this.pyUnitLaunch;
        if (s != null) {
            s.relaunchTestResults(resultsToRelaunch, mode);
        } else {
            Log.log((String)"Unable to relaunch (the original launch is no longer available or it was not properly restored).");
        }
    }

    public synchronized String getNextTestIndex() {
        return Integer.toString(++this.nextIndex);
    }

    public void setTotalTime(String totalTime) {
        this.totalTime = totalTime;
    }

    public String getTotalTime() {
        return this.totalTime;
    }

    public String getShortDescription() {
        FastStringBuffer buf = new FastStringBuffer(this.name, 20);
        buf.append(" (");
        buf.append("Tests: ");
        buf.append(this.getTotalNumberOfRuns());
        if (this.getNumberOfErrors() > 0) {
            buf.append(" Errors: ");
            buf.append(this.getNumberOfErrors());
        }
        if (this.getNumberOfFailures() > 0) {
            buf.append(" Failures: ");
            buf.append(this.getNumberOfFailures());
        }
        buf.append(")");
        return buf.toString();
    }

    public String toXML() {
        try {
            DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
            icFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            icFactory.setFeature("http://xml.org/sax/features/validation", false);
            icFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            icFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder icBuilder = icFactory.newDocumentBuilder();
            Document document = icBuilder.newDocument();
            ProcessingInstruction version = document.createProcessingInstruction("pydev-testrun", "version=\"1.0\"");
            document.appendChild(version);
            PyUnitTestRun pyUnitTestRun = this;
            Element root = document.createElement("pydev-testsuite");
            document.appendChild(root);
            Element summary = document.createElement("summary");
            summary.setAttribute("name", this.name);
            summary.setAttribute("errors", String.valueOf(pyUnitTestRun.getNumberOfErrors()));
            summary.setAttribute("failures", String.valueOf(pyUnitTestRun.getNumberOfFailures()));
            summary.setAttribute("tests", String.valueOf(pyUnitTestRun.getTotalNumberOfRuns()));
            summary.setAttribute("finished", String.valueOf(pyUnitTestRun.getFinished()));
            summary.setAttribute("total_time", String.valueOf(pyUnitTestRun.getTotalTime()));
            root.appendChild(summary);
            for (PyUnitTestResult pyUnitTestResult : pyUnitTestRun.getResults()) {
                Element test = document.createElement("test");
                test.setAttribute("status", pyUnitTestResult.status);
                test.setAttribute("location", pyUnitTestResult.location);
                test.setAttribute("test", pyUnitTestResult.test);
                test.setAttribute("time", pyUnitTestResult.time);
                test.appendChild(XMLUtils.createBinaryElement(document, "stdout", pyUnitTestResult.capturedOutput));
                test.appendChild(XMLUtils.createBinaryElement(document, "stderr", pyUnitTestResult.errorContents));
                root.appendChild(test);
            }
            Element launchElement = document.createElement("launch");
            root.appendChild(launchElement);
            if (this.pyUnitLaunch != null) {
                this.pyUnitLaunch.fillXMLElement(document, launchElement);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return new String(s.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PyUnitTestResult> getResults() {
        ArrayList<PyUnitTestResult> lst;
        Object object = this.resultsLock;
        synchronized (object) {
            lst = new ArrayList<PyUnitTestResult>(this.results);
        }
        return lst;
    }

    public static PyUnitTestRun fromXML(String exportToClipboard) throws Exception {
        PyUnitTestRun testRun = new PyUnitTestRun(null);
        SAXParser parser = XMLUtils.getSAXParser();
        FillTestRunXmlHandler handler = new FillTestRunXmlHandler(testRun);
        parser.parse((InputStream)new ByteArrayInputStream(exportToClipboard.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)handler);
        return testRun;
    }

    IPyUnitLaunch getPyUnitLaunch() {
        return this.pyUnitLaunch;
    }

    public static class FillTestRunXmlHandler
    extends DefaultHandler {
        private final PyUnitTestRun testRun;
        private String fStatus;
        private String fLocation;
        private String fTest;
        private String fTime;
        private boolean fInStdout;
        private boolean fInStderr;
        private boolean fInLaunchMemento;
        private String fLaunchMode;
        private String fErrorContents;
        private String fCapturedOutput;
        private String fLaunchMementoContents;
        private String fCapturedErrorEncoding;
        private String fCapturedOutputEncoding;
        private String fLaunchMementoEncoding;

        public FillTestRunXmlHandler(PyUnitTestRun testRun) {
            this.testRun = testRun;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.fInStdout) {
                try {
                    this.fCapturedOutput = this.decode(new String(ch, start, length), this.fCapturedOutputEncoding);
                }
                catch (Exception exception) {}
            } else if (this.fInStderr) {
                try {
                    this.fErrorContents = this.decode(new String(ch, start, length), this.fCapturedErrorEncoding);
                }
                catch (Exception exception) {}
            } else if (this.fInLaunchMemento) {
                try {
                    this.fLaunchMementoContents = this.decode(new String(ch, start, length), this.fLaunchMementoEncoding);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("stdout".equals(qName)) {
                this.fCapturedOutputEncoding = attributes.getValue("encoding");
                this.fInStdout = true;
            } else if ("stderr".equals(qName)) {
                this.fCapturedErrorEncoding = attributes.getValue("encoding");
                this.fInStderr = true;
            } else if ("launch_memento".equals(qName)) {
                this.fLaunchMementoEncoding = attributes.getValue("encoding");
                this.fInLaunchMemento = true;
            } else if ("launch".equals(qName)) {
                this.fLaunchMode = attributes.getValue("mode");
            } else if ("test".equals(qName)) {
                this.fStatus = attributes.getValue("status");
                this.fLocation = attributes.getValue("location");
                this.fTest = attributes.getValue("test");
                this.fTime = attributes.getValue("time");
            } else if ("summary".equals(qName)) {
                String totalNumberOfRuns = attributes.getValue("tests");
                if (totalNumberOfRuns != null) {
                    this.testRun.setTotalNumberOfRuns(totalNumberOfRuns);
                }
                this.testRun.setFinished("true".equals(attributes.getValue("finished")));
                String totalTime = attributes.getValue("total_time");
                if (totalTime != null) {
                    this.testRun.setTotalTime(totalTime);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("stdout".equals(qName)) {
                this.fInStdout = false;
            } else if ("stderr".equals(qName)) {
                this.fInStderr = false;
            } else if ("launch_memento".equals(qName)) {
                this.fInLaunchMemento = false;
            } else if ("launch".equals(qName)) {
                IPyUnitLaunch fromIO;
                this.testRun.pyUnitLaunch = fromIO = PyUnitLaunch.fromIO(this.fLaunchMode, this.fLaunchMementoContents);
                this.fLaunchMementoContents = null;
            } else if ("test".equals(qName)) {
                if (this.fStatus == null) {
                    this.fStatus = "<no status>";
                }
                if (this.fLocation == null) {
                    this.fLocation = "<no location>";
                }
                if (this.fTest == null) {
                    this.fTest = "<no test>";
                }
                if (this.fTime == null) {
                    this.fTime = "<no time>";
                }
                PyUnitTestResult result = new PyUnitTestResult(this.testRun, this.fStatus, this.fLocation, this.fTest, this.fCapturedOutput == null ? "<Unable to load stdout>" : this.fCapturedOutput, this.fErrorContents == null ? "<Unable to load stderr>" : this.fErrorContents, this.fTime);
                this.testRun.addResult(result);
                this.fCapturedOutput = null;
                this.fErrorContents = null;
            } else {
                "summary".equals(qName);
            }
        }

        private String decode(String captured, String encoding) throws Exception {
            return XMLUtils.decodeFromEncoding(captured, encoding);
        }
    }
}

