/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.pyunit.PyUnitViewTestsHolder;
import org.python.pydev.debug.pyunit.SetCurrentRunAction;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_ui.ImageCache;

public class RestorePinHistoryAction
extends Action
implements ICallbackListener<PyUnitTestRun> {
    private WeakReference<PyUnitView> view;
    private PyUnitTestRun testRun;

    public RestorePinHistoryAction(PyUnitView pyUnitView) {
        this.view = new WeakReference<PyUnitView>(pyUnitView);
        this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)PydevDebugPlugin.getImageCache().getDescriptor("icons/refresh.png")));
        PyUnitViewTestsHolder.onPinSelected.registerListener((ICallbackListener)this);
        this.call(PyUnitViewTestsHolder.getCurrentPinned());
    }

    private void setInitialTooltipText() {
        this.setToolTipText("Click to restore pinned test run.");
    }

    public Object call(PyUnitTestRun obj) {
        if (obj != null) {
            this.setToolTipText("Click to restore test run: " + obj.name);
        } else {
            this.setInitialTooltipText();
        }
        this.setEnabled(obj != null);
        this.testRun = obj;
        return null;
    }

    public void run() {
        if (this.testRun != null) {
            SetCurrentRunAction setCurrentRunAction = new SetCurrentRunAction(this.view, this.testRun);
            setCurrentRunAction.run();
        }
    }
}

