/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.ui.IPyToggleBreakpointsTarget;
import org.python.pydev.debug.ui.actions.AbstractBreakpointRulerAction;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.editor_input.EditorInputUtils;
import org.python.pydev.shared_ui.utils.PyMarkerUIUtils;

public class PyBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public static final String PYDEV_BREAKPOINT = "PyDev breakpoint";
    private List<IMarker> fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;

    public PyBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo ruler) {
        this.setInfo(ruler);
        this.setTextEditor(editor);
        this.setText("Breakpoint &Properties...");
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getMarkersFromCurrentFile(true);
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            PyBreakpointRulerAction.removeMarkers(this.fMarkers);
        }
    }

    protected void addMarker() {
        IDocument document = this.getDocument();
        int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
        IToggleBreakpointsTarget adapter = (IToggleBreakpointsTarget)this.getTextEditor().getAdapter(IToggleBreakpointsTarget.class);
        if (adapter instanceof IPyToggleBreakpointsTarget) {
            IPyToggleBreakpointsTarget iPyToggleBreakpointsTarget = (IPyToggleBreakpointsTarget)adapter;
            iPyToggleBreakpointsTarget.addBreakpointMarker(document, rulerLine + 1, this.fTextEditor);
        } else {
            PyBreakpointRulerAction.addBreakpointMarker(document, rulerLine + 1, this.fTextEditor, "python-line");
        }
    }

    public static void addBreakpointMarker(IDocument document, int lineNumber, ITextEditor textEditor, final String type) {
        try {
            File file;
            if (lineNumber < 0) {
                return;
            }
            try {
                document.getLineInformation(lineNumber - 1);
            }
            catch (Exception e) {
                return;
            }
            final IResource resource = PyMarkerUIUtils.getResourceForTextEditor((ITextEditor)textEditor);
            final HashMap<String, Object> map = new HashMap<String, Object>();
            IEditorInput externalFileEditorInput = PyBreakpointRulerAction.getExternalFileEditorInput(textEditor);
            if (externalFileEditorInput == null && resource instanceof IWorkspaceRoot) {
                return;
            }
            map.put("message", PYDEV_BREAKPOINT);
            map.put("lineNumber", lineNumber);
            map.put("org.eclipse.debug.core.enabled", true);
            map.put("org.eclipse.debug.core.id", PyDebugModelPresentation.PY_DEBUG_MODEL_ID);
            map.put("org.python.pydev.debug.PY_BREAK_TYPE", type);
            if (externalFileEditorInput != null && (file = EditorInputUtils.getFile((IEditorInput)externalFileEditorInput)) != null) {
                map.put("org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID", FileUtils.getFileAbsolutePath((File)file));
            }
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker;
                    if (type.equals("django-line")) {
                        marker = resource.createMarker("org.python.pydev.debug.djangoStopBreakpointMarker");
                    } else {
                        if (!type.equals("python-line")) {
                            Log.log((String)("Error. Expected :python-line or django-line. Found: " + type + " (considered as python break type)."));
                        }
                        marker = resource.createMarker("org.python.pydev.debug.pyStopBreakpointMarker");
                    }
                    marker.setAttributes(map);
                    PyBreakpoint br = new PyBreakpoint();
                    br.setMarker(marker);
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    breakpointManager.addBreakpoint((IBreakpoint)br);
                }
            };
            resource.getWorkspace().run(runnable, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static void removeMarkers(List<IMarker> markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator<IMarker> e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint(e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, "error removing markers", e);
        }
    }
}

