/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.blocks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.PythonLabelProvider;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;

public class ProjectBlock
extends AbstractLaunchConfigurationTab {
    private Text fProjectText;
    private Button fProjectBrowseButton;
    List<ModifyListener> waitingForProjectTextToExist = new ArrayList<ModifyListener>();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjectText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjectText.setLayoutData((Object)gd);
        this.fProjectText.setFont(font);
        this.fProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjectBrowseButton = this.createPushButton((Composite)group, "Browse...", null);
        this.fProjectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                Object[] projects = workspace.getRoot().getProjects();
                ArrayList<IProject> pythonProjects = new ArrayList<IProject>();
                Object[] objectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = objectArray[n2];
                    try {
                        if (project.isOpen() && project.hasNature("org.python.pydev.pythonNature")) {
                            pythonProjects.add(project);
                        }
                    }
                    catch (CoreException exception) {
                        Log.log((Throwable)exception);
                    }
                    ++n2;
                }
                projects = pythonProjects.toArray(new IProject[pythonProjects.size()]);
                PythonLabelProvider labelProvider = new PythonLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(ProjectBlock.this.getShell(), (ILabelProvider)labelProvider);
                dialog.setTitle("Project selection");
                dialog.setMessage("Choose a project for the run");
                dialog.setElements(projects);
                dialog.open();
                Object object = dialog.getFirstResult();
                if (object != null && object instanceof IProject) {
                    IProject project = (IProject)object;
                    PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
                    if (pythonNature == null) {
                        String msg = "The selected project must have the python nature associated.";
                        String title = "Invalid project (no python nature associated).";
                        ErrorDialog.openError((Shell)ProjectBlock.this.getShell(), (String)title, (String)msg, (IStatus)SharedCorePlugin.makeStatus((int)2, (String)title, null));
                    }
                    String projectName = project.getName();
                    ProjectBlock.this.fProjectText.setText(projectName);
                }
                ProjectBlock.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public String getName() {
        return "Project";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String projectName = "";
        try {
            projectName = configuration.getAttribute("org.python.pydev.debug.ATTR_PROJECT", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fProjectText.setText(projectName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fProjectText.getText().trim();
        this.setAttribute(configuration, "org.python.pydev.debug.ATTR_PROJECT", value);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = super.isValid(launchConfig);
        if (result) {
            IProject project;
            PythonNature nature;
            this.setErrorMessage(null);
            this.setMessage(null);
            String projectName = this.fProjectText.getText();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IResource resource = workspace.getRoot().findMember(projectName);
            if (resource == null) {
                this.setErrorMessage("Invalid project");
                result = false;
            } else if (resource instanceof IProject && (nature = PythonNature.getPythonNature((IProject)(project = (IProject)resource))) == null) {
                this.setErrorMessage("Invalid project (no python nature associated).");
                result = false;
            }
        }
        return result;
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy configuration, String name, String value) {
        if (value == null || value.length() == 0) {
            configuration.setAttribute(name, null);
        } else {
            configuration.setAttribute(name, value);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.fProjectText == null) {
            this.waitingForProjectTextToExist.add(listener);
        } else {
            this.fProjectText.addModifyListener(listener);
            for (ModifyListener l : this.waitingForProjectTextToExist) {
                this.fProjectText.addModifyListener(l);
            }
            this.waitingForProjectTextToExist.clear();
        }
    }
}

