/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.model.remote.RemoteDebugger;
import org.python.pydev.debug.pyunit.IPyUnitServer;
import org.python.pydev.debug.pyunit.PyUnitServer;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.ui.launching.PythonRunnerCallbacks;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.process.ProcessUtils;

public class PythonRunner {
    public static final CallbackWithListeners<IPyUnitServer> onPyUnitServerCreated = new CallbackWithListeners();

    public static void run(PythonRunnerConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            PyUnitServer pyUnitServer = null;
            if (config.isUnittest()) {
                pyUnitServer = config.createPyUnitServer(config, launch);
                onPyUnitServerCreated.call((Object)pyUnitServer);
                PyUnitView.registerPyUnitServer(pyUnitServer);
            }
            if (config.isDebug) {
                PythonRunner.runDebug(config, launch, monitor);
            } else {
                PythonRunner.doIt(config, monitor, config.envp, config.getCommandLine(true), config.workingDirectory, launch);
            }
        }
        catch (JDTNotAvailableException e) {
            Log.log((Throwable)e);
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Unable to run the selected configuration.", (String)e.getMessage());
                }
            });
        }
    }

    private static void runDebug(final PythonRunnerConfig config, final ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException, JDTNotAvailableException {
        IProcess process;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        final RemoteDebugger debugger = new RemoteDebugger();
        final ListenConnector listenConnector = debugger.startConnect((IProgressMonitor)subMonitor, config);
        subMonitor.subTask("Constructing command_line...");
        String[] cmdLine = config.getCommandLine(true);
        Process p = PythonRunner.createProcess(launch, config.envp, cmdLine, config.workingDirectory);
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_CMDLINE, config.getCommandLineAsString());
        processAttributes.put("PYDEV_DEBUG_IPROCESS_ATTR", "true");
        PyDebugTarget t = new PyDebugTarget(launch, null, config.resource, debugger, config.project);
        try {
            t.process = process = PythonRunner.registerWithDebugPluginForProcessType(config.getConsoleLabel(cmdLine), launch, p, processAttributes, config);
        }
        finally {
            t.finishedInit = true;
        }
        subMonitor.subTask("Waiting for connection...");
        Socket socket = null;
        try {
            socket = debugger.waitForConnect((IProgressMonitor)subMonitor, p, process);
            if (socket == null) {
                debugger.dispose();
                return;
            }
        }
        catch (Exception ex) {
            process.terminate();
            p.destroy();
            String message = "Unexpected error setting up the debugger";
            if (ex instanceof SocketTimeoutException) {
                message = "Timed out after " + Float.toString(config.acceptTimeout / 1000) + " seconds while waiting for python script to connect.";
            }
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
        }
        subMonitor.subTask("Done");
        launch.setSourceLocator((ISourceLocator)new PySourceLocator());
        t.startTransmission(socket);
        t.initialize();
        t.addConsoleInputListener();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    listenConnector.setTimeout(0);
                    while (!launch.isTerminated() && !listenConnector.isDisposed()) {
                        Socket socket = listenConnector.waitForConnection();
                        if (socket == null || socket.isClosed()) continue;
                        PyDebugTarget t = new PyDebugTarget(launch, process, config.resource, debugger, config.project, true);
                        try {
                            t.startTransmission(socket);
                            t.initialize();
                        }
                        catch (IOException e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
                catch (SocketException socket) {
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static IProcess doIt(PythonRunnerConfig config, IProgressMonitor monitor, String[] envp, String[] cmdLine, File workingDirectory, ILaunch launch) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        subMonitor.subTask("Constructing command_line...");
        String commandLineAsString = SimpleRunner.getArgumentsAsStr((String[])cmdLine, (String[])new String[0]);
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_CMDLINE, commandLineAsString);
        subMonitor.subTask("Exec...");
        Process p = PythonRunner.createProcess(launch, envp, cmdLine, workingDirectory);
        String label = config.getConsoleLabel(cmdLine);
        if (config.isInteractive) {
            throw new RuntimeException("Interactive not supported here!");
        }
        IProcess process = PythonRunner.registerWithDebugPluginForProcessType(label, launch, p, processAttributes, config);
        subMonitor.subTask("Done");
        return process;
    }

    private static Process createProcess(ILaunch launch, String[] envp, String[] cmdLine, File workingDirectory) throws CoreException {
        Process p;
        Map arrayAsMapEnv = ProcessUtils.getArrayAsMapEnv((String[])envp);
        arrayAsMapEnv.put("PYTHONUNBUFFERED", "1");
        arrayAsMapEnv.put("PYDEV_COMPLETER_PYTHONPATH", CorePlugin.getBundleInfo().getRelativePath((IPath)new Path("pysrc")).toString());
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null && encoding.trim().length() > 0) {
            arrayAsMapEnv.put("PYDEV_CONSOLE_ENCODING", encoding);
            arrayAsMapEnv.put("PYTHONIOENCODING", encoding);
        }
        if ((p = DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])(envp = ProcessUtils.getMapEnvAsArray((Map)arrayAsMapEnv)))) == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Could not execute python process.", null));
        }
        PythonRunnerCallbacks.afterCreatedProcess.call((Object)p);
        return p;
    }

    private static IProcess registerWithDebugPluginForProcessType(String label, ILaunch launch, Process p, Map<String, String> processAttributes, PythonRunnerConfig config) {
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, config.getProcessType());
        processAttributes.put(IProcess.ATTR_PROCESS_LABEL, label);
        processAttributes.put("PYDEV_CONFIG_RUN", config.run);
        processAttributes.put("PYDEV_ADD_RELAUNCH_IPROCESS_ATTR", "true");
        processAttributes.put("org.eclipse.debug.core.capture_output", "true");
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        boolean found = false;
        try {
            String attribute = launchConfiguration.getAttribute("process_factory_id", null);
            found = "org.python.pydev.debug.processfactory.PyProcessFactory".equals(attribute);
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
        if (!found) {
            try {
                ILaunchConfigurationWorkingCopy workingCopy = launchConfiguration.getWorkingCopy();
                workingCopy.setAttribute("process_factory_id", "org.python.pydev.debug.processfactory.PyProcessFactory");
                workingCopy.doSave();
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        return DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, processAttributes);
    }
}

