/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.propertypages;

import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.core.partition.PyPartitioner;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.ui.PythonSourceViewer;
import org.python.pydev.debug.ui.propertypages.PythonBreakpointPage;

public class BreakpointConditionEditor {
    private boolean fIsValid;
    private String fOldValue;
    private String fErrorMessage;
    private HandlerSubmission submission;
    private IDocumentListener fDocumentListener;
    private PythonBreakpointPage fPage;
    private PyBreakpoint fBreakpoint;
    private PythonSourceViewer fViewer;

    public BreakpointConditionEditor(Composite parent, PythonBreakpointPage page) {
        String condition;
        this.fPage = page;
        this.fBreakpoint = this.fPage.getBreakpoint();
        try {
            condition = this.fBreakpoint.getCondition();
        }
        catch (DebugException e) {
            PydevDebugPlugin.log(4, "Can't read conditions", e);
            return;
        }
        this.fErrorMessage = "Enter a condition";
        this.fOldValue = "";
        this.fViewer = new PythonSourceViewer(parent, null, 2816);
        this.fViewer.setInput(parent);
        Document document = new Document();
        PyPartitioner partitioner = new PyPartitioner(new PyPartitionScanner(), IPythonPartitions.types);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)document);
        this.fViewer.setEditable(true);
        this.fViewer.setDocument((IDocument)document);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(100);
        this.fViewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.fViewer);
        this.fViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                BreakpointConditionEditor.this.valueChanged();
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        gd = (GridData)this.fViewer.getControl().getLayoutData();
        gd.heightHint = this.fPage.convertHeightInCharsToPixels(10);
        gd.widthHint = this.fPage.convertWidthInCharsToPixels(40);
        document.set(condition);
        this.valueChanged();
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(Map parameter) throws ExecutionException {
                BreakpointConditionEditor.this.fViewer.doOperation(13);
                return null;
            }
        };
        this.submission = new HandlerSubmission(null, parent.getShell(), null, "org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler, Priority.MEDIUM);
    }

    public String getCondition() {
        return this.fViewer.getDocument().get();
    }

    protected void refreshValidState() {
        if (!this.fViewer.isEditable()) {
            this.fPage.removeErrorMessage(this.fErrorMessage);
            this.fIsValid = true;
        } else {
            String text = this.fViewer.getDocument().get();
            boolean bl = this.fIsValid = text != null && text.trim().length() > 0;
            if (!this.fIsValid) {
                this.fPage.addErrorMessage(this.fErrorMessage);
            } else {
                this.fPage.removeErrorMessage(this.fErrorMessage);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            this.fViewer.getTextWidget().setFocus();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.addHandlerSubmission(this.submission);
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.removeHandlerSubmission(this.submission);
        }
        this.valueChanged();
    }

    protected void valueChanged() {
        this.refreshValidState();
        String newValue = this.fViewer.getDocument().get();
        if (!newValue.equals(this.fOldValue)) {
            this.fOldValue = newValue;
        }
    }

    public void dispose() {
        if (this.fViewer.isEditable()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchCommandSupport commandSupport = workbench.getCommandSupport();
            commandSupport.removeHandlerSubmission(this.submission);
        }
        this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fViewer.dispose();
    }
}

