/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.ui.propertypages.BreakpointConditionEditor;
import org.python.pydev.shared_core.string.StringUtils;

public class PythonBreakpointPage
extends PropertyPage {
    private Button fEnableConditionButton;
    private BreakpointConditionEditor fConditionEditor;
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Button fSuspendThreadButton;
    protected Button fSuspendVMButton;
    protected Text fHitCountText;
    protected List<String> fErrorMessages = new ArrayList<String>();
    public static final String ATTR_DELETE_ON_CANCEL = String.valueOf(PyDebugModelPresentation.PY_DEBUG_MODEL_ID) + ".ATTR_DELETE_ON_CANCEL";

    public String getTitle() {
        return "Line Breakpoint";
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        this.createLabels(mainComposite);
        try {
            this.createEnabledButton(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, e.getLocalizedMessage(), e);
        }
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(StringUtils.format((String)"Create Breakpoint for %s", (Object[])new Object[]{PythonBreakpointPage.this.getName((IAdaptable)PythonBreakpointPage.this.getBreakpoint())}));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return mainComposite;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composit = new Composite(parent, 0);
        composit.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composit.setLayout((Layout)layout);
        composit.setLayoutData((Object)new GridData(768));
        return composit;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    protected void createLabels(Composite parent) {
        PyBreakpoint breakpoint = (PyBreakpoint)this.getElement();
        Composite labelComposite = this.createComposite(parent, 2);
        String typeName = breakpoint.getFile();
        if (typeName != null) {
            this.createLabel(labelComposite, "File");
            this.createLabel(labelComposite, typeName);
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, "&Enabled");
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected void createTypeSpecificLabels(Composite parent) {
        PyBreakpoint breakpoint = this.getBreakpoint();
        StringBuffer lineNumber = new StringBuffer(4);
        try {
            int lNumber = breakpoint.getLineNumber();
            if (lNumber > 0) {
                lineNumber.append(lNumber);
            }
        }
        catch (CoreException ce) {
            PydevDebugPlugin.log(4, ce.getLocalizedMessage(), ce);
        }
        if (lineNumber.length() > 0) {
            this.createLabel(parent, "&Line Number:");
            this.createLabel(parent, lineNumber.toString());
        }
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
        PyBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint.supportsCondition()) {
            this.createConditionEditor(parent);
        }
    }

    protected Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 16416);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected PyBreakpoint getBreakpoint() {
        return (PyBreakpoint)this.getElement();
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getLabel((Object)element);
        }
        return "";
    }

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                PyBreakpoint breakpoint = PythonBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                PythonBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("An exception occurred while saving breakpoint properties.", e);
            PydevDebugPlugin.log(4, e.getLocalizedMessage(), e);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Unable to cancel breakpoint creation", e);
        }
        return super.performCancel();
    }

    protected void doStore() throws CoreException {
        PyBreakpoint breakpoint = this.getBreakpoint();
        this.storeEnabled(breakpoint);
        if (this.fConditionEditor != null) {
            boolean enableCondition = this.fEnableConditionButton.getSelection();
            String condition = this.fConditionEditor.getCondition();
            if (breakpoint.isConditionEnabled() != enableCondition) {
                breakpoint.setConditionEnabled(enableCondition);
            }
            if (!condition.equals(breakpoint.getCondition())) {
                breakpoint.setCondition(condition);
            }
        }
    }

    private void storeEnabled(PyBreakpoint breakpoint) throws CoreException {
        boolean enabled = this.fEnabledButton.getSelection();
        breakpoint.setEnabled(enabled);
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        List keyBindings;
        PyBreakpoint breakpoint = this.getBreakpoint();
        String label = null;
        ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        ICommand command = commandManager.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (command != null && (keyBindings = command.getKeySequenceBindings()) != null && keyBindings.size() > 0) {
            IKeySequenceBinding binding = (IKeySequenceBinding)keyBindings.get(0);
            label = StringUtils.format((String)"E&nable Condition %s", (Object[])new Object[]{binding.getKeySequence().format()});
        }
        if (label == null) {
            label = "E&nable Condition (code assist not available)";
        }
        Group conditionComposite = new Group(parent, 0);
        conditionComposite.setFont(parent.getFont());
        conditionComposite.setLayoutData((Object)new GridData(768));
        conditionComposite.setLayout((Layout)new GridLayout());
        this.fEnableConditionButton = this.createCheckButton((Composite)conditionComposite, label);
        this.fEnableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.fEnableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PythonBreakpointPage.this.setConditionEnabled(PythonBreakpointPage.this.fEnableConditionButton.getSelection());
            }
        });
        this.fConditionEditor = new BreakpointConditionEditor((Composite)conditionComposite, this);
        this.setConditionEnabled(this.fEnableConditionButton.getSelection());
    }

    public void dispose() {
        super.dispose();
        this.fConditionEditor.dispose();
    }

    private void setConditionEnabled(boolean enabled) {
        this.fConditionEditor.setEnabled(enabled);
    }

    public int convertHeightInCharsToPixels(int chars) {
        return super.convertHeightInCharsToPixels(chars);
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }

    public void addErrorMessage(String message) {
        if (message == null) {
            return;
        }
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(false);
    }

    public void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }
}

