/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.actions;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.codecompletion.PyCodeCompletionImages;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.AbstractPyRefactoring;
import org.python.pydev.ast.refactoring.IPyRefactoring;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.ast.refactoring.TooManyMatchesException;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.parser.PyParser;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;

public class PyGoToDefinition
extends PyRefactorAction {
    protected boolean areRefactorPreconditionsOK(RefactoringRequest request) {
        return true;
    }

    public void run(IAction action) {
        this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart[] dirtyEditors = this.workbenchWindow.getActivePage().getDirtyEditors();
        HashSet<PyEdit> askReparse = new HashSet<PyEdit>();
        IEditorPart[] iEditorPartArray = dirtyEditors;
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart iEditorPart = iEditorPartArray[n2];
            if (iEditorPart instanceof PyEdit) {
                PyEdit pyEdit = (PyEdit)iEditorPart;
                long astModificationTimeStamp = pyEdit.getAstModificationTimeStamp();
                IDocument doc = pyEdit.getDocument();
                if (astModificationTimeStamp == -1L || astModificationTimeStamp != ((IDocumentExtension4)doc).getModificationStamp()) {
                    askReparse.add(pyEdit);
                }
            }
            ++n2;
        }
        if (askReparse.size() == 0) {
            this.findDefinitionsAndOpen(true);
        } else {
            Object lock = new Object();
            for (PyEdit pyEdit : askReparse) {
                FindParserObserver observer = new FindParserObserver(pyEdit, askReparse, lock);
                PyParser parser = pyEdit.getParser();
                parser.addParseListener((IParserObserver)observer);
                parser.forceReparse(new Object[0]);
            }
        }
    }

    public ItemPointer[] findDefinitionsAndOpen(boolean doOpenDefinition) {
        RefactoringRequest refactoringRequest;
        this.request = null;
        this.ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this.getTextEditor());
        PyEdit pyEdit = this.getPyEdit();
        try {
            refactoringRequest = this.getRefactoringRequest();
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return new ItemPointer[0];
        }
        Shell shell = EditorUtils.getShell();
        try {
            if (this.areRefactorPreconditionsOK(refactoringRequest)) {
                boolean retry;
                boolean acceptTypeshed = false;
                boolean findInAdditionalInfo = false;
                ItemPointer[] defs = this.findDefinition(pyEdit, acceptTypeshed, findInAdditionalInfo);
                boolean bl = retry = defs == null || defs.length == 0;
                if (!retry && defs.length == 1) {
                    if (defs[0].definition == null) {
                        retry = true;
                    } else if (defs[0].definition.module == null) {
                        retry = true;
                    } else if (defs[0].definition.module.getFile() == null) {
                        retry = true;
                    }
                }
                if (retry) {
                    acceptTypeshed = true;
                    findInAdditionalInfo = true;
                    defs = this.findDefinition(pyEdit, acceptTypeshed, findInAdditionalInfo);
                }
                if (doOpenDefinition) {
                    PyGoToDefinition.openDefinition(defs, pyEdit, shell);
                }
                return defs;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = "Unable to get error msg (null)";
            }
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Unable to do requested action", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, msg, (Throwable)e));
        }
        return null;
    }

    public static void openDefinition(ItemPointer[] defs, final PyEdit pyEdit, final Shell shell) {
        if (defs == null) {
            shell.getDisplay().beep();
            return;
        }
        HashSet<ItemPointer> set = new HashSet<ItemPointer>();
        ItemPointer[] itemPointerArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer pointer = itemPointerArray[n2];
            if (pointer.file != null) {
                set.add(pointer);
            }
            ++n2;
        }
        final ItemPointer[] where = set.toArray(new ItemPointer[0]);
        if (where == null) {
            shell.getDisplay().beep();
            return;
        }
        if (where.length > 0) {
            if (where.length == 1) {
                ItemPointer itemPointer = where[0];
                PyGoToDefinition.doOpen(itemPointer, pyEdit, shell);
            } else {
                Display disp = shell.getDisplay();
                disp.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, new ILabelProvider(){

                            public Image getImage(Object element) {
                                return ImageCache.asImage((IImageHandle)PyCodeCompletionImages.getImageForType((int)6));
                            }

                            public String getText(Object element) {
                                ItemPointer pointer = (ItemPointer)element;
                                File f = (File)pointer.file;
                                int line = pointer.start.line;
                                return String.valueOf(f.getName()) + "  (" + f.getParent() + ") - line:" + line;
                            }

                            public void addListener(ILabelProviderListener listener) {
                            }

                            public void dispose() {
                            }

                            public boolean isLabelProperty(Object element, String property) {
                                return false;
                            }

                            public void removeListener(ILabelProviderListener listener) {
                            }
                        }){

                            protected Control createContents(Composite parent) {
                                Control ret = super.createContents(parent);
                                PydevPlugin.setCssId((Object)parent, (String)"py-go-to-definition-dialog", (boolean)true);
                                return ret;
                            }

                            public boolean isHelpAvailable() {
                                return false;
                            }

                            protected void updateStatus(IStatus status) {
                                super.updateStatus(status);
                                PydevPlugin.fixSelectionStatusDialogStatusLineColor((Object)((Object)this), (Color)this.getDialogArea().getBackground());
                            }
                        };
                        dialog.setTitle("Found matches");
                        dialog.setTitle("Select the one you believe matches most your search.");
                        dialog.setElements((Object[])where);
                        dialog.open();
                        Object[] result = dialog.getResult();
                        if (result != null && result.length > 0) {
                            PyGoToDefinition.doOpen((ItemPointer)result[0], pyEdit, shell);
                        }
                    }
                });
            }
        } else {
            shell.getDisplay().beep();
        }
    }

    private static void doOpen(ItemPointer itemPointer, PyEdit pyEdit, Shell shell) {
        new PyOpenAction().run(itemPointer, pyEdit.getProject(), pyEdit.getSite());
    }

    public ItemPointer[] findDefinition(PyEdit pyEdit, boolean acceptTypeshed, boolean findInAdditionalInfo) throws TooManyMatchesException, MisconfigurationException, BadLocationException {
        IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
        RefactoringRequest refactoringRequest = this.getRefactoringRequest();
        refactoringRequest.acceptTypeshed = acceptTypeshed;
        refactoringRequest.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)findInAdditionalInfo);
        return pyRefactoring.findDefinition(refactoringRequest);
    }

    protected String perform(IAction action, IProgressMonitor monitor) throws Exception {
        return null;
    }

    private class FindParserObserver
    implements IParserObserver {
        private Object lock;
        private Set<PyEdit> askReparse;
        private PyEdit editToReparse;

        public FindParserObserver(PyEdit editToReparse, Set<PyEdit> askReparse, Object lock) {
            this.editToReparse = editToReparse;
            this.askReparse = askReparse;
            this.lock = lock;
        }

        public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc, long docModificationStamp) {
            this.editToReparse.getParser().removeParseListener((IParserObserver)this);
            this.doFindIfLast();
        }

        public void parserError(Throwable error, IAdaptable file, IDocument doc) {
            this.editToReparse.getParser().removeParseListener((IParserObserver)this);
            this.doFindIfLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFindIfLast() {
            Object object = this.lock;
            synchronized (object) {
                this.askReparse.remove(this.editToReparse);
                if (this.askReparse.size() > 0) {
                    return;
                }
            }
            UIJob job = new UIJob("Find"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        PyGoToDefinition.this.findDefinitionsAndOpen(true);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.schedule();
        }
    }
}

