/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.search.SearchMessages;

public class EditorOpener {
    private IEditorReference fReusedEditor;

    public IEditorPart open(IWorkbenchPage wbPage, IFile file, boolean activate) throws PartInitException {
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(file, wbPage, this.getEditorID(file), activate);
        }
        return this.showWithoutReuse(file, wbPage, this.getEditorID(file), activate);
    }

    public IEditorPart openAndSelect(IWorkbenchPage wbPage, IFile file, int offset, int length, boolean activate) throws PartInitException {
        String editorId = null;
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        editorId = desc == null || !desc.isInternal() ? "org.eclipse.ui.DefaultTextEditor" : desc.getId();
        IEditorPart editor = NewSearchUI.reuseEditor() ? this.showWithReuse(file, wbPage, editorId, activate) : this.showWithoutReuse(file, wbPage, editorId, activate);
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            this.showWithMarker(editor, file, offset, length);
        }
        return editor;
    }

    private IEditorPart showWithoutReuse(IFile file, IWorkbenchPage wbPage, String editorID, boolean activate) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)wbPage, (IFile)file, (String)editorID, (boolean)activate);
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return PydevPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private IEditorPart showWithReuse(IFile file, IWorkbenchPage page, String editorId, boolean activate) throws PartInitException {
        IEditorReference reference;
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
            if (activate) {
                page.activate((IWorkbenchPart)editor);
            }
            return editor;
        }
        IEditorReference reusedEditorRef = this.fReusedEditor;
        if (reusedEditorRef != null) {
            boolean canBeReused;
            boolean isOpen = reusedEditorRef.getEditor(false) != null;
            boolean bl = canBeReused = isOpen && !reusedEditorRef.isDirty() && !reusedEditorRef.isPinned();
            if (canBeReused) {
                boolean showsSameInputType = reusedEditorRef.getId().equals(editorId);
                if (!showsSameInputType) {
                    page.closeEditors(new IEditorReference[]{reusedEditorRef}, false);
                    this.fReusedEditor = null;
                } else {
                    editor = reusedEditorRef.getEditor(true);
                    if (editor instanceof IReusableEditor) {
                        ((IReusableEditor)editor).setInput((IEditorInput)input);
                        page.bringToTop((IWorkbenchPart)editor);
                        if (activate) {
                            page.activate((IWorkbenchPart)editor);
                        }
                        return editor;
                    }
                }
            }
        }
        this.fReusedEditor = (editor = page.openEditor((IEditorInput)input, editorId, activate)) instanceof IReusableEditor ? (reference = (IEditorReference)page.getReference((IWorkbenchPart)editor)) : null;
        return editor;
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        IMarker marker = null;
        try {
            try {
                marker = file.createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
                attributes.put("charStart", offset);
                attributes.put("charEnd", offset + length);
                marker.setAttributes(attributes);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
            catch (CoreException e) {
                throw new PartInitException(SearchMessages.FileSearchPage_error_marker, (Throwable)e);
            }
        }
        finally {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

