/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.copied.BasicElementLabels;
import com.python.pydev.refactoring.refactorer.search.copied.FileMatch;
import com.python.pydev.refactoring.refactorer.search.copied.LineElement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.search.SearchMessages;

public class FileLabelProvider
extends LabelProvider {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    private static final String fgSeparatorFormat = "{0} - {1}";
    private static final String fgEllipses = " ... ";
    private final WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
    private final AbstractTextSearchViewPage fPage;
    private final Comparator<FileMatch> fMatchComparator;
    private final Image fLineMatchImage;
    private int fOrder;
    private static final int MIN_MATCH_CONTEXT = 10;

    public FileLabelProvider(AbstractTextSearchViewPage page, int orderFlag) {
        this.fOrder = orderFlag;
        this.fPage = page;
        this.fLineMatchImage = ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/line_match.gif"));
        this.fMatchComparator = new Comparator<FileMatch>(){

            @Override
            public int compare(FileMatch o1, FileMatch o2) {
                return o1.getOriginalOffset() - o2.getOriginalOffset();
            }
        };
    }

    public void setOrder(int orderFlag) {
        this.fOrder = orderFlag;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public String getText(Object object) {
        return this.getStyledText(object);
    }

    public String getStyledText(Object element) {
        if (element instanceof LineElement) {
            return this.getLineElementLabel((LineElement)element);
        }
        if (!(element instanceof IResource)) {
            return new String();
        }
        IResource resource = (IResource)element;
        if (!resource.exists()) {
            new String(SearchMessages.FileLabelProvider_removed_resource_label);
        }
        String name = BasicElementLabels.getResourceName(resource);
        if (this.fOrder == 1) {
            return this.getColoredLabelWithCounts(resource, new String(name));
        }
        String pathString = BasicElementLabels.getPathLabel(resource.getParent().getFullPath(), false);
        if (this.fOrder == 2) {
            String str = new String(name);
            return this.getColoredLabelWithCounts(resource, str);
        }
        String str = new String(MessageFormat.format(fgSeparatorFormat, pathString, name));
        return this.getColoredLabelWithCounts(resource, str);
    }

    private String getLineElementLabel(LineElement lineElement) {
        int lineNumber = lineElement.getLine();
        String lineNumberString = MessageFormat.format(SearchMessages.FileLabelProvider_line_number, lineNumber);
        String str = new String(lineNumberString);
        Match[] matches = lineElement.getMatches(this.fPage.getInput());
        Arrays.sort(matches, this.fMatchComparator);
        String content = lineElement.getContents();
        int pos = this.evaluateLineStart(matches, content, lineElement.getOffset());
        int length = content.length();
        int charsToCut = this.getCharsToCut(length, matches);
        int i = 0;
        while (i < matches.length) {
            Match match = matches[i];
            int start = Math.max(match.getOriginalOffset() - lineElement.getOffset(), 0);
            if (pos < start) {
                if (charsToCut > 0) {
                    charsToCut = this.appendShortenedGap(content, pos, start, charsToCut, i == 0, str);
                } else {
                    str = String.valueOf(str) + content.substring(pos, start);
                }
            }
            int end = Math.min(match.getOriginalOffset() + match.getOriginalLength() - lineElement.getOffset(), lineElement.getLength());
            str = String.valueOf(str) + content.substring(start, end);
            pos = end;
            ++i;
        }
        if (charsToCut > 0) {
            this.appendShortenedGap(content, pos, length, charsToCut, false, str);
        } else {
            str = String.valueOf(str) + content.substring(pos);
        }
        return str;
    }

    private int appendShortenedGap(String content, int start, int end, int charsToCut, boolean isFirst, String str) {
        int gapLength = end - start;
        if (!isFirst) {
            gapLength -= 10;
        }
        if (end < content.length()) {
            gapLength -= 10;
        }
        if (gapLength < 10) {
            str = String.valueOf(str) + content.substring(start, end);
            return charsToCut;
        }
        int context = 10;
        if (gapLength > charsToCut) {
            context += gapLength - charsToCut;
        }
        if (!isFirst) {
            str = String.valueOf(str) + content.substring(start, start + context);
            context = 10;
        }
        str = String.valueOf(str) + fgEllipses;
        if (end < content.length()) {
            str = String.valueOf(str) + content.substring(end - context, end);
        }
        return charsToCut - gapLength + fgEllipses.length();
    }

    private int getCharsToCut(int contentLength, Match[] matches) {
        if (contentLength <= 256 || !"win32".equals(SWT.getPlatform()) || matches.length == 0) {
            return 0;
        }
        return contentLength - 256 + Math.max(matches.length * fgEllipses.length(), 100);
    }

    private int evaluateLineStart(Match[] matches, String lineContent, int lineOffset) {
        FileMatch match;
        int max = lineContent.length();
        if (matches.length > 0 && (max = (match = (FileMatch)matches[0]).getOriginalOffset() - lineOffset) < 0) {
            return 0;
        }
        int i = 0;
        while (i < max) {
            char ch = lineContent.charAt(i);
            if (!Character.isWhitespace(ch) || ch == '\n' || ch == '\r') {
                return i;
            }
            ++i;
        }
        return max;
    }

    private String getColoredLabelWithCounts(Object element, String coloredName) {
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result == null) {
            return coloredName;
        }
        int matchCount = result.getMatchCount(element);
        if (matchCount <= 1) {
            return coloredName;
        }
        String countInfo = MessageFormat.format(SearchMessages.FileLabelProvider_count_format, matchCount);
        coloredName = String.valueOf(coloredName) + " ";
        coloredName = String.valueOf(coloredName) + countInfo;
        return coloredName;
    }

    public Image getImage(Object element) {
        if (element instanceof LineElement) {
            return this.fLineMatchImage;
        }
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
    }
}

