/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.copied.FileMatch;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.shared_ui.search.ICustomLineElement;

public class LineElement
implements ICustomLineElement {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;
    private final int fColumn;

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents, int column) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
        this.fColumn = column;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public IResource getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public FileMatch[] getMatches(AbstractTextSearchResult result) {
        ArrayList<FileMatch> res = new ArrayList<FileMatch>();
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            FileMatch curr = (FileMatch)matches[i];
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new FileMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        int count = 0;
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            FileMatch curr = (FileMatch)matches[i];
            if (curr.getLineElement() == this) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

