/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.refactoring.tdd.AbstractPyCreateClassOrMethodOrField;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyCreateMethodOrField
extends AbstractPyCreateClassOrMethodOrField {
    public static final int BOUND_METHOD = 0;
    public static final int CLASSMETHOD = 1;
    public static final int STATICMETHOD = 2;
    public static final int FIELD = 3;
    public static final int CONSTANT = 4;
    private String createInClass;
    private int createAs;

    @Override
    public String getCreationStr() {
        if (this.createAs == 3) {
            return "field";
        }
        if (this.createAs == 4) {
            return "constant";
        }
        return "method";
    }

    @Override
    public ICompletionProposalHandle createProposal(RefactoringInfo refactoringInfo, String actTok, int locationStrategy, List<String> parametersAfterCall) {
        Tuple<Integer, String> offsetAndIndent;
        PySelection pySelection = refactoringInfo.getPySelection();
        ModuleAdapter moduleAdapter = refactoringInfo.getModuleAdapter();
        String decorators = "";
        IClassDefAdapter targetClass = null;
        String body = "${pass}";
        if (this.createInClass != null) {
            List classes = moduleAdapter.getClasses();
            for (IClassDefAdapter iClassDefAdapter : classes) {
                if (!this.createInClass.equals(iClassDefAdapter.getName())) continue;
                targetClass = iClassDefAdapter;
                break;
            }
            if (targetClass != null) {
                switch (this.createAs) {
                    case 0: {
                        parametersAfterCall = this.checkFirst(parametersAfterCall, "self");
                        break;
                    }
                    case 1: {
                        parametersAfterCall = this.checkFirst(parametersAfterCall, "cls");
                        decorators = "@classmethod\n";
                        break;
                    }
                    case 2: {
                        decorators = "@staticmethod\n";
                        break;
                    }
                    case 4: {
                        String indent = targetClass.getNodeBodyIndent();
                        Pass replacePassStatement = this.getLastPassFromNode(targetClass.getASTNode());
                        String constant = StringUtils.format((String)"\n%s = ${None}${cursor}\n", (Object[])new Object[]{actTok});
                        Tuple<Integer, String> offsetAndIndent2 = this.getLocationOffset(2, pySelection, moduleAdapter, targetClass);
                        return this.createProposal(pySelection, constant, offsetAndIndent2, false, replacePassStatement);
                    }
                    case 3: {
                        Pass replacePassStatement;
                        String indent;
                        parametersAfterCall = this.checkFirst(parametersAfterCall, "self");
                        FunctionDefAdapter firstInit = targetClass.getFirstInit();
                        if (firstInit != null) {
                            Tuple offsetAndIndent3;
                            String pattern;
                            FunctionDef astNode = (FunctionDef)firstInit.getASTNode();
                            replacePassStatement = this.getLastPassFromNode((SimpleNode)astNode);
                            int nodeLastLine = firstInit.getNodeLastLine() - 1;
                            indent = firstInit.getNodeBodyIndent();
                            if (replacePassStatement == null) {
                                pattern = StringUtils.format((String)"\nself.%s = ${None}${cursor}", (Object[])new Object[]{actTok});
                                try {
                                    IRegion region = pySelection.getDoc().getLineInformation(nodeLastLine);
                                    int offset = region.getOffset() + region.getLength();
                                    offsetAndIndent3 = new Tuple((Object)offset, (Object)indent);
                                }
                                catch (BadLocationException e) {
                                    Log.log((Throwable)e);
                                    return null;
                                }
                            } else {
                                pattern = StringUtils.format((String)"self.%s = ${None}${cursor}", (Object[])new Object[]{actTok});
                                offsetAndIndent3 = new Tuple((Object)-1, (Object)"");
                            }
                            return this.createProposal(pySelection, pattern, (Tuple<Integer, String>)offsetAndIndent3, false, replacePassStatement);
                        }
                        body = StringUtils.format((String)"self.%s = ${None}${cursor}", (Object[])new Object[]{actTok});
                        actTok = "__init__";
                        locationStrategy = 2;
                    }
                }
            } else {
                return null;
            }
        }
        String params = "";
        if (parametersAfterCall != null && parametersAfterCall.size() > 0) {
            params = PyCreateMethodOrField.createParametersList(parametersAfterCall).toString();
        }
        Pass replacePassStatement = null;
        if (targetClass != null) {
            replacePassStatement = this.getLastPassFromNode(targetClass.getASTNode());
            offsetAndIndent = this.getLocationOffset(locationStrategy, pySelection, moduleAdapter, targetClass);
        } else {
            offsetAndIndent = this.getLocationOffset(locationStrategy, pySelection, moduleAdapter);
        }
        String source = StringUtils.format((String)"%sdef %s(%s):\n%s%s${cursor}\n\n\n", (Object[])new Object[]{decorators, actTok, params, refactoringInfo.indentPrefs.getIndentationString(), body});
        return this.createProposal(pySelection, source, offsetAndIndent, true, replacePassStatement);
    }

    private Pass getLastPassFromNode(SimpleNode astNode) {
        stmtType lastNode;
        stmtType[] body = NodeUtils.getBody((SimpleNode)astNode);
        Pass replacePassStatement = null;
        if (body.length > 0 && (lastNode = body[body.length - 1]) instanceof Pass) {
            replacePassStatement = (Pass)lastNode;
        }
        return replacePassStatement;
    }

    private List<String> checkFirst(List<String> parametersAfterCall, String first) {
        if (parametersAfterCall == null) {
            parametersAfterCall = new ArrayList<String>();
        }
        if (parametersAfterCall.size() == 0) {
            parametersAfterCall.add(first);
        } else {
            String string = parametersAfterCall.get(0);
            if (!first.equals(string)) {
                parametersAfterCall.add(0, first);
            }
        }
        return parametersAfterCall;
    }

    public void setCreateInClass(String createInClass) {
        this.createInClass = createInClass;
    }

    public void setCreateAs(int createAs) {
        this.createAs = createAs;
    }
}

