/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class LineCommentAction {
    private TextSelectionUtils ps;
    private String commentPattern;
    private int spacesInStart;
    private final String addCommentsOption;

    public LineCommentAction(TextSelectionUtils ps, String commentPattern, int spacesInStart, String addCommentsOption) {
        this.ps = ps;
        this.commentPattern = commentPattern;
        this.spacesInStart = spacesInStart;
        this.addCommentsOption = addCommentsOption;
    }

    public FastStringBuffer commentLines(String selectedText) {
        List<String> ret = StringUtils.splitInLines(selectedText);
        FastStringBuffer strbuf = new FastStringBuffer(selectedText.length() + ret.size() + (this.spacesInStart + 2) * ret.size());
        if (ret.isEmpty()) {
            ret.add(selectedText);
        } else if (selectedText.endsWith("\r") || selectedText.endsWith("\n")) {
            ret.add("");
        }
        String spacesInStartComment = null;
        if (this.spacesInStart > 0) {
            spacesInStartComment = StringUtils.createSpaceString(this.spacesInStart);
        }
        int lastFirstCharPosition = 0;
        FastStringBuffer lineBuf = new FastStringBuffer();
        int lowestIndent = -1;
        if ("ADD_COMMENTS_INDENT".equals(this.addCommentsOption)) {
            for (String line : ret) {
                if (line.trim().isEmpty()) continue;
                int indent = TextSelectionUtils.getFirstCharPosition(line);
                if ((lowestIndent == -1 || indent < lowestIndent) && (lowestIndent = indent) == 0) break;
            }
        }
        if (lowestIndent < 0) {
            lowestIndent = 0;
        }
        if ("ADD_COMMENTS_INDENT_LINE_ORIENTED".equals(this.addCommentsOption)) {
            for (String line : ret) {
                boolean addSpacesInStartComment = true;
                lineBuf.clear();
                lineBuf.append(line);
                lineBuf.leftTrim();
                if (lineBuf.length() == 0) {
                    addSpacesInStartComment = false;
                    lineBuf.append(line);
                    if (lastFirstCharPosition > 0) {
                        lineBuf.leftTrimSpacesAndTabs();
                        strbuf.append(StringUtils.createSpaceString(lastFirstCharPosition));
                    } else {
                        lineBuf.rightTrimNewLines();
                        lastFirstCharPosition = lineBuf.length();
                        strbuf.append(lineBuf);
                        lineBuf.clear();
                        lineBuf.append(line);
                        lineBuf.leftTrimSpacesAndTabs();
                    }
                } else {
                    strbuf.append(StringUtils.createSpaceString(line.length() - lineBuf.length()));
                    lastFirstCharPosition = TextSelectionUtils.getFirstCharPosition(line);
                }
                strbuf.append(this.commentPattern);
                if (spacesInStartComment != null && addSpacesInStartComment) {
                    strbuf.append(spacesInStartComment);
                }
                strbuf.append(lineBuf);
            }
        } else if ("ADD_COMMENTS_INDENT".equals(this.addCommentsOption)) {
            String lowestIndentSpaceString = StringUtils.createSpaceString(lowestIndent);
            for (String line : ret) {
                lineBuf.clear();
                if (!line.trim().isEmpty()) {
                    lineBuf.append(line);
                    if (lowestIndent > 0) {
                        lineBuf.deleteFirstChars(lowestIndent);
                        strbuf.append(lowestIndentSpaceString);
                    }
                    strbuf.append(this.commentPattern);
                    if (spacesInStartComment != null) {
                        strbuf.append(spacesInStartComment);
                    }
                    strbuf.append(lineBuf);
                    continue;
                }
                strbuf.append(lowestIndentSpaceString);
                strbuf.append(this.commentPattern);
                if (line.endsWith("\r\n")) {
                    strbuf.append("\r\n");
                    continue;
                }
                if (line.endsWith("\r")) {
                    strbuf.append("\r");
                    continue;
                }
                strbuf.append("\n");
            }
        } else {
            for (String line : ret) {
                strbuf.append(this.commentPattern);
                if (spacesInStartComment != null) {
                    strbuf.append(spacesInStartComment);
                }
                strbuf.append(line);
            }
        }
        return strbuf;
    }

    public Tuple<Integer, Integer> execute() throws BadLocationException {
        this.ps.selectCompleteLine();
        String selectedText = this.ps.getSelectedText();
        FastStringBuffer strbuf = this.commentLines(selectedText);
        ICoreTextSelection txtSel = this.ps.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        String replacement = strbuf.toString();
        this.ps.getDoc().replace(start, len, replacement);
        return new Tuple<Integer, Integer>(start, replacement.length());
    }
}

