/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.document;

import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.python.pydev.shared_core.log.Log;

public class DocCopy
implements IDocument,
IDocumentExtension4 {
    private String contents;
    private IDocument document;
    private HashMap<String, Position[]> categoryToPos;
    private long modificationStamp;
    private ILineTracker fLineTracker;

    public DocCopy(IDocument document) {
        String[] positionCategories;
        this.contents = document.get();
        this.document = document;
        this.categoryToPos = new HashMap();
        String[] stringArray = positionCategories = document.getPositionCategories();
        int n = positionCategories.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                this.categoryToPos.put(string, document.getPositions(string));
            }
            catch (BadPositionCategoryException e) {
                Log.log(e);
            }
            ++n2;
        }
        IDocumentExtension4 doc4 = (IDocumentExtension4)document;
        this.modificationStamp = doc4.getModificationStamp();
    }

    private ILineTracker getLineTracker() {
        if (this.fLineTracker == null) {
            this.fLineTracker = new DefaultLineTracker();
            this.fLineTracker.set(this.contents);
        }
        return this.fLineTracker;
    }

    public void dispose() {
        this.contents = null;
        this.document = null;
        this.categoryToPos = null;
        this.fLineTracker = null;
    }

    public char getChar(int offset) throws BadLocationException {
        return this.contents.charAt(offset);
    }

    public int getLength() {
        return this.contents.length();
    }

    public String get() {
        return this.contents;
    }

    public String get(int offset, int length) throws BadLocationException {
        return this.contents.substring(offset, offset + length);
    }

    public void set(String text) {
        throw new RuntimeException("not implemented");
    }

    public void replace(int offset, int length, String text) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public void addDocumentListener(IDocumentListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void removeDocumentListener(IDocumentListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void addPrenotifiedDocumentListener(IDocumentListener documentAdapter) {
        throw new RuntimeException("not implemented");
    }

    public void removePrenotifiedDocumentListener(IDocumentListener documentAdapter) {
        throw new RuntimeException("not implemented");
    }

    public void addPositionCategory(String category) {
        throw new RuntimeException("not implemented");
    }

    public void removePositionCategory(String category) throws BadPositionCategoryException {
        throw new RuntimeException("not implemented");
    }

    public String[] getPositionCategories() {
        return this.categoryToPos.entrySet().toArray(new String[this.categoryToPos.size()]);
    }

    public boolean containsPositionCategory(String category) {
        throw new RuntimeException("not implemented");
    }

    public void addPosition(Position position) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public void removePosition(Position position) {
        throw new RuntimeException("not implemented");
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        throw new RuntimeException("not implemented");
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        throw new RuntimeException("not implemented");
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        return this.categoryToPos.get(category);
    }

    public boolean containsPosition(String category, int offset, int length) {
        throw new RuntimeException("not implemented");
    }

    public int computeIndexInCategory(String category, int offset) throws BadLocationException, BadPositionCategoryException {
        throw new RuntimeException("not implemented");
    }

    public void addPositionUpdater(IPositionUpdater updater) {
        throw new RuntimeException("not implemented");
    }

    public void removePositionUpdater(IPositionUpdater updater) {
        throw new RuntimeException("not implemented");
    }

    public void insertPositionUpdater(IPositionUpdater updater, int index) {
        throw new RuntimeException("not implemented");
    }

    public IPositionUpdater[] getPositionUpdaters() {
        throw new RuntimeException("not implemented");
    }

    public String[] getLegalContentTypes() {
        throw new RuntimeException("not implemented");
    }

    public String getContentType(int offset) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public ITypedRegion getPartition(int offset) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public ITypedRegion[] computePartitioning(int offset, int length) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public void addDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void removeDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void setDocumentPartitioner(IDocumentPartitioner partitioner) {
        throw new RuntimeException("not implemented");
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        return this.document.getDocumentPartitioner();
    }

    public int getLineLength(int line) throws BadLocationException {
        return this.getLineTracker().getLineLength(line);
    }

    public int getLineOfOffset(int pos) throws BadLocationException {
        return this.getLineTracker().getLineNumberOfOffset(pos);
    }

    public int getLineOffset(int line) throws BadLocationException {
        return this.getLineTracker().getLineOffset(line);
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.getLineTracker().getLineInformation(line);
    }

    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return this.getLineTracker().getLineInformationOfOffset(offset);
    }

    public int getNumberOfLines() {
        return this.getLineTracker().getNumberOfLines();
    }

    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        return this.getLineTracker().getNumberOfLines(offset, length);
    }

    public int computeNumberOfLines(String text) {
        return this.getLineTracker().computeNumberOfLines(text);
    }

    public String[] getLegalLineDelimiters() {
        return this.getLineTracker().getLegalLineDelimiters();
    }

    public String getLineDelimiter(int line) throws BadLocationException {
        return this.getLineTracker().getLineDelimiter(line);
    }

    public int search(int startOffset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public DocumentRewriteSession startRewriteSession(DocumentRewriteSessionType sessionType) throws IllegalStateException {
        throw new RuntimeException("not implemented");
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
        throw new RuntimeException("not implemented");
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        throw new RuntimeException("not implemented");
    }

    public void addDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void removeDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void replace(int offset, int length, String text, long modificationStamp) throws BadLocationException {
        throw new RuntimeException("not implemented");
    }

    public void set(String text, long modificationStamp) {
        throw new RuntimeException("not implemented");
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public String getDefaultLineDelimiter() {
        throw new RuntimeException("not implemented");
    }

    public void setInitialLineDelimiter(String lineDelimiter) {
        throw new RuntimeException("not implemented");
    }
}

