/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.global_feedback;

import java.io.IOException;
import org.python.pydev.shared_core.callbacks.ListenerList;
import org.python.pydev.shared_core.global_feedback.IGlobalFeedbackListener;

public class GlobalFeedback {
    public static final ListenerList<IGlobalFeedbackListener> GLOBAL_LISTENERS = new ListenerList<IGlobalFeedbackListener>(IGlobalFeedbackListener.class);

    public static GlobalFeedbackReporter start(String message) {
        return new GlobalFeedbackReporter(message);
    }

    public static class GlobalFeedbackReporter
    implements AutoCloseable {
        private long lastReport = System.currentTimeMillis();
        private IGlobalFeedbackListener[] listeners;

        public GlobalFeedbackReporter(String message) {
            IGlobalFeedbackListener[] iGlobalFeedbackListenerArray = this.listeners = GLOBAL_LISTENERS.getListeners();
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IGlobalFeedbackListener listener = iGlobalFeedbackListenerArray[n2];
                listener.start(message);
                ++n2;
            }
        }

        @Override
        public void close() throws IOException {
            IGlobalFeedbackListener[] iGlobalFeedbackListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IGlobalFeedbackListener listener = iGlobalFeedbackListenerArray[n2];
                listener.end();
                ++n2;
            }
        }

        public void progress(String name) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis > this.lastReport + 200L) {
                this.lastReport = currentTimeMillis;
                IGlobalFeedbackListener[] iGlobalFeedbackListenerArray = this.listeners;
                int n = this.listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IGlobalFeedbackListener listener = iGlobalFeedbackListenerArray[n2];
                    listener.progress(name);
                    ++n2;
                }
            }
        }
    }
}

