/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.locator;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;

public class GetFiles {
    public IFile getFileForLocation(IPath location, IProject project) {
        boolean stopOnFirst = true;
        IFile[] filesForLocation = this.getFilesForLocation(location, project, stopOnFirst);
        if (filesForLocation != null && filesForLocation.length > 0) {
            return filesForLocation[0];
        }
        return null;
    }

    public IFile[] getFilesForLocation(IPath location, IProject project, boolean stopOnFirst) {
        ArrayList<IFile> lst = new ArrayList<IFile>();
        if (SharedCorePlugin.inTestMode()) {
            return lst.toArray(new IFile[0]);
        }
        HashSet<IProject> checked = new HashSet<IProject>();
        IWorkspace w = ResourcesPlugin.getWorkspace();
        if (project != null) {
            checked.add(project);
            IFile f = this.getFileInProject(location, project);
            if (f != null) {
                if (stopOnFirst) {
                    return new IFile[]{f};
                }
                lst.add(f);
            }
            try {
                IProject[] referencedProjects = project.getDescription().getReferencedProjects();
                int i = 0;
                while (i < referencedProjects.length) {
                    IProject p = referencedProjects[i];
                    checked.add(p);
                    f = this.getFileInProject(location, p);
                    if (f != null) {
                        if (stopOnFirst) {
                            return new IFile[]{f};
                        }
                        lst.add(f);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                Log.log(e);
            }
        }
        IProject[] projects = w.getRoot().getProjects(8);
        int i = 0;
        while (i < projects.length) {
            IProject p = projects[i];
            if (!checked.contains(p)) {
                checked.add(p);
                IFile f = this.getFileInProject(location, p);
                if (f != null) {
                    if (stopOnFirst) {
                        return new IFile[]{f};
                    }
                    lst.add(f);
                }
            }
            ++i;
        }
        return lst.toArray(new IFile[0]);
    }

    public static final IFile getFileInContainer(IPath location, IContainer container, boolean mustExist) {
        IPath containerLocation = container.getLocation();
        if (containerLocation != null) {
            if (FileUtils.isPrefixOf(containerLocation, location)) {
                int segmentsToRemove = containerLocation.segmentCount();
                IPath removingFirstSegments = location.removeFirstSegments(segmentsToRemove);
                if (removingFirstSegments.segmentCount() == 0) {
                    return null;
                }
                IFile file = container.getFile(removingFirstSegments);
                if (!mustExist || file.exists()) {
                    return file;
                }
            }
        } else if (container instanceof IProject) {
            Log.logInfo("Info: container: " + container + " has no associated location.");
        }
        return null;
    }

    protected IFile getFileInProject(IPath location, IProject project) {
        IFile file = GetFiles.getFileInContainer(location, (IContainer)project, true);
        if (file != null) {
            return file;
        }
        return null;
    }
}

