/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IDocumentScanner;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.ITokenScanner;
import org.python.pydev.shared_core.partitioner.Token;

public abstract class AbstractCustomRuleBasedScanner
implements ICharacterScanner,
ITokenScanner,
IDocumentScanner {
    protected IRule[] fRules;
    protected IToken fDefaultReturnToken;
    protected IDocument fDocument;
    protected char[][] fDelimiters;
    protected int fOffset;
    protected int fRangeEnd;
    protected int fTokenOffset;
    protected int fColumn;
    protected static final int UNDEFINED = -1;

    public void setRules(IRule[] rules) {
        this.fRules = rules;
    }

    public void setDefaultReturnToken(IToken defaultReturnToken) {
        Assert.isNotNull((Object)defaultReturnToken.getData());
        this.fDefaultReturnToken = defaultReturnToken;
        if ("__dftl_partition_content_type".equals(this.fDefaultReturnToken.getData())) {
            this.fDefaultReturnToken = new Token(null);
            Log.log("Not sure why setting the default is not good... we should not set anything in this case and return a Token with null data.");
        }
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        this.checkRange(offset, length, documentLength);
        this.fDocument = document;
        this.fOffset = offset;
        this.fColumn = -1;
        this.fRangeEnd = offset + length;
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
            ++i;
        }
        if (this.fDefaultReturnToken == null) {
            this.fDefaultReturnToken = new Token(null);
        }
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    @Override
    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    @Override
    public int getTokenLength() {
        if (this.fOffset < this.fRangeEnd) {
            return this.fOffset - this.getTokenOffset();
        }
        return this.fRangeEnd - this.getTokenOffset();
    }

    @Override
    public int getColumn() {
        if (this.fColumn == -1) {
            try {
                int line = this.fDocument.getLineOfOffset(this.fOffset);
                int start = this.fDocument.getLineOffset(line);
                this.fColumn = this.fOffset - start;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.fColumn;
    }

    @Override
    public char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }

    @Override
    public IToken nextToken() {
        if (this.fRules == null) {
            int c = this.read();
            if (c == -1) {
                return Token.EOF;
            }
            while ((c = this.read()) != -1) {
            }
            this.unread();
            return this.fDefaultReturnToken;
        }
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        int length = this.fRules.length;
        int i = 0;
        while (i < length) {
            IToken token = this.fRules[i].evaluate(this);
            if (token == null) {
                Log.log("Error: rule " + this.fRules[i] + " returned a null token.");
            } else if (!token.isUndefined()) {
                return token;
            }
            ++i;
        }
        int c = this.read();
        if (c == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    @Override
    public abstract int read();

    @Override
    public abstract void unread();
}

