/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.IWordDetector;
import org.python.pydev.shared_core.partitioner.Token;

public class WordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();
    private boolean fIgnoreCase = false;

    public WordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED, false);
    }

    public WordRule(IWordDetector detector, IToken defaultToken) {
        this(detector, defaultToken, false);
    }

    public WordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        this.fIgnoreCase = ignoreCase;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        if (this.fIgnoreCase) {
            word = word.toLowerCase();
        }
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            IToken token;
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            if (this.fIgnoreCase) {
                buffer = buffer.toLowerCase();
            }
            if ((token = this.fWords.get(buffer)) != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

