/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.path_watch;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.WatchKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.callbacks.ListenerList;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.OrderedMap;

public class EventsStackerRunnable
implements Runnable {
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int LEVELS_TO_GET_MODIFIED_TIME = 2;
    volatile WatchKey key;
    public final ListenerList<IFilesystemChangesListener> list;
    public final Path watchedPath;
    private final Object lock = new Object();
    private Map<File, Integer> fileToEvent = new OrderedMap<File, Integer>();
    private volatile File overflow = null;
    private final File file;
    private final Map<File, Long> internalDirToLastModifiedTime = new HashMap<File, Long>();
    private final boolean isDir;
    private final FileFilter fileFilter;
    private final FileFilter dirFilter;
    private static final Long DIRECTORY_WITH_NOTHING_INTERESTING = 0L;
    private volatile boolean initializationFinished = false;
    private final Object lockInitialization = new Object();

    public EventsStackerRunnable(WatchKey key, Path watchedPath, ListenerList<IFilesystemChangesListener> list, final File file, final FileFilter fileFilter, final FileFilter dirFilter) {
        Assert.isNotNull(list);
        Assert.isNotNull((Object)watchedPath);
        this.list = list;
        this.key = key;
        this.watchedPath = watchedPath;
        this.file = file;
        this.isDir = file.isDirectory();
        this.fileFilter = fileFilter;
        this.dirFilter = dirFilter;
        if (this.isDir) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        File[] listFiles = file.listFiles();
                        if (listFiles != null) {
                            File[] fileArray = listFiles;
                            int n = listFiles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File f = fileArray[n2];
                                if (f.isDirectory() && dirFilter.accept(f)) {
                                    long lastModifiedTimeFromDir = FileUtils.getLastModifiedTimeFromDir(f, fileFilter, dirFilter, 2);
                                    if (lastModifiedTimeFromDir != 0L) {
                                        EventsStackerRunnable.this.internalDirToLastModifiedTime.put(f, lastModifiedTimeFromDir);
                                    } else {
                                        EventsStackerRunnable.this.internalDirToLastModifiedTime.put(f, DIRECTORY_WITH_NOTHING_INTERESTING);
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                    finally {
                        EventsStackerRunnable.this.initializationFinished = true;
                    }
                }
            }.start();
        } else {
            this.initializationFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File currentOverflow;
        Map<File, Integer> currentFileToEvent;
        while (!this.initializationFinished) {
            Object object = this.lockInitialization;
            synchronized (object) {
                try {
                    this.lockInitialization.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        boolean dirExists = true;
        Object object = this.lock;
        synchronized (object) {
            currentFileToEvent = this.fileToEvent;
            this.fileToEvent = new OrderedMap<File, Integer>();
            currentOverflow = this.overflow;
            this.overflow = null;
        }
        IFilesystemChangesListener[] listeners = this.list.getListeners();
        if (listeners.length == 0) {
            return;
        }
        if (this.isDir && !(dirExists = this.file.exists())) {
            IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IFilesystemChangesListener iFilesystemChangesListener = iFilesystemChangesListenerArray[n2];
                try {
                    iFilesystemChangesListener.removed(this.file);
                }
                catch (Exception e) {
                    Log.log(e);
                }
                ++n2;
            }
            return;
        }
        if (currentOverflow != null) {
            IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
            int n = listeners.length;
            int n3 = 0;
            while (n3 < n) {
                IFilesystemChangesListener iFilesystemChangesListener = iFilesystemChangesListenerArray[n3];
                File watched = this.file;
                iFilesystemChangesListener.removed(watched);
                if (watched.exists()) {
                    iFilesystemChangesListener.added(watched);
                }
                ++n3;
            }
            return;
        }
        Set<Map.Entry<File, Integer>> entrySet = currentFileToEvent.entrySet();
        block21: for (Map.Entry<File, Integer> entry : entrySet) {
            Integer value = entry.getValue();
            File currKey = entry.getKey();
            if (this.isDir) {
                Long lastModifiedTime = this.internalDirToLastModifiedTime.get(currKey);
                if (currKey.isDirectory()) {
                    long newLast = FileUtils.getLastModifiedTimeFromDir(currKey, this.fileFilter, this.dirFilter, 2);
                    if (lastModifiedTime != null && newLast == lastModifiedTime) continue;
                    if (newLast == 0L && lastModifiedTime == null) {
                        this.internalDirToLastModifiedTime.put(currKey, DIRECTORY_WITH_NOTHING_INTERESTING);
                        continue;
                    }
                    if (newLast == 0L && lastModifiedTime != null) {
                        this.internalDirToLastModifiedTime.put(currKey, DIRECTORY_WITH_NOTHING_INTERESTING);
                    } else {
                        this.internalDirToLastModifiedTime.put(currKey, newLast);
                    }
                } else if (lastModifiedTime != null) {
                    if (value == 0 && !currKey.exists()) continue;
                    this.internalDirToLastModifiedTime.remove(currKey);
                    if (lastModifiedTime == DIRECTORY_WITH_NOTHING_INTERESTING) {
                        continue;
                    }
                } else if (!this.fileFilter.accept(currKey)) continue;
            }
            switch (value) {
                case 0: {
                    IFilesystemChangesListener iFilesystemChangesListener;
                    IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                    int n = listeners.length;
                    int n4 = 0;
                    while (n4 < n) {
                        iFilesystemChangesListener = iFilesystemChangesListenerArray[n4];
                        try {
                            iFilesystemChangesListener.added(currKey);
                        }
                        catch (Exception e) {
                            Log.log(e);
                        }
                        ++n4;
                    }
                    continue block21;
                }
                case 1: {
                    IFilesystemChangesListener iFilesystemChangesListener;
                    IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                    int n = listeners.length;
                    int n5 = 0;
                    while (n5 < n) {
                        iFilesystemChangesListener = iFilesystemChangesListenerArray[n5];
                        try {
                            iFilesystemChangesListener.removed(currKey);
                        }
                        catch (Exception e) {
                            Log.log(e);
                        }
                        ++n5;
                    }
                    continue block21;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overflow(File file) {
        Object object = this.lock;
        synchronized (object) {
            this.overflow = file;
            this.fileToEvent.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.overflow == null) {
                this.fileToEvent.put(file, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.overflow == null) {
                this.fileToEvent.put(file, 1);
            }
        }
    }

    public String toString() {
        return new FastStringBuffer().append("EventsStackerRunnable(key=").appendObject(this.key).append(";watchedPath=").appendObject(this.watchedPath).append(";overflow=").appendObject(this.overflow).append(";fileToEvent=").appendObject(this.fileToEvent).append(";listeners=").appendObject(this.list.getListeners()).append(")").toString();
    }
}

