/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.path_watch;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.callbacks.ListenerList;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.path_watch.EventsStackerRunnable;
import org.python.pydev.shared_core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.path_watch.IPathWatch;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PathWatch
implements IPathWatch {
    private WatchService watchService;
    public FastStringBuffer log;
    private Map<Path, EventsStackerRunnable> pathToStacker = Collections.synchronizedMap(new HashMap());
    private Map<WatchKey, Path> keyToPath = Collections.synchronizedMap(new HashMap());
    private final PollThread pollThread;
    private final Object lock = new Object();
    private volatile boolean disposed = false;
    private FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };
    private FileFilter dirsFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };
    private boolean registeredTracker;

    public PathWatch() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            Log.log("Error starting watch service", e);
        }
        this.pollThread = new PollThread();
        this.pollThread.setDaemon(true);
        this.pollThread.setPriority(2);
        this.pollThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTrack(File path, IFilesystemChangesListener listener) {
        if (this.disposed) {
            return;
        }
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)listener);
        Path watchedPath = Paths.get(FileUtils.getFileAbsolutePath(path), new String[0]);
        if (this.log != null) {
            this.log.append("STOP Track: ").appendObject(path).append("Listener: ").appendObject(listener).append('\n');
        }
        Object object = this.lock;
        synchronized (object) {
            EventsStackerRunnable stacker = this.pathToStacker.get(watchedPath);
            if (stacker != null && stacker.list != null) {
                ListenerList<IFilesystemChangesListener> list = stacker.list;
                list.remove(listener);
                if (list.getListeners().length == 0) {
                    this.pathToStacker.remove(watchedPath);
                    this.keyToPath.remove(stacker.key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasTracker(File path, IFilesystemChangesListener listener) {
        if (this.disposed) {
            return false;
        }
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)listener);
        Path watchedPath = Paths.get(FileUtils.getFileAbsolutePath(path), new String[0]);
        if (this.log != null) {
            this.log.append("Has Tracker: ").appendObject(path).append("Listener: ").appendObject(listener).append('\n');
        }
        Object object = this.lock;
        synchronized (object) {
            IFilesystemChangesListener[] listeners;
            EventsStackerRunnable stacker = this.pathToStacker.get(watchedPath);
            if (stacker == null) return false;
            if (stacker.list == null) return false;
            ListenerList<IFilesystemChangesListener> list = stacker.list;
            IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners = list.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IFilesystemChangesListener iFilesystemChangesListener = iFilesystemChangesListenerArray[n2];
                if (listener.equals(iFilesystemChangesListener)) {
                    return true;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.disposed = true;
        try {
            Object object = this.lock;
            synchronized (object) {
                this.pathToStacker.clear();
                this.keyToPath.clear();
                try {
                    if (this.watchService != null) {
                        this.watchService.close();
                    }
                }
                catch (IOException e) {
                    Log.log(e);
                }
                this.pollThread.interrupt();
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void track(File path, IFilesystemChangesListener listener) {
        if (this.disposed) {
            return;
        }
        this.registeredTracker = true;
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)listener);
        if (!path.exists()) {
            Log.logInfo("Unable to track file that does not exist: " + path);
            return;
        }
        Path watchedPath = Paths.get(FileUtils.getFileAbsolutePath(path), new String[0]);
        Object object = this.lock;
        synchronized (object) {
            EventsStackerRunnable stacker = this.pathToStacker.get(watchedPath);
            if (stacker != null) {
                stacker.list.add(listener);
                return;
            }
            if (this.log != null) {
                this.log.append("Track: ").appendObject(path).append(" Listener: ").appendObject(listener).append('\n');
            }
            boolean add = true;
            WatchKey key = null;
            try {
                if (this.watchService != null) {
                    key = watchedPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
                } else {
                    Log.log("watchService is null. Unable to track: " + path);
                }
            }
            catch (UnsupportedOperationException uox) {
                if (this.log != null) {
                    this.log.append("UnsupportedOperationException: ").appendObject(uox).append('\n');
                }
                add = false;
                Log.log(uox);
            }
            catch (IOException uox) {
            }
            catch (Throwable e) {
                if (this.log != null) {
                    this.log.append("Throwable: ").appendObject(e).append('\n');
                }
                add = false;
                Log.log(e);
            }
            if (add) {
                if (stacker == null) {
                    stacker = new EventsStackerRunnable(key, watchedPath, new ListenerList<IFilesystemChangesListener>(IFilesystemChangesListener.class), path, this.fileFilter, this.dirsFilter);
                    this.pathToStacker.put(watchedPath, stacker);
                }
                stacker.list.add(listener);
                if (key != null) {
                    this.keyToPath.put(key, watchedPath);
                }
            }
        }
    }

    @Override
    public void setDirectoryFileFilter(FileFilter fileFilter, FileFilter dirsFilter) {
        if (this.registeredTracker) {
            throw new AssertionError((Object)"After registering a tracker, the file filter can no longer be changed.");
        }
        this.fileFilter = fileFilter;
        this.dirsFilter = dirsFilter;
    }

    private class PollThread
    extends Thread {
        private PollThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block10: while (true) {
                try {
                    while (true) lbl-1000:
                    // 6 sources

                    {
                        if (PathWatch.this.disposed) {
                            return;
                        }
                        if (PathWatch.this.watchService == null) {
                            Log.log("Error: watchService is null. Unable to track file changes.");
                            return;
                        }
                        if (PathWatch.this.log != null) {
                            PathWatch.this.log.append("Wating (watchService.take)\n");
                        }
                        try {
                            signalledKey = PathWatch.this.watchService.take();
                        }
                        catch (InterruptedException ix) {
                            if (PathWatch.this.log == null) continue;
                            PathWatch.this.log.append("Interrupted\n");
                            continue;
                        }
                        catch (ClosedWatchServiceException cwse) {
                            if (PathWatch.this.log == null) break block10;
                            PathWatch.this.log.append("Closed watch system\n");
                            break block10;
                        }
                        var5_8 = PathWatch.this.lock;
                        synchronized (var5_8) {
                            watchedPath = PathWatch.this.keyToPath.get(signalledKey);
                            if (watchedPath == null) {
                                continue;
                            }
                            list = signalledKey.pollEvents();
                            stacker = PathWatch.this.pathToStacker.get(watchedPath);
                            if (stacker == null) {
                                if (PathWatch.this.log != null) {
                                    PathWatch.this.log.append("Stacker for: ").appendObject(watchedPath).append("is null\n");
                                }
                                continue;
                            }
                            if (new File(watchedPath.toString()).exists()) {
                                signalledKey.reset();
                            }
                            for (WatchEvent<?> e : list) {
                                context = (Path)e.context();
                                resolve = watchedPath.resolve(context);
                                file = new File(resolve.toString());
                                kind = e.kind();
                                if (PathWatch.this.log != null) {
                                    PathWatch.this.log.append("Event: ").appendObject(kind).append(" file: ").appendObject(file).append('\n');
                                }
                                if (kind == StandardWatchEventKinds.OVERFLOW) {
                                    if (!file.exists()) {
                                        PathWatch.this.keyToPath.remove(signalledKey);
                                        stacker.key = null;
                                        stacker.removed(file);
                                    }
                                    stacker.overflow(file);
                                    continue;
                                }
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                    stacker.added(file);
                                    continue;
                                }
                                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                stacker.removed(file);
                            }
                            try {
                                stacker.run();
                            }
                            catch (Exception e1) {
                                if (PathWatch.this.log != null) {
                                    PathWatch.this.log.append("Unexpected exception" + e1 + "\n");
                                }
                                Log.log(e1);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    if (PathWatch.this.log != null) {
                        PathWatch.this.log.append("Unexpected exception" + e + "\n");
                    }
                    Log.log(e);
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

