/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.preferences;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class InMemoryEclipsePreferences
implements IEclipsePreferences {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private ListenerList<IEclipsePreferences.IPreferenceChangeListener> preferenceChangeListeners;
    private Map<String, String> properties = new HashMap<String, String>();

    public String get(String key, String defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value.getBytes(StandardCharsets.UTF_8);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.internalGet(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.internalGet(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.internalGet(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.internalGet(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String result = this.properties.get(key);
        return result;
    }

    protected String internalPut(String key, String newValue) {
        String oldValue = this.properties.get(key);
        if (oldValue != null && oldValue.equals(newValue)) {
            return oldValue;
        }
        return this.properties.put(key, newValue);
    }

    public String[] keys() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public String name() {
        throw new RuntimeException("Not implemented");
    }

    protected void firePreferenceEvent(String key, Object oldValue, Object newValue) {
        if (this.preferenceChangeListeners == null) {
            return;
        }
        final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, oldValue, newValue);
        for (final IEclipsePreferences.IPreferenceChangeListener listener : this.preferenceChangeListeners) {
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
        }
    }

    public void put(String key, String newValue) {
        if (key == null || newValue == null) {
            throw new NullPointerException();
        }
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = value ? TRUE : FALSE;
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putByteArray(String key, byte[] value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        String newValue = new String(value, StandardCharsets.UTF_8);
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putDouble(String key, double value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Double.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putFloat(String key, float value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Float.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putInt(String key, int value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Integer.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putLong(String key, long value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Long.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void remove(String key) {
        String oldValue = this.properties.get(key);
        if (oldValue == null) {
            return;
        }
        this.properties.remove(key);
        this.firePreferenceEvent(key, oldValue, null);
    }

    public void clear() throws BackingStoreException {
        throw new RuntimeException("not implemented");
    }

    public String[] childrenNames() throws BackingStoreException {
        throw new RuntimeException("not implemented");
    }

    public Preferences parent() {
        throw new RuntimeException("not implemented");
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        throw new RuntimeException("not implemented");
    }

    public String absolutePath() {
        throw new RuntimeException("not implemented");
    }

    public void flush() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new RuntimeException("not implemented");
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceChangeListeners == null) {
            this.preferenceChangeListeners = new ListenerList();
        }
        this.preferenceChangeListeners.add((Object)listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceChangeListeners == null) {
            return;
        }
        this.preferenceChangeListeners.remove((Object)listener);
        if (this.preferenceChangeListeners.size() == 0) {
            this.preferenceChangeListeners = null;
        }
    }

    public void removeNode() throws BackingStoreException {
        throw new RuntimeException("not implemented");
    }

    public Preferences node(String path) {
        throw new RuntimeException("not implemented");
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        throw new RuntimeException("not implemented");
    }
}

