/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.resource_stubs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.resource_stubs.AbstractIFolderStub;
import org.python.pydev.shared_core.resource_stubs.FileStub;
import org.python.pydev.shared_core.resource_stubs.IProjectStub;

public class FolderStub
extends AbstractIFolderStub
implements IFolder {
    private File folder;
    private IProjectStub project;
    private IContainer parent;

    public FolderStub(IProjectStub stub, File parentFile) {
        this(stub, null, parentFile);
    }

    public FolderStub(IProjectStub stub, IContainer parent, File parentFile) {
        this(stub, parent, parentFile, true);
    }

    public FolderStub(IProjectStub stub, IContainer parent, File parentFile, boolean mustExist) {
        if (mustExist) {
            Assert.isTrue((parentFile.exists() && parentFile.isDirectory() ? 1 : 0) != 0);
        }
        this.project = stub;
        this.folder = parentFile;
        this.parent = parent;
    }

    @Override
    public IContainer getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return this.project.getFolder(this.folder.getParentFile());
    }

    @Override
    public IFile getFile(IPath path) {
        if (path.segmentCount() != 1) {
            throw new RuntimeException("finish implementing");
        }
        return new FileStub(this.project, new File(this.folder, path.segment(0)));
    }

    @Override
    public IFile getFile(String name) {
        return this.getFile((IPath)new Path(name));
    }

    @Override
    public IFolder getFolder(IPath path) {
        String[] segments = path.segments();
        IFolder f = null;
        File curr = this.folder;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            File parentFile = new File(curr, string);
            f = (IFolder)this.project.getFolder(parentFile);
            curr = parentFile;
            ++n2;
        }
        return f;
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    public String toString() {
        return "FolderStub:" + this.folder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FolderStub other = (FolderStub)obj;
        return !(this.folder == null ? other.folder != null : !this.folder.equals(other.folder));
    }

    @Override
    public IPath getFullPath() {
        String fileAbsolutePath = FileUtils.getFileAbsolutePath(this.folder);
        String workspaceAbsolutePath = FileUtils.getFileAbsolutePath(this.project.getProjectRoot().getParentFile());
        IPath fromOSString = Path.fromOSString((String)fileAbsolutePath);
        IPath workspace = Path.fromOSString((String)workspaceAbsolutePath);
        return fromOSString.makeRelativeTo(workspace);
    }

    @Override
    public IPath getLocation() {
        return Path.fromOSString((String)FileUtils.getFileAbsolutePath(this.folder));
    }

    @Override
    public IProject getProject() {
        return this.project;
    }
}

