/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.python.pydev.shared_core.string.FastStringBuffer;

public abstract class BaseParsingUtils {
    protected boolean throwSyntaxError;

    public BaseParsingUtils(boolean throwSyntaxError) {
        this.throwSyntaxError = throwSyntaxError;
    }

    public static BaseParsingUtils create(Object cs) {
        return BaseParsingUtils.create(cs, false);
    }

    public static BaseParsingUtils create(Object cs, boolean throwSyntaxError, int len) {
        if (cs instanceof char[]) {
            char[] cs2 = (char[])cs;
            return new FixedLenCharArrayParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof FastStringBuffer) {
            FastStringBuffer cs2 = (FastStringBuffer)cs;
            return new FixedLenFastStringBufferParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof StringBuffer) {
            StringBuffer cs2 = (StringBuffer)cs;
            return new FixedLenStringBufferParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof String) {
            String cs2 = (String)cs;
            return new FixedLenStringParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof IDocument) {
            IDocument cs2 = (IDocument)cs;
            return new FixedLenIDocumentParsingUtils(cs2, throwSyntaxError, len);
        }
        throw new RuntimeException("Don't know how to create instance for: " + cs.getClass());
    }

    public static BaseParsingUtils create(Object cs, boolean throwSyntaxError) {
        if (cs instanceof char[]) {
            char[] cs2 = (char[])cs;
            return new FixedLenCharArrayParsingUtils(cs2, throwSyntaxError, cs2.length);
        }
        if (cs instanceof FastStringBuffer) {
            FastStringBuffer cs2 = (FastStringBuffer)cs;
            return new FastStringBufferParsingUtils(cs2, throwSyntaxError);
        }
        if (cs instanceof StringBuffer) {
            StringBuffer cs2 = (StringBuffer)cs;
            return new StringBufferParsingUtils(cs2, throwSyntaxError);
        }
        if (cs instanceof String) {
            String cs2 = (String)cs;
            return new FixedLenStringParsingUtils(cs2, throwSyntaxError, cs2.length());
        }
        if (cs instanceof IDocument) {
            IDocument cs2 = (IDocument)cs;
            return new IDocumentParsingUtils(cs2, throwSyntaxError);
        }
        throw new RuntimeException("Don't know how to create instance for: " + cs.getClass());
    }

    public abstract char charAt(int var1);

    public abstract int len();

    public static String getContentType(IDocument document, int i) {
        IDocumentPartitionerExtension2 extension = (IDocumentPartitionerExtension2)document.getDocumentPartitioner();
        return extension.getContentType(i, true);
    }

    public int findNextChar(int offset, char findChar) {
        int l = this.len();
        int i = offset;
        while (i < l) {
            char c = this.charAt(i);
            if (c == findChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final class FastStringBufferParsingUtils
    extends BaseParsingUtils {
        private final FastStringBuffer cs;

        public FastStringBufferParsingUtils(FastStringBuffer cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        @Override
        public int len() {
            return this.cs.length();
        }

        @Override
        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenCharArrayParsingUtils
    extends BaseParsingUtils {
        private final char[] cs;
        private final int len;

        public FixedLenCharArrayParsingUtils(char[] cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        @Override
        public int len() {
            return this.len;
        }

        @Override
        public char charAt(int i) {
            return this.cs[i];
        }
    }

    private static final class FixedLenFastStringBufferParsingUtils
    extends BaseParsingUtils {
        private final FastStringBuffer cs;
        private final int len;

        public FixedLenFastStringBufferParsingUtils(FastStringBuffer cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        @Override
        public int len() {
            return this.len;
        }

        @Override
        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenIDocumentParsingUtils
    extends BaseParsingUtils {
        private final IDocument cs;
        private final int len;

        public FixedLenIDocumentParsingUtils(IDocument cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        @Override
        public int len() {
            return this.len;
        }

        @Override
        public char charAt(int i) {
            try {
                return this.cs.getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class FixedLenStringBufferParsingUtils
    extends BaseParsingUtils {
        private final StringBuffer cs;
        private final int len;

        public FixedLenStringBufferParsingUtils(StringBuffer cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        @Override
        public int len() {
            return this.len;
        }

        @Override
        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenStringParsingUtils
    extends BaseParsingUtils {
        private final String cs;
        private final int len;

        public FixedLenStringParsingUtils(String cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        @Override
        public int len() {
            return this.len;
        }

        @Override
        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class IDocumentParsingUtils
    extends BaseParsingUtils {
        private final IDocument cs;

        public IDocumentParsingUtils(IDocument cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        @Override
        public int len() {
            return this.cs.getLength();
        }

        @Override
        public char charAt(int i) {
            try {
                return this.cs.getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class StringBufferParsingUtils
    extends BaseParsingUtils {
        private final StringBuffer cs;

        public StringBufferParsingUtils(StringBuffer cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        @Override
        public int len() {
            return this.cs.length();
        }

        @Override
        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }
}

