/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocUtils;

public class TextSelectionUtils {
    protected IDocument doc;
    protected ICoreTextSelection textSelection;

    public TextSelectionUtils(IDocument doc, ICoreTextSelection selection) {
        this.doc = doc;
        this.textSelection = selection;
    }

    public TextSelectionUtils(IDocument doc, int offset) {
        this(doc, new CoreTextSelection(doc, offset, 0));
    }

    public final int getLineOffset() {
        return this.getLineOffset(this.getCursorLine());
    }

    public final int getLineOffset(int line) {
        try {
            return this.getDoc().getLineInformation(line).getOffset();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public final IDocument getDoc() {
        return this.doc;
    }

    public final int getCursorLine() {
        return this.getTextSelection().getEndLine();
    }

    public final ICoreTextSelection getTextSelection() {
        return this.textSelection;
    }

    public final int getAbsoluteCursorOffset() {
        return this.getTextSelection().getOffset();
    }

    public static int getFirstCharPosition(String src) {
        int i = 0;
        boolean breaked = false;
        int len = src.length();
        while (i < len) {
            if (!Character.isWhitespace(src.charAt(i))) {
                ++i;
                breaked = true;
                break;
            }
            ++i;
        }
        if (!breaked) {
            ++i;
        }
        return i - 1;
    }

    public final int getEndLineOffset(int line) throws BadLocationException {
        IRegion lineInformation = this.doc.getLineInformation(line);
        return lineInformation.getOffset() + lineInformation.getLength();
    }

    public final int getEndLineOffset() {
        IRegion endLine = this.getEndLine();
        return endLine.getOffset() + endLine.getLength();
    }

    public final IRegion getEndLine() {
        int endLineIndex;
        block3: {
            try {
                endLineIndex = this.getEndLineIndex();
                if (endLineIndex != -1) break block3;
                return null;
            }
            catch (BadLocationException e) {
                Log.log(e);
                return null;
            }
        }
        return this.getDoc().getLineInformation(endLineIndex);
    }

    public final int getEndLineIndex() {
        return this.getTextSelection().getEndLine();
    }

    public IRegion getStartLine() {
        try {
            return this.getDoc().getLineInformation(this.getStartLineIndex());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getStartLineIndex() {
        return this.getTextSelection().getStartLine();
    }

    public void selectCompleteLine() {
        if (this.doc.getNumberOfLines() == 1) {
            this.textSelection = new CoreTextSelection(this.doc, 0, this.doc.getLength());
            return;
        }
        IRegion endLine = this.getEndLine();
        IRegion startLine = this.getStartLine();
        this.textSelection = new CoreTextSelection(this.doc, startLine.getOffset(), endLine.getOffset() + endLine.getLength() - startLine.getOffset());
    }

    public String getSelectedText() throws BadLocationException {
        ICoreTextSelection txtSel = this.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        return this.doc.get(start, len);
    }

    public void selectAll(boolean forceNewSelection) {
        if (!forceNewSelection && this.getSelLength() > 0) {
            return;
        }
        this.textSelection = new CoreTextSelection(this.doc, 0, this.doc.getLength());
    }

    public int getSelLength() {
        return this.getTextSelection().getLength();
    }

    public String getCursorLineContents() {
        IRegion endLine;
        int start;
        block5: {
            IRegion startLine;
            block4: {
                try {
                    startLine = this.getStartLine();
                    if (startLine != null) break block4;
                    return "";
                }
                catch (BadLocationException e) {
                    Log.log(e);
                    return "";
                }
            }
            start = startLine.getOffset();
            endLine = this.getEndLine();
            if (endLine != null) break block5;
            return "";
        }
        int end = endLine.getOffset() + endLine.getLength();
        return this.doc.get(start, end - start);
    }

    public static String getDelimiter(IDocument doc) {
        return TextUtilities.getDefaultLineDelimiter((IDocument)doc);
    }

    public String getEndLineDelim() {
        return TextSelectionUtils.getDelimiter(this.getDoc());
    }

    public char getCharAfterCurrentOffset() throws BadLocationException {
        return this.getDoc().getChar(this.getAbsoluteCursorOffset() + 1);
    }

    public char getCharAtCurrentOffset() throws BadLocationException {
        return this.getDoc().getChar(this.getAbsoluteCursorOffset());
    }

    public char getCharBeforeCurrentOffset() throws BadLocationException {
        return this.getDoc().getChar(this.getAbsoluteCursorOffset() - 1);
    }

    public static int getAbsoluteCursorOffset(IDocument doc, int line, int col) {
        try {
            IRegion offsetR = doc.getLineInformation(line);
            return offsetR.getOffset() + col;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getAbsoluteCursorOffset(int line, int col) {
        return TextSelectionUtils.getAbsoluteCursorOffset(this.doc, line, col);
    }

    public void setSelection(int absoluteStart, int absoluteEnd) {
        this.textSelection = new CoreTextSelection(this.doc, absoluteStart, absoluteEnd - absoluteStart);
    }

    public int getCursorColumn() {
        try {
            int absoluteOffset = this.getAbsoluteCursorOffset();
            IRegion region = this.doc.getLineInformationOfOffset(absoluteOffset);
            return absoluteOffset - region.getOffset();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLine() {
        return TextSelectionUtils.getLine(this.getDoc(), this.getCursorLine());
    }

    public String getLine(int i) {
        return TextSelectionUtils.getLine(this.getDoc(), i);
    }

    public static String getLine(IDocument doc, int i) {
        try {
            IRegion lineInformation = doc.getLineInformation(i);
            return doc.get(lineInformation.getOffset(), lineInformation.getLength());
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getLineOfOffset() {
        return this.getLineOfOffset(this.getAbsoluteCursorOffset());
    }

    public int getLineOfOffset(int offset) {
        return TextSelectionUtils.getLineOfOffset(this.getDoc(), offset);
    }

    public static int getLineOfOffset(IDocument doc, int offset) {
        try {
            return doc.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            if (offset > doc.getLength() - 1) {
                int numberOfLines = doc.getNumberOfLines();
                if (numberOfLines == 0) {
                    return 0;
                }
                return numberOfLines - 1;
            }
            return 0;
        }
    }

    public void deleteLine(int i) {
        TextSelectionUtils.deleteLine(this.getDoc(), i);
    }

    public static void deleteLine(IDocument doc, int i) {
        try {
            IRegion lineInformation = doc.getLineInformation(i);
            int offset = lineInformation.getOffset();
            int length = -1;
            if (doc.getNumberOfLines() > i) {
                int nextLineOffset = doc.getLineInformation(i + 1).getOffset();
                length = nextLineOffset - offset;
            } else {
                length = lineInformation.getLength();
            }
            if (length > -1) {
                doc.replace(offset, length, "");
            }
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    public void deleteSpacesAfter(int offset) {
        try {
            int len = this.countSpacesAfter(offset);
            if (len > 0) {
                this.doc.replace(offset, len, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int countSpacesAfter(int offset) throws BadLocationException {
        if (offset >= this.doc.getLength()) {
            return 0;
        }
        int initial = offset;
        String next = this.doc.get(offset, 1);
        try {
            while (next.charAt(0) == ' ' || next.charAt(0) == '\t') {
                next = this.doc.get(++offset, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return offset - initial;
    }

    public void deleteSelection() throws BadLocationException {
        int offset = this.textSelection.getOffset();
        this.doc.replace(offset, this.textSelection.getLength(), "");
    }

    public void addLine(String contents, int afterLine) {
        TextSelectionUtils.addLine(this.getDoc(), this.getEndLineDelim(), contents, afterLine);
    }

    public static void addLine(IDocument doc, String endLineDelim, String contents, int afterLine) {
        Tuple<Integer, String> offsetAndContentsToAddLine = TextSelectionUtils.getOffsetAndContentsToAddLine(doc, endLineDelim, contents, afterLine);
        if (offsetAndContentsToAddLine != null) {
            try {
                doc.replace(((Integer)offsetAndContentsToAddLine.o1).intValue(), 0, (String)offsetAndContentsToAddLine.o2);
            }
            catch (BadLocationException e) {
                Log.log(e);
            }
        }
    }

    public static Tuple<Integer, String> getOffsetAndContentsToAddLine(IDocument doc, String endLineDelim, String contents, int afterLine) {
        try {
            int offset = -1;
            offset = doc.getNumberOfLines() > afterLine ? doc.getLineInformation(afterLine + 1).getOffset() : doc.getLineInformation(afterLine).getOffset();
            if (doc.getNumberOfLines() - 1 == afterLine) {
                contents = String.valueOf(endLineDelim) + contents;
            }
            if (!contents.endsWith(endLineDelim)) {
                contents = String.valueOf(contents) + endLineDelim;
            }
            if (offset >= 0) {
                return new Tuple<Integer, String>(offset, contents);
            }
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
        return null;
    }

    public String getLineContentsFromCursor() throws BadLocationException {
        return this.getLineContentsFromCursor(this.getAbsoluteCursorOffset());
    }

    public String getLineContentsFromCursor(int offset) throws BadLocationException {
        int lineOfOffset = this.doc.getLineOfOffset(offset);
        IRegion lineInformation = this.doc.getLineInformation(lineOfOffset);
        String lineToCursor = this.doc.get(offset, lineInformation.getOffset() + lineInformation.getLength() - offset);
        return lineToCursor;
    }

    public String getLineContentsToCursor() throws BadLocationException {
        int offset = this.getAbsoluteCursorOffset();
        return this.getLineContentsToCursor(offset);
    }

    public String getLineContentsToCursor(int offset) throws BadLocationException {
        return TextSelectionUtils.getLineContentsToCursor(this.doc, offset);
    }

    public static String getLineContentsToCursor(IDocument doc, int offset) throws BadLocationException {
        int lineOfOffset = doc.getLineOfOffset(offset);
        IRegion lineInformation = doc.getLineInformation(lineOfOffset);
        String lineToCursor = doc.get(lineInformation.getOffset(), offset - lineInformation.getOffset());
        return lineToCursor;
    }

    public Tuple<String, String> getBeforeAndAfterMatchingChars(char c) {
        int initial = this.getAbsoluteCursorOffset();
        int curr = initial - 1;
        IDocument doc = this.getDoc();
        FastStringBuffer buf = new FastStringBuffer(10);
        int length = doc.getLength();
        while (curr >= 0 && curr < length) {
            char gotten;
            try {
                gotten = doc.getChar(curr);
            }
            catch (BadLocationException e) {
                break;
            }
            if (gotten != c) break;
            buf.append(c);
            --curr;
        }
        String before = buf.toString();
        buf.clear();
        curr = initial;
        while (curr >= 0 && curr < length) {
            char gotten;
            try {
                gotten = doc.getChar(curr);
            }
            catch (BadLocationException e) {
                break;
            }
            if (gotten != c) break;
            buf.append(c);
            ++curr;
        }
        String after = buf.toString();
        return new Tuple<String, String>(before, after);
    }

    public int getStartLineOffset() {
        IRegion startLine = this.getStartLine();
        return startLine.getOffset();
    }

    public String getFullRepAfterSelection() throws BadLocationException {
        int absoluteCursorOffset = this.getAbsoluteCursorOffset();
        int length = this.doc.getLength();
        int end = absoluteCursorOffset;
        char ch = this.doc.getChar(end);
        while (Character.isLetterOrDigit(ch) || ch == '.') {
            if (length - 1 < ++end) break;
            ch = this.doc.getChar(end);
        }
        return this.doc.get(absoluteCursorOffset, end - absoluteCursorOffset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple<String, Integer> extractActivationToken(IDocument document, int offset, boolean getFullQualifier) {
        try {
            int i;
            if (getFullQualifier) {
                char ch;
                while (offset < document.getLength() && Character.isJavaIdentifierPart(ch = document.getChar(offset))) {
                    ++offset;
                }
            }
            if ((i = offset) > document.getLength()) {
                return new Tuple<String, Integer>("", document.getLength());
            }
            while (true) {
                if (i <= 0) {
                    return new Tuple<String, Integer>(document.get(i, offset - i), offset);
                }
                char ch = document.getChar(i - 1);
                if (!Character.isJavaIdentifierPart(ch)) {
                    return new Tuple<String, Integer>(document.get(i, offset - i), offset);
                }
                --i;
            }
        }
        catch (BadLocationException e) {
            return new Tuple<String, Integer>("", offset);
        }
    }

    public static boolean containsOnly(char c, String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsOnlyWhitespaces(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isWhitespace(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getIndentationFromLine(String selection) {
        int firstCharPosition = TextSelectionUtils.getFirstCharPosition(selection);
        return selection.substring(0, firstCharPosition);
    }

    public String getIndentationFromLine() {
        return TextSelectionUtils.getIndentationFromLine(this.getCursorLineContents());
    }

    public static int getFirstCharRelativePosition(IDocument doc, IRegion region) throws BadLocationException {
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        return TextSelectionUtils.getFirstCharPosition(src);
    }

    public static int getFirstCharRelativeLinePosition(IDocument doc, int line) throws BadLocationException {
        IRegion region = doc.getLineInformation(line);
        return TextSelectionUtils.getFirstCharRelativePosition(doc, region);
    }

    public static int getFirstCharRelativePosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        return TextSelectionUtils.getFirstCharRelativePosition(doc, region);
    }

    public static int getFirstCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        return offset + TextSelectionUtils.getFirstCharRelativePosition(doc, cursorOffset);
    }

    public int getFirstCharPositionInCurrentCursorOffset() throws BadLocationException {
        return TextSelectionUtils.getFirstCharPosition(this.getDoc(), this.getAbsoluteCursorOffset());
    }

    public boolean intersects(int offset, int len) {
        int currLen;
        int currOffset = this.textSelection.getOffset();
        if (offset >= currOffset + (currLen = this.textSelection.getLength())) {
            return false;
        }
        return offset + len > currOffset;
    }

    public Tuple<String, Integer> getCurrToken() throws BadLocationException {
        int start;
        Tuple<String, Integer> tup = TextSelectionUtils.extractActivationToken(this.doc, this.getAbsoluteCursorOffset(), false);
        String prefix = (String)tup.o1;
        int end = start = (Integer)tup.o2 - prefix.length();
        while (this.doc.getLength() - 1 >= end) {
            char ch = this.doc.getChar(end);
            if (!Character.isJavaIdentifierPart(ch)) break;
            ++end;
        }
        String post = this.doc.get(((Integer)tup.o2).intValue(), end - (Integer)tup.o2);
        return new Tuple<String, Integer>(String.valueOf(prefix) + post, start);
    }

    /*
     * Unable to fully structure code
     */
    public Tuple<String, Integer> getCurrToken(Set<Character> separatorChars) throws BadLocationException {
        offset = this.getAbsoluteCursorOffset();
        i = offset;
        if (i <= this.doc.getLength()) ** GOTO lbl7
        return new Tuple<String, Integer>("", this.doc.getLength());
        while (!separatorChars.contains(Character.valueOf(ch = this.doc.getChar(i - 1))) && !Character.isWhitespace(ch)) {
            --i;
lbl7:
            // 2 sources

            if (i > 0) continue;
        }
        tup = new Tuple<String, Integer>(this.doc.get(i, offset - i), offset);
        prefix = (String)tup.o1;
        end = start = (Integer)tup.o2 - prefix.length();
        while (this.doc.getLength() - 1 >= end) {
            ch = this.doc.getChar(end);
            if (separatorChars.contains(Character.valueOf(ch)) || Character.isWhitespace(ch)) break;
            ++end;
        }
        post = this.doc.get(((Integer)tup.o2).intValue(), end - (Integer)tup.o2);
        return new Tuple<String, Integer>(String.valueOf(prefix) + post, start);
    }

    public void replaceLineContentsToSelection(String newContents) throws BadLocationException {
        int lineOfOffset = this.getDoc().getLineOfOffset(this.getAbsoluteCursorOffset());
        IRegion lineInformation = this.getDoc().getLineInformation(lineOfOffset);
        this.getDoc().replace(lineInformation.getOffset(), this.getAbsoluteCursorOffset() - lineInformation.getOffset(), newContents);
    }

    /*
     * Unable to fully structure code
     */
    public static int eatFuncCall(IDocument theDoc, int documentOffset) throws BadLocationException {
        c = theDoc.get(documentOffset, 1);
        if (c.equals(")")) ** GOTO lbl5
        throw new AssertionError((Object)("Expecting ) to eat callable. Received: " + c));
lbl-1000:
        // 1 sources

        {
            --documentOffset;
lbl5:
            // 2 sources

            ** while (documentOffset > 0 && !theDoc.get((int)documentOffset, (int)1).equals((Object)"("))
        }
lbl6:
        // 1 sources

        return documentOffset;
    }

    public static boolean endsWithSomeChar(char[] cs, String activationToken) {
        int i = 0;
        while (i < cs.length) {
            if (activationToken.endsWith(String.valueOf(cs[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<Integer> getLineStartOffsets(String replacementString) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(0);
        int i = 0;
        while (i < replacementString.length()) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                int foundAt = ++i;
                if (i < replacementString.length() && (c = replacementString.charAt(i)) == '\n') {
                    foundAt = i + 1;
                }
                ret.add(foundAt);
            } else if (c == '\n') {
                ret.add(i + 1);
            }
            ++i;
        }
        return ret;
    }

    public static List<Integer> getLineBreakOffsets(String replacementString) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int lineBreaks = 0;
        int ignoreNextNAt = -1;
        int i = 0;
        while (i < replacementString.length()) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                ++lineBreaks;
                ret.add(i);
                ignoreNextNAt = i + 1;
            } else if (c == '\n' && ignoreNextNAt != i) {
                ret.add(i);
                ++lineBreaks;
            }
            ++i;
        }
        return ret;
    }

    public static boolean isInside(int offset, IRegion region) {
        return offset >= region.getOffset() && offset <= region.getOffset() + region.getLength();
    }

    public static boolean isInside(int col, int initialCol, int len) {
        return col >= initialCol && col <= initialCol + len;
    }

    public static boolean endsInSameLine(IDocument document, IRegion region) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int end = region.getOffset() + region.getLength();
            int endLine = document.getLineOfOffset(end);
            return startLine == endLine;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public Tuple<Integer, Integer> getLineAndCol(int offset) {
        try {
            IRegion region = this.doc.getLineInformationOfOffset(offset);
            int line = this.doc.getLineOfOffset(offset);
            int col = offset - region.getOffset();
            return new Tuple<Integer, Integer>(line, col);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getToColon() {
        FastStringBuffer buffer = new FastStringBuffer();
        int docLen = this.doc.getLength();
        int i = this.getLineOffset();
        while (i < docLen) {
            try {
                char c = this.doc.getChar(i);
                buffer.append(c);
                if (c == ':') {
                    return buffer.toString();
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return "";
    }

    public IRegion getRegion() {
        return new Region(this.textSelection.getOffset(), this.textSelection.getLength());
    }

    public int getEndOfDocummentOffset() {
        int length = this.doc.getLength();
        return length;
    }

    public List<IRegion> searchOccurrences(String searchFor) {
        ArrayList<IRegion> lst = new ArrayList<IRegion>();
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.doc);
        boolean regExSearch = false;
        boolean wholeWord = true;
        boolean caseSensitive = true;
        boolean forwardSearch = true;
        int startOffset = 0;
        try {
            IRegion found;
            while ((found = adapter.find(startOffset, searchFor, forwardSearch, caseSensitive, wholeWord, regExSearch)) != null) {
                lst.add(found);
                startOffset = found.getOffset() + found.getLength();
            }
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
        return lst;
    }

    public static boolean endsWithNewline(IDocument document, String text) {
        String[] newlines = document.getLegalLineDelimiters();
        boolean ends = false;
        int i = 0;
        while (i < newlines.length) {
            String delimiter = newlines[i];
            if (text.indexOf(delimiter) != -1) {
                ends = true;
            }
            ++i;
        }
        return ends;
    }

    public static void setOnlyDifferentCode(IDocument doc, String docContents, String newContents) {
        DocUtils.updateDocRangeWithContents(doc, docContents, newContents);
    }

    public Tuple<String, Integer> getCurrDottedStatement(ICharacterPairMatcher2 pairMatcher) throws BadLocationException {
        int absoluteCursorOffset;
        int start = absoluteCursorOffset = this.getAbsoluteCursorOffset();
        int i = absoluteCursorOffset - 1;
        while (i >= 0) {
            char c = this.doc.getChar(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                int j;
                if (!StringUtils.isClosingPeer(c) || (j = pairMatcher.searchForOpeningPeer(i, StringUtils.getPeer(c), c, this.doc)) < 0) break;
                i = j;
            }
            start = i--;
        }
        int len = this.doc.getLength();
        int end = absoluteCursorOffset;
        int i2 = absoluteCursorOffset;
        while (i2 < len) {
            char c = this.doc.getChar(i2);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                int j;
                if (!StringUtils.isOpeningPeer(c) || (j = pairMatcher.searchForClosingPeer(i2, c, StringUtils.getPeer(c), this.doc)) < 0) break;
                i2 = j;
            }
            end = i2 + 1;
            ++i2;
        }
        if (start != end) {
            return new Tuple<String, Integer>(this.doc.get(start, end - start), start);
        }
        return new Tuple<String, Integer>("", absoluteCursorOffset);
    }

    public static void endWrite(IDocument doc, DocumentRewriteSession session) {
        if (doc instanceof IDocumentExtension4 && session != null) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            d.stopRewriteSession(session);
        }
    }

    public static DocumentRewriteSession startWrite(IDocument doc) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            return d.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
        }
        return null;
    }

    public void performSimpleSort(IDocument doc, int startLine, int endLine) {
        String endLineDelim = this.getEndLineDelim();
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer lastLine = null;
            int i = startLine;
            while (i <= endLine) {
                String line = TextSelectionUtils.getLine(doc, i);
                if (lastLine != null) {
                    int len = lastLine.length();
                    if (len > 0 && lastLine.charAt(len - 1) == '\\') {
                        lastLine.append(endLineDelim);
                        lastLine.append(line);
                    } else {
                        list.add(lastLine.toString());
                        lastLine = new StringBuffer(line);
                    }
                } else {
                    lastLine = new StringBuffer(line);
                }
                ++i;
            }
            if (lastLine != null) {
                list.add(lastLine.toString());
            }
            Collections.sort(list);
            StringBuffer all = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                all.append(element);
                if (!iter.hasNext()) continue;
                all.append(endLineDelim);
            }
            int length = doc.getLineInformation(endLine).getLength();
            int endOffset = doc.getLineInformation(endLine).getOffset() + length;
            int startOffset = doc.getLineInformation(startLine).getOffset();
            doc.replace(startOffset, endOffset - startOffset, all.toString());
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    public String getContentsFromLineRange(int startLine, int endLine) {
        try {
            IRegion startRegion = this.doc.getLineInformation(startLine);
            IRegion endRegion = this.doc.getLineInformation(endLine);
            String contents = this.doc.get(startRegion.getOffset(), endRegion.getOffset() + endRegion.getLength() - startRegion.getOffset());
            return contents;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

