/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.additionalinfo.builders.AnalysisBuilderVisitor;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisRunner;
import com.python.pydev.analysis.external.IExternalCodeAnalysisVisitor;
import com.python.pydev.analysis.flake8.Flake8VisitorFactory;
import com.python.pydev.analysis.mypy.MypyVisitorFactory;
import com.python.pydev.analysis.pylint.PyLintVisitorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IObjectActionDelegate;
import org.python.pydev.ast.builder.VisitorMemo;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.listing_utils.PyFileListing;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.ui.actions.resources.PyResourceAction;

public class ForceCodeAnalysisOnTree
extends PyResourceAction
implements IObjectActionDelegate {
    private Set<IFile> filesVisited = new HashSet<IFile>();

    @Override
    protected boolean confirmRun() {
        return true;
    }

    @Override
    protected void afterRun(int resourcesAffected) {
        this.filesVisited.clear();
    }

    @Override
    protected void beforeRun() {
        this.filesVisited.clear();
    }

    @Override
    protected int doActionOnResource(IResource next, IProgressMonitor monitor) {
        ArrayList<IExternalCodeAnalysisVisitor> externalVisitors = new ArrayList<IExternalCodeAnalysisVisitor>();
        ArrayList<IFile> filesToVisit = new ArrayList<IFile>();
        PythonNature nature = PythonNature.getPythonNature((IResource)next);
        if (nature == null) {
            return 1;
        }
        if (next instanceof IContainer) {
            List l = PyFileListing.getAllIFilesBelow((IContainer)((IContainer)next));
            for (IFile element : l) {
                if (element == null || !PythonPathHelper.isValidSourceFile((IFile)element)) continue;
                filesToVisit.add(element);
            }
            IExternalCodeAnalysisVisitor pyLintVisitor = PyLintVisitorFactory.create((IResource)next, null, null, (IProgressMonitor)monitor);
            IExternalCodeAnalysisVisitor mypyVisitor = MypyVisitorFactory.create((IResource)next, null, null, (IProgressMonitor)monitor);
            IExternalCodeAnalysisVisitor flake8Visitor = Flake8VisitorFactory.create((IResource)next, null, null, (IProgressMonitor)monitor);
            externalVisitors.add(pyLintVisitor);
            externalVisitors.add(mypyVisitor);
            externalVisitors.add(flake8Visitor);
        } else if (next instanceof IFile && PythonPathHelper.isValidSourceFile((IFile)((IFile)next))) {
            filesToVisit.add((IFile)next);
        }
        ForceCodeAnalysisOnTree.forceCodeAnalysisOnFiles(nature, monitor, filesToVisit, this.filesVisited, externalVisitors);
        return 1;
    }

    public static void forceCodeAnalysisOnFiles(PythonNature nature, IProgressMonitor monitor, List<IFile> filesToVisit, Set<IFile> filesVisited, List<IExternalCodeAnalysisVisitor> externalVisitors) {
        if (nature == null) {
            return;
        }
        AnalysisBuilderVisitor visitor = new AnalysisBuilderVisitor();
        visitor.visitingWillStart((IProgressMonitor)new NullProgressMonitor(), false, null);
        FastStringBuffer buf = new FastStringBuffer();
        for (IFile f : filesToVisit) {
            String moduleName;
            if (monitor.isCanceled()) break;
            if (filesVisited.contains(f)) continue;
            filesVisited.add(f);
            monitor.setTaskName(buf.clear().append("Scheduling: ").append(f.getName()).toString());
            IDocument doc = FileUtilsFileBuffer.getDocFromResource((IResource)f);
            visitor.memo = new VisitorMemo();
            visitor.memo.put((Object)"IS_FULL_BUILD", (Object)false);
            long documentTime = System.currentTimeMillis();
            visitor.memo.put((Object)"DOCUMENT_TIME", (Object)documentTime);
            try {
                moduleName = nature.resolveModule((IResource)f);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                continue;
            }
            if (moduleName == null) continue;
            AnalysisBuilderVisitor.setModuleNameInCache((Map)visitor.memo, (IResource)f, (String)moduleName);
            if (!PythonPathHelper.isValidSourceFile((IFile)f)) {
                AnalysisRunner.deleteMarkers((IResource)f, (boolean)true);
                continue;
            }
            IModule module = nature.getAstManager().getModule(moduleName, (IPythonNature)nature, true, (IModuleRequestState)new BaseModuleRequest(false));
            if (module == null) {
                Log.log((int)2, (String)("Unable to get module: " + moduleName + " for resource: " + f), null);
                continue;
            }
            visitor.doVisitChangedResource((IPythonNature)nature, (IResource)f, doc, null, module, (IProgressMonitor)new NullProgressMonitor(), true, 2, documentTime, false, externalVisitors);
        }
        visitor.visitingEnded((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected boolean needsUIThread() {
        return false;
    }
}

