/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.actions.GlobalsDialogFactory;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.interpreter_managers.ChooseInterpreterManager;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;

public class PyGlobalsBrowser
extends PyAction {
    public void run(IAction action) {
        String selectedText;
        IPythonNature pythonNature;
        try {
            pythonNature = this.getPyEdit().getPythonNature();
        }
        catch (MisconfigurationException e1) {
            PyGlobalsBrowser.handle(e1);
            return;
        }
        PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this.getPyEdit());
        try {
            selectedText = ps.getSelectedText();
        }
        catch (BadLocationException e1) {
            selectedText = null;
        }
        if (selectedText == null || selectedText.length() == 0) {
            try {
                selectedText = (String)ps.getCurrToken().o1;
            }
            catch (BadLocationException e1) {
                // empty catch block
            }
        }
        if (pythonNature != null) {
            IInterpreterManager manager = pythonNature.getRelatedInterpreterManager();
            PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, manager);
        } else {
            this.getFromSystemManager(selectedText);
        }
    }

    private void getFromSystemManager(String selectedText) {
        File editorFile = this.getPyEdit().getEditorFile();
        Tuple infoForFile = editorFile != null ? InterpreterManagersAPI.getInfoForFile((File)editorFile) : null;
        if (infoForFile != null) {
            IPythonNature systemPythonNature = (IPythonNature)infoForFile.o1;
            if (systemPythonNature == null) {
                PyGlobalsBrowser.getFromWorkspace(selectedText);
                return;
            }
            IInterpreterManager manager = ((IPythonNature)infoForFile.o1).getRelatedInterpreterManager();
            PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, manager);
        } else {
            PyGlobalsBrowser.getFromWorkspace(selectedText);
        }
    }

    public static void getFromWorkspace(String selectedText) {
        IInterpreterManager useManager = ChooseInterpreterManager.chooseInterpreterManager();
        if (useManager == null) {
            return;
        }
        PyGlobalsBrowser.getFromManagerAndRelatedNatures(selectedText, useManager);
    }

    private static void handle(MisconfigurationException e) {
        Log.log((Throwable)e);
    }

    private static void getFromManagerAndRelatedNatures(String selectedText, IInterpreterManager useManager) {
        AbstractAdditionalDependencyInfo additionalSystemInfo;
        try {
            additionalSystemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo((IInterpreterManager)useManager, (String)useManager.getDefaultInterpreterInfo(true).getExecutableOrJar());
        }
        catch (MisconfigurationException e) {
            MessageDialog.openError((Shell)EditorUtils.getShell(), (String)"Error", (String)"Additional info is not available (default interpreter not configured).");
            PyGlobalsBrowser.handle(e);
            return;
        }
        ArrayList<AbstractAdditionalTokensInfo> additionalInfo = new ArrayList<AbstractAdditionalTokensInfo>();
        additionalInfo.add((AbstractAdditionalTokensInfo)additionalSystemInfo);
        List natures = PythonNature.getPythonNaturesRelatedTo((int)useManager.getInterpreterType());
        for (IPythonNature nature : natures) {
            try {
                AbstractAdditionalDependencyInfo info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
                if (info == null) continue;
                additionalInfo.add((AbstractAdditionalTokensInfo)info);
            }
            catch (MisconfigurationException e) {
                PyGlobalsBrowser.handle(e);
            }
        }
        PyGlobalsBrowser.doSelect(natures, additionalInfo, selectedText);
    }

    public static void doSelect(List<IPythonNature> pythonNatures, List<AbstractAdditionalTokensInfo> additionalInfo, String selectedText) {
        SelectionDialog dialog = GlobalsDialogFactory.create(EditorUtils.getShell(), additionalInfo, selectedText);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0) {
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                IInfo entry;
                Object obj = objectArray[n2];
                if (obj instanceof AdditionalInfoAndIInfo) {
                    AdditionalInfoAndIInfo additional = (AdditionalInfoAndIInfo)obj;
                    try {
                        if (additional.additionalInfo instanceof AdditionalProjectInterpreterInfo) {
                            AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)additional.additionalInfo;
                            IProject iProject = projectInterpreterInfo.getProject();
                            PythonNature pythonNature = PythonNature.getPythonNature((IProject)iProject);
                            if (pythonNature != null) {
                                pythonNatures = new ArrayList<IPythonNature>();
                                pythonNatures.add((IPythonNature)pythonNature);
                            }
                        } else if (additional.additionalInfo instanceof AdditionalSystemInterpreterInfo) {
                            AdditionalSystemInterpreterInfo systemInterpreterInfo = (AdditionalSystemInterpreterInfo)additional.additionalInfo;
                            SystemPythonNature systemPythonNature = new SystemPythonNature(systemInterpreterInfo.getManager());
                            pythonNatures = new ArrayList<IPythonNature>();
                            pythonNatures.add((IPythonNature)systemPythonNature);
                        }
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                    entry = additional.info;
                } else {
                    entry = (IInfo)obj;
                }
                ArrayList pointers = new ArrayList();
                CompletionState completionCache = new CompletionState();
                for (IPythonNature iPythonNature : pythonNatures) {
                    ICodeCompletionASTManager astManager = iPythonNature.getAstManager();
                    if (astManager == null) continue;
                    AnalysisPlugin.getDefinitionFromIInfo(pointers, (ICodeCompletionASTManager)astManager, (IPythonNature)iPythonNature, (IInfo)entry, (ICompletionState)completionCache, (boolean)false, (boolean)true);
                    if (pointers.size() <= 0) continue;
                    new PyOpenAction().run((ItemPointer)pointers.get(0));
                    break;
                }
                ++n2;
            }
        }
    }
}

