/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1;

import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.ast.analysis.IAnalysisPreferences;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class IgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Set<Integer> handled = new HashSet<Integer>();
    private FormatStd format;

    public IgnoreErrorParticipant() {
        this(null);
    }

    IgnoreErrorParticipant(FormatStd format) {
        this.format = format;
    }

    @Override
    public void addProps(MarkerAnnotationAndPosition marker, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, PyEdit edit, List<ICompletionProposalHandle> props) throws BadLocationException, CoreException {
        Integer id = (Integer)marker.markerAnnotation.getMarker().getAttribute("PYDEV_TYPE");
        if (this.handled.contains(id)) {
            return;
        }
        this.handled.add(id);
        String messageToIgnore = analysisPreferences.getRequiredMessageToIgnore(id.intValue());
        if (CheckAnalysisErrors.isCodeAnalysisErrorHandled((String)line, (String)messageToIgnore)) {
            return;
        }
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        ICompletionProposalHandle proposal = CompletionProposalFactory.get().createIgnoreCompletionProposalInSameLine(messageToIgnore, ps.getEndLineOffset(), 0, offset, imageCache != null ? imageCache.get("icons/annotation_obj.gif") : null, messageToIgnore.substring(1), null, null, 10, (IPyEdit)edit, line, ps, this.format);
        props.add(proposal);
    }
}

