/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1.pylint;

import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.ast.analysis.IAnalysisPreferences;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PyLintIgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Set<String> handled = new HashSet<String>();
    private FormatStd format;

    public PyLintIgnoreErrorParticipant() {
        this(null);
    }

    PyLintIgnoreErrorParticipant(FormatStd format) {
        this.format = format;
    }

    @Override
    public void addProps(MarkerAnnotationAndPosition marker, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, PyEdit edit, List<ICompletionProposalHandle> props) throws BadLocationException, CoreException {
        IMarker m = marker.markerAnnotation.getMarker();
        Object attribute = m.getAttribute("pylint_message_id");
        if (attribute == null) {
            return;
        }
        String messageId = attribute.toString();
        if (this.handled.contains(messageId)) {
            return;
        }
        this.handled.add(messageId);
        if (CheckAnalysisErrors.isPyLintErrorHandledAtLine((String)line, (String)messageId)) {
            return;
        }
        ICompletionProposalHandle proposal = CompletionProposalFactory.get().createIgnorePyLintCompletionProposalInSameLine(messageId, ps.getEndLineOffset(), 0, offset, SharedUiPlugin.getImageCache().get("icons/annotation_obj.gif"), "pylint: disable=" + messageId, null, null, 10, (IPyEdit)edit, line, ps, this.format, m);
        props.add(proposal);
    }
}

