/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.search_index;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IReferenceSearches;
import com.python.pydev.analysis.search_index.PyModuleLineElement;
import com.python.pydev.analysis.search_index.PyModuleMatch;
import com.python.pydev.analysis.search_index.PyScopeAndData;
import com.python.pydev.analysis.search_index.PySearchResult;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_ui.search.AbstractSearchIndexQuery;
import org.python.pydev.shared_ui.search.SearchIndexData;
import org.python.pydev.shared_ui.search.SearchIndexResult;
import org.python.pydev.shared_ui.search.SearchResultUpdater;
import org.python.pydev.shared_ui.search.StringMatcherWithIndexSemantics;

public class PySearchIndexQuery
extends AbstractSearchIndexQuery {
    private SearchIndexResult fResult;

    public PySearchIndexQuery(String text) {
        super(text);
    }

    public PySearchIndexQuery(SearchIndexData data) {
        super(data);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        SearchIndexResult searchResult = (SearchIndexResult)this.getSearchResult();
        searchResult.removeAll();
        StringMatcherWithIndexSemantics stringMatcher = this.createStringMatcher();
        Set moduleNamesFilter = this.scopeAndData.getModuleNamesFilter();
        OrderedMap fieldNameToValues = new OrderedMap();
        if (moduleNamesFilter != null && !moduleNamesFilter.isEmpty()) {
            fieldNameToValues.put((Object)"module_name", (Object)moduleNamesFilter);
        }
        Set split = this.makeTextFieldPatternsToSearchFromText();
        fieldNameToValues.put((Object)"contents", (Object)split);
        List<IPythonNature> pythonNatures = PyScopeAndData.getPythonNatures(this.scopeAndData);
        monitor.beginTask("Search indexes", pythonNatures.size());
        try {
            for (IPythonNature nature : pythonNatures) {
                AbstractAdditionalDependencyInfo info;
                try {
                    info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
                }
                catch (MisconfigurationException e) {
                    Log.log((Throwable)e);
                    continue;
                }
                IReferenceSearches referenceSearches = info.getReferenceSearches();
                List search = referenceSearches.search(nature.getProject(), fieldNameToValues, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                for (ModulesKey modulesKey : search) {
                    IFile workspaceFile;
                    File file = modulesKey.file;
                    if (file == null || !file.exists()) {
                        Log.logInfo((String)StringUtils.format((String)"Ignoring: %s. File no longer exists.", (Object[])new Object[]{file}));
                    }
                    if ((workspaceFile = FindWorkspaceFiles.getWorkspaceFile((File)file, (IProject)nature.getProject())) == null) {
                        Log.logInfo((String)StringUtils.format((String)"Ignoring: %s. Unable to resolve to a file in the Eclipse workspace.", (Object[])new Object[]{file}));
                        continue;
                    }
                    IDocument doc = FileUtilsFileBuffer.getDocFromResource((IResource)workspaceFile);
                    String text = doc.get();
                    this.createMatches(doc, text, stringMatcher, workspaceFile, (AbstractTextSearchResult)searchResult, modulesKey);
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void createMatches(IDocument doc, String text, StringMatcherWithIndexSemantics stringMatcher, IFile workspaceFile, AbstractTextSearchResult searchResult, ModulesKey modulesKey) {
        StringMatcherWithIndexSemantics.Position find = stringMatcher.find(text, 0);
        while (find != null) {
            int offset = find.getStart();
            int end = find.getEnd();
            int length = end - offset;
            PySelection ps = new PySelection(doc, offset);
            int lineNumber = ps.getLineOfOffset();
            String lineContents = ps.getLine(lineNumber);
            int lineStartOffset = ps.getLineOffset(lineNumber);
            PyModuleLineElement element = new PyModuleLineElement((IResource)workspaceFile, lineNumber, lineStartOffset, lineContents, modulesKey);
            searchResult.addMatch((Match)new PyModuleMatch(workspaceFile, offset, length, element, modulesKey));
            find = stringMatcher.find(text, end);
        }
    }

    public String getLabel() {
        return "PyDev Index Search";
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PySearchResult(this);
            new SearchResultUpdater((AbstractTextSearchResult)this.fResult);
        }
        return this.fResult;
    }
}

