/*
 * Decompiled with CFR 0.152.
 */
package org.python.copiedfromeclipsesrc;

import java.net.MalformedURLException;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.ui.pythonpathconf.NameAndExecutable;
import org.python.pydev.ui.pythonpathconf.conda.CondaConfigDialog;

public abstract class PythonListEditor
extends FieldEditor {
    public static boolean USE_ICONS = true;
    private Tree treeWithInterpreters;
    private Composite buttonBox;
    private MenuItem configManualMenuItem;
    protected MenuItem autoConfigMenuItem;
    protected MenuItem pipenvConfigMenuItem;
    protected MenuItem advAutoConfigMenuItem;
    protected Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;
    private Image imageInterpreter;
    private Menu menu;
    private Button configCondaButton;
    private Composite parent;
    private Button setDefaultButton;
    private MenuItem chooseFromCondaMenuItem;

    protected abstract IInterpreterManager getInterpreterManager();

    protected PythonListEditor() {
        if (USE_ICONS) {
            this.imageInterpreter = ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/python_16x16.png"));
        }
    }

    protected PythonListEditor(String name, String labelText, Composite parent) {
        this();
        this.init(name, labelText);
        this.createControl(parent);
    }

    public void addPressed(int configType) {
        NameAndExecutable input = this.getNewInputObject(configType);
        if (input != null && input.o1 != null && input.o2 != null) {
            this.setPresentsDefaultValue(false);
            TreeItem item = this.createInterpreterItem(input.o1, input.o2);
            try {
                this.treeWithInterpreters.setSelection(item);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            this.selectionChanged();
            this.updateTree();
        }
    }

    protected abstract void updateTree();

    protected TreeItem createInterpreterItem(String name, String executable) {
        TreeItem item = new TreeItem(this.treeWithInterpreters, 0);
        item.setText(new String[]{name, executable});
        item.setImage(this.imageInterpreter);
        return item;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.treeWithInterpreters.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) throws MalformedURLException {
        this.parent = box.getParent();
        int interpreterType = this.getInterpreterManager().getInterpreterType();
        String selectTitle = "";
        switch (interpreterType) {
            case 0: {
                selectTitle = "Brows&e for python/pypy exe";
                break;
            }
            case 1: {
                selectTitle = "Brows&e for Jython jar";
                break;
            }
            case 2: {
                selectTitle = "Brows&e for ipy exe";
                break;
            }
            default: {
                Log.log((String)("Unhandled type: " + interpreterType));
                selectTitle = "Select executable";
            }
        }
        final Button newButton = this.createPushButton(box, "&New ... ", "Configure a new Python or PyPy interpreter.");
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Point loc = newButton.getLocation();
                Rectangle rect = newButton.getBounds();
                Point mLoc = new Point(loc.x - 1, loc.y + rect.height);
                PythonListEditor.this.menu.setLocation(newButton.getShell().getDisplay().map((Control)newButton.getParent(), null, mLoc));
                PythonListEditor.this.menu.setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.menu = new Menu((Control)newButton);
        this.configManualMenuItem = this.createMenuItem(this.menu, selectTitle);
        if (interpreterType == 0) {
            this.pipenvConfigMenuItem = this.createMenuItem(this.menu, "&New with Pipenv");
        }
        this.autoConfigMenuItem = this.createMenuItem(this.menu, "Config &first in PATH");
        this.advAutoConfigMenuItem = this.createMenuItem(this.menu, "Choose from &list");
        this.advAutoConfigMenuItem.setToolTipText("Choose from a list of valid interpreters, and select the folders to be in the SYSTEM pythonpath.");
        if (interpreterType == 0) {
            this.chooseFromCondaMenuItem = this.createMenuItem(this.menu, "Choose from &Conda");
        }
        this.upButton = this.createButtonWithImage(box, "icons/up_arrow.png", "Move selected Python interpreter up");
        this.upButton.setText("&Up");
        this.downButton = this.createButtonWithImage(box, "icons/down_arrow.png", "Move selected Python interpreter down");
        this.downButton.setText("&Down");
        this.setDefaultButton = this.createPushButton(box, "&Set as Default", "Make the selected Python interpreter the default interpreter");
        this.removeButton = this.createButtonWithImage(box, "icons/remove.gif", "Remove the selected interpreter");
        this.removeButton.setText("&Remove");
        if (interpreterType == 0) {
            this.configCondaButton = this.createPushButton(box, "Config &Conda", "Configures conda (to be able to manage conda-based Python interpreters)");
        }
    }

    protected String createList(String[] items) {
        throw new RuntimeException("doLoad/doStore should be overridden (so that it's not needed)");
    }

    private Button createPushButton(Composite parent, String key, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        this.setControlLayout((Control)button);
        button.setToolTipText(tooltip);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private Button createButtonWithImage(Composite parent, String imageURL, String tooltip) {
        Button button = new Button(parent, 0);
        button.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get(imageURL)));
        button.setToolTipText(tooltip);
        this.setControlLayout((Control)button);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private void setControlLayout(Control control) {
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels(control, 61);
        data.widthHint = Math.max(widthHint, control.computeSize((int)-1, (int)-1, (boolean)true).x);
        control.setLayoutData((Object)data);
    }

    private MenuItem createMenuItem(Menu menu, String key) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(key);
        menuItem.addSelectionListener(this.getSelectionListener());
        return menuItem;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == PythonListEditor.this.configManualMenuItem) {
                    PythonListEditor.this.addPressed(0);
                } else if (widget == PythonListEditor.this.autoConfigMenuItem) {
                    PythonListEditor.this.addPressed(1);
                } else if (PythonListEditor.this.pipenvConfigMenuItem != null && widget == PythonListEditor.this.pipenvConfigMenuItem) {
                    PythonListEditor.this.addPressed(3);
                } else if (widget == PythonListEditor.this.advAutoConfigMenuItem) {
                    PythonListEditor.this.addPressed(2);
                } else if (widget == PythonListEditor.this.chooseFromCondaMenuItem) {
                    PythonListEditor.this.addPressed(4);
                } else if (PythonListEditor.this.configCondaButton != null && widget == PythonListEditor.this.configCondaButton) {
                    PythonListEditor.this.configCondaPressed();
                } else if (widget == PythonListEditor.this.setDefaultButton) {
                    PythonListEditor.this.setDefaultPressed();
                } else if (widget == PythonListEditor.this.removeButton) {
                    PythonListEditor.this.removePressed();
                } else if (widget == PythonListEditor.this.upButton) {
                    PythonListEditor.this.upPressed();
                } else if (widget == PythonListEditor.this.downButton) {
                    PythonListEditor.this.downPressed();
                } else if (widget == PythonListEditor.this.treeWithInterpreters) {
                    PythonListEditor.this.selectionChanged();
                }
            }
        };
    }

    private void configCondaPressed() {
        CondaConfigDialog condaConfigDialog = new CondaConfigDialog(this.parent.getShell());
        condaConfigDialog.open();
    }

    private void setDefaultPressed() {
        boolean ret = true;
        while (ret) {
            ret = this.swap(true);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.treeWithInterpreters = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.treeWithInterpreters.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected abstract void doLoad();

    protected abstract void doLoadDefault();

    protected abstract void doStore();

    protected void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            try {
                this.createButtons(this.buttonBox);
            }
            catch (MalformedURLException e) {
                Log.log((Throwable)e);
            }
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PythonListEditor.this.configManualMenuItem = null;
                    PythonListEditor.this.autoConfigMenuItem = null;
                    PythonListEditor.this.pipenvConfigMenuItem = null;
                    PythonListEditor.this.removeButton = null;
                    PythonListEditor.this.upButton = null;
                    PythonListEditor.this.downButton = null;
                    PythonListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Tree getListControl(Composite parent) {
        if (this.treeWithInterpreters == null) {
            this.treeWithInterpreters = new Tree(parent, 2820);
            this.treeWithInterpreters.setHeaderVisible(true);
            TreeColumn column1 = new TreeColumn(this.treeWithInterpreters, 16384);
            column1.setText("Name");
            column1.setWidth(200);
            TreeColumn column2 = new TreeColumn(this.treeWithInterpreters, 16384);
            column2.setText("Location");
            column2.setWidth(200);
            this.treeWithInterpreters.setFont(parent.getFont());
            this.treeWithInterpreters.addSelectionListener(this.getSelectionListener());
            this.treeWithInterpreters.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PythonListEditor.this.treeWithInterpreters = null;
                }
            });
        } else {
            this.checkParent((Control)this.treeWithInterpreters, parent);
        }
        return this.treeWithInterpreters;
    }

    protected abstract NameAndExecutable getNewInputObject(int var1);

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.configManualMenuItem == null) {
            return null;
        }
        return this.configManualMenuItem.getParent().getShell();
    }

    protected String[] parseString(String stringList) {
        throw new RuntimeException("doLoad/doStore should be overridden (so that it's not needed)");
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        TreeItem[] selection = this.treeWithInterpreters.getSelection();
        if (selection != null && selection.length > 0) {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem t = treeItemArray[n2];
                this.disposeOfTreeItem(t);
                ++n2;
            }
            this.selectionChanged();
            this.updateTree();
        }
    }

    protected void disposeOfTreeItem(TreeItem t) {
        t.dispose();
    }

    protected void selectionChanged() {
        int index = this.getSelectionIndex();
        int size = this.treeWithInterpreters.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.setDefaultButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.treeWithInterpreters != null) {
            this.treeWithInterpreters.setFocus();
        }
    }

    protected int getSelectionIndex() {
        if (this.treeWithInterpreters.getSelectionCount() != 1) {
            return -1;
        }
        TreeItem[] selection = this.treeWithInterpreters.getSelection();
        int index = -1;
        if (selection != null && selection.length > 0) {
            index = this.treeWithInterpreters.indexOf(selection[0]);
        }
        return index;
    }

    private boolean swap(boolean up) {
        boolean ret;
        this.setPresentsDefaultValue(false);
        int index = this.getSelectionIndex();
        int target = up ? index - 1 : index + 1;
        boolean bl = ret = target >= 0 && target < this.treeWithInterpreters.getItemCount();
        if (ret) {
            TreeItem curr = this.treeWithInterpreters.getItem(index);
            TreeItem replace = this.treeWithInterpreters.getItem(target);
            String col0 = replace.getText(0);
            String col1 = replace.getText(1);
            replace.setText(new String[]{curr.getText(0), curr.getText(1)});
            curr.setText(new String[]{col0, col1});
            this.treeWithInterpreters.setSelection(this.treeWithInterpreters.getItem(target));
            this.selectionChanged();
        }
        return ret;
    }

    protected void upPressed() {
        this.swap(true);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.configManualMenuItem.setEnabled(enabled);
        this.autoConfigMenuItem.setEnabled(enabled);
        if (this.pipenvConfigMenuItem != null) {
            this.pipenvConfigMenuItem.setEnabled(enabled);
        }
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }
}

