/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;

public class PyDevBuilderPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button onlyAnalyzeOpenCheckBox;
    private Button removeErrorsCheckBox;
    private static final String[][] ENTRIES_AND_VALUES = new String[][]{{"Delete any orphaned .pyc file.", Integer.toString(0)}, {"Only delete .pyc when .py delete is detected.", Integer.toString(1)}, {"Never delete .pyc files.", Integer.toString(2)}};

    public PyDevBuilderPrefPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("PyDev builders");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        String s = "WARNING: \n\nPyDev builders are required for many features \nprovided by Pydev such as:\n\n- Code completion\n- PyLint\n- TODO tasks\n\nSo, if you choose to disable it, note that the features \nmentioned above may not work as expected or may even not \nwork at all (use at your own risk).\n";
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", s, p));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_PYDEV_BUILDERS", "Use builders?", p));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_PYDEV_ONLY_ON_DOC_SAVE", "Disable parser notifications?", p));
        this.addField((FieldEditor)new IntegerFieldEditor("PYDEV_ELAPSE_BEFORE_ANALYSIS", "Time to elapse before reparsing changed file (millis)", p));
        s = "If only open editors are analyzed, markers will only be added\nto the opened PyDev editors.\n";
        this.addField((FieldEditor)new LabelFieldEditor("ActiveBufferLabelFieldEditor", s, p));
        BooleanFieldEditorWithPublicGetControl onlyAnalyzeOpen = new BooleanFieldEditorWithPublicGetControl("ANALYZE_ONLY_ACTIVE_EDITOR_2", "Only analyze open editors?", p);
        this.addField((FieldEditor)onlyAnalyzeOpen);
        BooleanFieldEditorWithPublicGetControl removeErrors = new BooleanFieldEditorWithPublicGetControl("REMOVE_ERRORS_WHEN_EDITOR_IS_CLOSED_2", "Remove errors when editor is closed?", p);
        this.addField((FieldEditor)removeErrors);
        this.removeErrorsCheckBox = removeErrors.getChangeControl(p);
        this.onlyAnalyzeOpenCheckBox = onlyAnalyzeOpen.getChangeControl(p);
        this.onlyAnalyzeOpenCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PyDevBuilderPrefPage.this.updateCheckEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)new ComboFieldEditor("PYC_DELETE_HANDLING", "How to handle .pyc/$py.class deletion?", ENTRIES_AND_VALUES, p));
    }

    public void dispose() {
        super.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.updateCheckEnabledState();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateCheckEnabledState();
    }

    public void init(IWorkbench workbench) {
    }

    private void updateCheckEnabledState() {
        if (this.removeErrorsCheckBox != null && !this.removeErrorsCheckBox.isDisposed() && this.onlyAnalyzeOpenCheckBox != null && !this.onlyAnalyzeOpenCheckBox.isDisposed()) {
            this.removeErrorsCheckBox.setEnabled(this.onlyAnalyzeOpenCheckBox.getSelection());
        }
    }

    private final class BooleanFieldEditorWithPublicGetControl
    extends BooleanFieldEditor {
        private BooleanFieldEditorWithPublicGetControl(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        public Button getChangeControl(Composite parent) {
            Button checkBox = super.getChangeControl(parent);
            return checkBox;
        }
    }
}

