/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pylint;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;
import org.python.pydev.utils.CustomizableFieldEditor;

public class PyLintPrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int COLS = 4;
    public static final String[][] LABEL_AND_VALUE = new String[][]{{"Error", String.valueOf(2)}, {"Warning", String.valueOf(1)}, {"Info", String.valueOf(0)}, {"Ignore", String.valueOf(-1)}};
    public static final String[][] SEARCH_PYLINT_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "SEARCH"}, {"Specify Location", "SPECIFY"}};
    private FileFieldEditor fileField;
    private RadioGroupFieldEditor searchPyLintLocation;
    private Composite parent;

    public PyLintPrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("PyLint");
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor("USE_PYLINT", "Use PyLint?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_CONSOLE", "Redirect PyLint output to console?", this.parent));
        this.searchPyLintLocation = new RadioGroupFieldEditor("SEARCH_PYLINT_LOCATION", "PyLint to use", 2, SEARCH_PYLINT_LOCATION_OPTIONS, this.parent);
        Button[] buttonArray = this.searchPyLintLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PyLintPrefPage.this.updateSelectFileEnablement(PyLintPrefPage.this.parent);
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.searchPyLintLocation);
        this.fileField = new FileFieldEditor("PYLINT_FILE_LOCATION", "Location of the pylint executable:", true, this.parent);
        this.addField((FieldEditor)this.fileField);
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_FATAL", "FATAL Severity", 4, LABEL_AND_VALUE, this.parent, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_ERRORS", "ERRORS Severity", 4, LABEL_AND_VALUE, this.parent, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_WARNINGS", "WARNINGS Severity", 4, LABEL_AND_VALUE, this.parent, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_CODING_STANDARD", "CONVENTIONS Severity", 4, LABEL_AND_VALUE, this.parent, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_REFACTOR", "REFACTOR Severity", 4, LABEL_AND_VALUE, this.parent, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_INFO", "INFORMATIONAL Severity", 4, LABEL_AND_VALUE, this.parent, true));
        CustomizableFieldEditor stringFieldEditor = new CustomizableFieldEditor("PYLINT_ARGS", "Arguments to pass to the pylint command (customize its output):\nAdd --rcfile=.pylintrc to use an rcfile relative to the project directory.", this.parent);
        this.addField(stringFieldEditor);
        this.addField((FieldEditor)new LinkFieldEditor("PYLINT_HELP", "View <a>http://www.pydev.org/manual_adv_pylint.html</a> for help.", this.parent, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.pydev.org/manual_adv_pylint.html");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(this.parent, "org.python.pydev.analysis", (ScopedFieldEditorPreferencePage)this));
    }

    protected void initialize() {
        super.initialize();
        this.updateSelectFileEnablement(this.parent);
    }

    protected void updateSelectFileEnablement(Composite p) {
        this.fileField.setEnabled("SPECIFY".equals(this.searchPyLintLocation.getRadioValue()), p);
    }

    public void init(IWorkbench workbench) {
    }
}

