/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.compare;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.actions.PyPeerLinker;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.actions.FirstCharAction;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyMergeViewer
extends TextMergeViewer {
    private List<ColorAndStyleCache> colorCache;
    private List<IPropertyChangeListener> prefChangeListeners;

    public PyMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style | 0x2000000, configuration);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return PyPartitionScanner.createPyPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "__PYTHON_PARTITION_TYPE";
    }

    private IPythonNature getPythonNature(Object compareInput) {
        IResource resource = this.getResource(compareInput);
        if (resource != null) {
            return PythonNature.getPythonNature((IResource)resource);
        }
        return null;
    }

    private IResource getResource(Object compareInput) {
        if (!(compareInput instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)compareInput;
        IResourceProvider rp = null;
        ITypedElement te = input.getLeft();
        if (te instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getRight()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getAncestor()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp != null) {
            return rp.getResource();
        }
        return null;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        SourceViewer viewer = super.createSourceViewer(parent, textOrientation);
        viewer.appendVerifyKeyListener(PyPeerLinker.createVerifyKeyListener((TextViewer)viewer));
        viewer.appendVerifyKeyListener(PyBackspace.createVerifyKeyListener((TextViewer)viewer, null));
        IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        IWorkbenchPartSite site = null;
        if (workbenchPart != null) {
            site = workbenchPart.getSite();
        } else {
            IWorkbenchPart activePart;
            IWorkbenchPage activePage;
            IWorkbenchWindow window = EditorUtils.getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null && (activePart = activePage.getActivePart()) != null) {
                site = activePart.getSite();
            }
        }
        VerifyKeyListener createVerifyKeyListener = FirstCharAction.createVerifyKeyListener((SourceViewer)viewer);
        viewer.appendVerifyKeyListener(createVerifyKeyListener);
        return viewer;
    }

    private List<ColorAndStyleCache> getColorCache() {
        if (this.colorCache == null) {
            this.colorCache = new ArrayList<ColorAndStyleCache>();
        }
        return this.colorCache;
    }

    public List<IPropertyChangeListener> getPrefChangeListeners() {
        if (this.prefChangeListeners == null) {
            this.prefChangeListeners = new ArrayList<IPropertyChangeListener>();
        }
        return this.prefChangeListeners;
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (!(textViewer instanceof SourceViewer)) {
            return;
        }
        final SourceViewer sourceViewer = (SourceViewer)textViewer;
        IAdaptable adaptable = sourceViewer instanceof IAdaptable ? (IAdaptable)sourceViewer : new IAdaptable(){

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
        DefaultIndentPrefs indentPrefs = new DefaultIndentPrefs(adaptable);
        WeakReference[] sourceViewerConfigurationObj = new WeakReference[1];
        IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
        ColorAndStyleCache c = new ColorAndStyleCache(chainedPrefStore);
        this.getColorCache().add(c);
        IPySyntaxHighlightingAndCodeCompletionEditor editor = new IPySyntaxHighlightingAndCodeCompletionEditor((IIndentPrefs)indentPrefs, sourceViewerConfigurationObj, c){
            private final /* synthetic */ IIndentPrefs val$indentPrefs;
            private final /* synthetic */ WeakReference[] val$sourceViewerConfigurationObj;
            private final /* synthetic */ ColorAndStyleCache val$c;
            {
                this.val$indentPrefs = iIndentPrefs;
                this.val$sourceViewerConfigurationObj = weakReferenceArray;
                this.val$c = colorAndStyleCache;
            }

            public void resetForceTabs() {
            }

            public void resetIndentPrefixes() {
                PyEditConfigurationWithoutEditor configuration = this.getEditConfiguration();
                String[] types = configuration.getConfiguredContentTypes((ISourceViewer)sourceViewer);
                int i = 0;
                while (i < types.length) {
                    String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)sourceViewer, types[i]);
                    if (prefixes != null && prefixes.length > 0) {
                        sourceViewer.setIndentPrefixes(prefixes, types[i]);
                    }
                    ++i;
                }
            }

            public IIndentPrefs getIndentPrefs() {
                return this.val$indentPrefs;
            }

            public ISourceViewer getEditorSourceViewer() {
                return sourceViewer;
            }

            public PyEditConfigurationWithoutEditor getEditConfiguration() {
                return (PyEditConfigurationWithoutEditor)((Object)this.val$sourceViewerConfigurationObj[0].get());
            }

            public ColorAndStyleCache getColorCache() {
                return this.val$c;
            }

            public PySelection createPySelection() {
                ISelection selection = sourceViewer.getSelection();
                if (selection instanceof ITextSelection) {
                    return PySelectionFromEditor.createPySelectionFromEditor((ISourceViewer)sourceViewer, (ITextSelection)selection);
                }
                return null;
            }

            public File getEditorFile() {
                IResource file = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                if (file != null && file instanceof IFile) {
                    IPath path = file.getLocation().makeAbsolute();
                    return path.toFile();
                }
                return null;
            }

            public IPythonNature getPythonNature() throws MisconfigurationException {
                return PyMergeViewer.this.getPythonNature(PyMergeViewer.this.getInput());
            }

            public int getGrammarVersion() throws MisconfigurationException {
                IPythonNature pythonNature = this.getPythonNature();
                if (pythonNature == null) {
                    Log.logInfo((String)"Expected to get the PythonNature at this point...");
                    return 104;
                }
                return pythonNature.getGrammarVersion();
            }

            public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                IPythonNature pythonNature = this.getPythonNature();
                if (pythonNature == null) {
                    Log.logInfo((String)"Expected to get the PythonNature at this point...");
                    return null;
                }
                return pythonNature.getAdditionalGrammarVersions();
            }

            public Object getAdapter(Class adapter) {
                IResource resource;
                if (adapter == IResource.class) {
                    return PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                }
                if (adapter == IFile.class && (resource = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput())) instanceof IFile) {
                    return resource;
                }
                if (adapter == IProject.class && (resource = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput())) instanceof IFile) {
                    return resource.getProject();
                }
                return null;
            }
        };
        PyEditConfiguration sourceViewerConfiguration = new PyEditConfiguration(c, editor, chainedPrefStore);
        sourceViewerConfiguration.getPyAutoIndentStrategy((IAdaptable)editor);
        sourceViewerConfigurationObj[0] = new WeakReference<PyEditConfiguration>(sourceViewerConfiguration);
        sourceViewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        IPropertyChangeListener prefChangeListener = PyEdit.createPrefChangeListener(editor);
        this.getPrefChangeListeners().add(prefChangeListener);
        chainedPrefStore.addPropertyChangeListener(prefChangeListener);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        List<ColorAndStyleCache> colorCache = this.getColorCache();
        for (ColorAndStyleCache c : colorCache) {
            c.dispose();
        }
        colorCache.clear();
        List<IPropertyChangeListener> prefChangeListeners = this.getPrefChangeListeners();
        for (IPropertyChangeListener l : prefChangeListeners) {
            PyDevUiPrefs.getChainedPrefStore().removePropertyChangeListener(l);
        }
        prefChangeListeners.clear();
    }
}

