/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

final class DialogNotifier
extends Dialog {
    private static final int BOLD_COLS = 120;

    public DialogNotifier(Shell shell) {
        super(shell);
        this.setShellStyle(0xC70 | DialogNotifier.getDefaultOrientation());
        this.setBlockOnOpen(true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = null;
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 1;
        String msg = "Help keeping PyDev supported";
        this.createLabel(composite, WrapAndCaseUtils.wrap((String)msg, (int)120), 1);
        try {
            String html = "<html><head><base href=\"http://pydev.org\" ><title>Keeping PyDev supported</title></head><body>I'm reaching out for you today to ask for your help to keep PyDev properly supported.<br/><br/>PyDev is kept as an open source product and relies on contributions to remain being developed, so, if you feel that's a worthy goal, please take a look at <a href=\"http://pydev.org\">http://pydev.org</a> and contribute if you can.<br/><br/>Thank you,<br/><br/>Fabio<br/><br/>p.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.</body></html>";
            ToolBar navBar = new ToolBar(composite, 0);
            final Browser browser = new Browser(composite, 2048);
            browser.setText("<html><head><base href=\"http://pydev.org\" ><title>Keeping PyDev supported</title></head><body>I'm reaching out for you today to ask for your help to keep PyDev properly supported.<br/><br/>PyDev is kept as an open source product and relies on contributions to remain being developed, so, if you feel that's a worthy goal, please take a look at <a href=\"http://pydev.org\">http://pydev.org</a> and contribute if you can.<br/><br/>Thank you,<br/><br/>Fabio<br/><br/>p.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.</body></html>");
            gridData = new GridData(1808);
            browser.setLayoutData((Object)gridData);
            ToolItem back = new ToolItem(navBar, 8);
            back.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/backward_nav.gif")));
            ToolItem forward = new ToolItem(navBar, 8);
            forward.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/forward_nav.gif")));
            ToolItem stop = new ToolItem(navBar, 8);
            stop.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/showerr_tsk.gif")));
            ToolItem refresh = new ToolItem(navBar, 8);
            refresh.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/refresh_nav.gif")));
            ToolItem home = new ToolItem(navBar, 8);
            home.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/home_nav.gif")));
            back.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.back();
                }
            });
            forward.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.forward();
                }
            });
            stop.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.stop();
                }
            });
            refresh.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.refresh();
                }
            });
            home.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.setText("<html><head><base href=\"http://pydev.org\" ><title>Keeping PyDev supported</title></head><body>I'm reaching out for you today to ask for your help to keep PyDev properly supported.<br/><br/>PyDev is kept as an open source product and relies on contributions to remain being developed, so, if you feel that's a worthy goal, please take a look at <a href=\"http://pydev.org\">http://pydev.org</a> and contribute if you can.<br/><br/>Thank you,<br/><br/>Fabio<br/><br/>p.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.</body></html>");
                }
            });
        }
        catch (Throwable e) {
            String msg2 = "I'm reaching out for you today to ask for your help to keep PyDev\nproperly supported.\n\nPyDev is kept as an open source product and relies on contributions\nto remain being developed, so, if you feel that's a worthy goal, please\ntake a look at http://pydev.org and contribute if you can.\n\nThank you,\n\nFabio\n\np.s.: Sorry for the dialog. It won't be shown again in this workspace after\nyou click the \"Read it\" button.\n";
            this.createText(composite, msg2, 1);
        }
        return composite;
    }

    public boolean doClose() {
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, " Show later ", true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DialogNotifier.this.doClose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button = this.createButton(parent, 1024, " Read it ", true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DialogNotifier.this.doClose();
                IPreferenceStore preferenceStore = PyDevUiPrefs.getPreferenceStore();
                preferenceStore.setValue("PYDEV_FUNDING_SHOW_AT_TIME_2016", System.currentTimeMillis() + 31536000000L);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Text createText(Composite composite, String labelMsg, int colSpan) {
        Text text = new Text(composite, 2058);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = colSpan;
        text.setLayoutData((Object)gridData);
        text.setText(labelMsg);
        return text;
    }

    private Label createLabel(Composite composite, String labelMsg, int colSpan) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        label.setLayoutData((Object)gridData);
        label.setText(labelMsg);
        return label;
    }
}

