/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.IOfflineActionWithParameters;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.shared_core.string.StringUtils;

public class OfflineActionsManager {
    Map<String, ActionInfo> onOfflineActionListeners = new HashMap<String, ActionInfo>();

    public Collection<ActionInfo> getOfflineActionDescriptions() {
        return this.onOfflineActionListeners.values();
    }

    public void addOfflineActionListener(String key, IAction action) {
        this.onOfflineActionListeners.put(key.toLowerCase(), new ActionInfo(action, "not described", key.toLowerCase(), true));
    }

    public void addOfflineActionListener(String key, IAction action, String description, boolean needsEnter) {
        this.onOfflineActionListeners.put(key.toLowerCase(), new ActionInfo(action, description, key.toLowerCase(), needsEnter));
    }

    public boolean activatesAutomaticallyOn(String key) {
        ActionInfo info = this.onOfflineActionListeners.get(key.toLowerCase());
        return info != null && !info.needsEnter;
    }

    public boolean onOfflineAction(String requestedStr, OfflineActionTarget target) {
        IAction action;
        ActionInfo actionInfo = this.onOfflineActionListeners.get(requestedStr.toLowerCase());
        List<String> parameters = null;
        if (actionInfo == null) {
            List split = StringUtils.split((String)requestedStr, (char)' ');
            if (split.size() > 0) {
                actionInfo = this.onOfflineActionListeners.get(split.remove(0));
                parameters = split;
            }
            if (actionInfo == null) {
                target.statusError("No action info was found binded to:" + requestedStr);
                return false;
            }
        }
        if ((action = actionInfo.action) == null) {
            target.statusError("No action was found binded to:" + requestedStr);
            return false;
        }
        if (action instanceof IOfflineActionWithParameters) {
            if (parameters == null) {
                parameters = new ArrayList<String>();
            }
            ((IOfflineActionWithParameters)action).setParameters(parameters);
        }
        try {
            action.run();
        }
        catch (Throwable e) {
            target.statusError("Exception raised when executing action:" + requestedStr + " - " + e.getMessage());
            Log.log((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean hasOfflineAction(String key) {
        return this.onOfflineActionListeners.get(key.toLowerCase()) != null;
    }
}

