/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.framework.Version;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.changed_lines.ChangedLinesComputer;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ITabChangedListener;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NotConfiguredInterpreterException;
import org.python.pydev.core.ShellId;
import org.python.pydev.core.autoedit.PyAutoIndentStrategy;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.editor.OpenEditors;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.ICodeScannerKeywords;
import org.python.pydev.editor.OfflineActionsManager;
import org.python.pydev.editor.PyDocumentProvider;
import org.python.pydev.editor.PyEditBasedCodeScannerKeywords;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditTitle;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.PydevShowBrowserMessage;
import org.python.pydev.editor.actions.IExecuteLineAction;
import org.python.pydev.editor.actions.OfflineAction;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.actions.PyFormatAction;
import org.python.pydev.editor.actions.PyMoveLineDownAction;
import org.python.pydev.editor.actions.PyMoveLineUpAction;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.PyOrganizeImports;
import org.python.pydev.editor.actions.PyPeerLinker;
import org.python.pydev.editor.codecompletion.proposals.PyCompletionProposal;
import org.python.pydev.editor.codefolding.CodeFoldingSetter;
import org.python.pydev.editor.codefolding.PyEditProjection;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.correctionassist.PythonCorrectionProcessor;
import org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage;
import org.python.pydev.editor.scripting.PyEditScripting;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.outline.ParsedModel;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.fastparser.ScopesParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.CheckDefaultPreferencesDialog;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.image.UIConstants;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.parsing.IScopesParser;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor_input.PydevFileEditorInput;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.ColorAndStyleCache;
import org.python.pydev.ui.dialogs.PyDialogHelpers;

public class PyEdit
extends PyEditProjection
implements IPyEdit,
IGrammarVersionProvider,
IPySyntaxHighlightingAndCodeCompletionEditor,
IParserObserver3,
ITabChangedListener {
    public static final String PYDEV_EDITOR_KEYBINDINGS_CONTEXT_ID = "org.python.pydev.ui.editor.scope";
    public static final String PY_EDIT_CONTEXT = "#PyEditContext";
    public static final String PY_EDIT_RULER_CONTEXT = "#PyEditRulerContext";
    public static final String ACTION_OPEN = "OpenEditor";
    private ColorAndStyleCache colorCache;
    private IPropertyChangeListener prefListener;
    private PyAutoIndentStrategy indentStrategy;
    private PyEditConfiguration editConfiguration;
    private volatile SimpleNode ast;
    private volatile long astModificationTimeStamp = -1L;
    private volatile ErrorDescription errorDescription;
    private static List<IPyEditListener> editListeners;
    private PyEditScripting pyEditScripting;
    public final ICallbackWithListeners<Composite> onCreatePartControl = new CallbackWithListeners();
    public final ICallbackWithListeners<ISourceViewer> onAfterCreatePartControl = new CallbackWithListeners();
    public final ICallbackWithListeners<PyEdit> onCreateActions = new CallbackWithListeners();
    public final ICallbackWithListeners<Class<?>> onGetAdapter = new CallbackWithListeners();
    public final ICallbackWithListeners<LineNumberRulerColumn> onInitializeLineNumberRulerColumn = new CallbackWithListeners();
    public final ICallbackWithListeners<?> onDispose = new CallbackWithListeners();
    public final ICallbackWithListeners<PropertyChangeEvent> onHandlePreferenceStoreChanged = new CallbackWithListeners();
    public final ICallbackWithListeners<PySourceViewer> onCreateSourceViewer = new CallbackWithListeners();
    private boolean disposed = false;
    private CodeFoldingSetter codeFoldingSetter;
    public static final ICallbackWithListeners<PyEdit> onPyEditCreated;
    private boolean checkedEclipseVersion = false;
    private static final String INVALID_MODULE_MARKER_TYPE = "org.python.pydev.invalidpythonfilemarker";
    protected OfflineActionTarget fOfflineActionTarget;
    private PyOutlinePage outlinePage;
    private Tuple3<Integer, IModulesManager, String> handle;
    private final Object lockHandle = new Object();
    OfflineActionsManager offlineActionsManager = new OfflineActionsManager();
    private LocalResourceManager resourceManager;

    static {
        org.python.pydev.parser.jython.ParseException.verboseExceptions = true;
        onPyEditCreated = new CallbackWithListeners();
    }

    public PyEditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    public ColorAndStyleCache getColorCache() {
        return this.colorCache;
    }

    public PySelection createPySelection() {
        return PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this);
    }

    public TextSelectionUtils createTextSelectionUtils() {
        return PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this);
    }

    public ICoreTextSelection getTextSelection() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        return new CoreTextSelection(this.getDocument(), selection.getOffset(), selection.getLength());
    }

    public ISourceViewer getISourceViewer() {
        return this.getSourceViewer();
    }

    public IVerticalRuler getIVerticalRuler() {
        return this.getVerticalRuler();
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        super.initializeLineNumberRulerColumn(rulerColumn);
        this.onInitializeLineNumberRulerColumn.call((Object)rulerColumn);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        this.onHandlePreferenceStoreChanged.call((Object)event);
        this.updateHoverBehavior();
    }

    @Override
    public void createPartControl(Composite parent) {
        Composite newParent = (Composite)this.onCreatePartControl.call((Object)parent);
        if (newParent != null) {
            parent = newParent;
        }
        super.createPartControl(parent);
        this.onAfterCreatePartControl.call((Object)this.getSourceViewer());
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public PyEdit() {
        OpenEditors.addOpenedEditor((IPyEdit)this);
        try {
            onPyEditCreated.call((Object)this);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            if (editListeners == null) {
                editListeners = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pyedit_listener");
            }
            this.notifier.notifyEditorCreated();
            this.colorCache = new ColorAndStyleCache(PyDevUiPrefs.getChainedPrefStore());
            this.editConfiguration = new PyEditConfiguration(this.colorCache, this, PyDevUiPrefs.getChainedPrefStore());
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.editConfiguration);
            this.indentStrategy = this.editConfiguration.getPyAutoIndentStrategy((IAdaptable)this);
            this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
            this.codeFoldingSetter = new CodeFoldingSetter(this);
            CheckDefaultPreferencesDialog.askAboutSettings();
            PydevShowBrowserMessage.show();
            this.checkEclipseRunning();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    private void checkEclipseRunning() {
        if (this.checkedEclipseVersion) {
            return;
        }
        this.checkedEclipseVersion = true;
        try {
            String string = (String)Platform.getBundle((String)"org.eclipse.jface.text").getHeaders().get("Bundle-Version");
            Version version = new Version(string);
            if (version.compareTo(new Version("3.11.0")) < 0) {
                Log.log((String)"Error: This version of PyDev requires a newer version of Eclipse to run properly.");
                RunInUiThread.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PyDialogHelpers.openCritical("Eclipse version too old (4.6 -- Neon -- required).", "This version of PyDev requires a newer version of Eclipse to run properly.\n\nPlease upgrade Eclipse or use an older version of PyDev.\n\nSee: http://www.pydev.org/download.html for requirements\n(for this version or older versions).");
                    }
                }, (boolean)false);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    protected List<IPyEditListener> getAdditionalEditorListeners() {
        return editListeners;
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        PySourceViewer viewer = (PySourceViewer)super.createSourceViewer(parent, ruler, styles);
        viewer.appendVerifyKeyListener(PyPeerLinker.createVerifyKeyListener((TextViewer)viewer));
        viewer.appendVerifyKeyListener(PyBackspace.createVerifyKeyListener((TextViewer)viewer, this));
        this.onCreateSourceViewer.call((Object)viewer);
        return viewer;
    }

    public void resetForceTabs() {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (doc == null) {
            return;
        }
        IIndentPrefs indentPrefs = this.getIndentPrefs();
        if (!indentPrefs.getGuessTabSubstitution()) {
            indentPrefs.setForceTabs(false);
            return;
        }
        int lines = doc.getNumberOfLines();
        boolean forceTabs = false;
        int i = 0;
        while (i < lines) {
            block8: {
                try {
                    IRegion r = doc.getLineInformation(i);
                    String text = doc.get(r.getOffset(), r.getLength());
                    if (text == null) break block8;
                    if (text.startsWith("\t")) {
                        forceTabs = true;
                        break;
                    }
                    if (text.startsWith("  ")) {
                        forceTabs = false;
                    }
                    break block8;
                }
                catch (BadLocationException e) {
                    Log.log((int)4, (String)"Unexpected error forcing tabs", (Throwable)e);
                }
                break;
            }
            ++i;
        }
        indentPrefs.setForceTabs(forceTabs);
        this.editConfiguration.resetIndentPrefixes();
        if (forceTabs) {
            this.updateForceTabsMessage();
        }
    }

    public void updateForceTabsMessage() {
        boolean forceTabs = this.getIndentPrefs().getForceTabs();
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        IImageDescriptor desc = forceTabs ? imageCache.getDescriptor("icons/tabs_active.png") : imageCache.getDescriptor("icons/tabs_inactive.png");
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, forceTabs ? "Forcing tabs" : "Not forcing tabs.", ImageCache.asImageDescriptor((IImageDescriptor)desc).createImage());
        }
    }

    public IIndentPrefs getIndentPrefs() {
        return this.indentStrategy.getIndentPrefs();
    }

    public PyAutoIndentStrategy getAutoEditStrategy() {
        return this.indentStrategy;
    }

    public void resetIndentPrefixes() {
        super.updateIndentPrefixes();
    }

    protected void installTabsToSpacesConverter() {
        this.updateIndentPrefixes();
    }

    protected void uninstallTabsToSpacesConverter() {
        this.updateIndentPrefixes();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            IDocument document = this.getDocument(input);
            PyPartitionScanner.checkPartitionScanner((IDocument)document);
            final IPythonNature nature = PyEdit.addNature(input);
            final ShellId mainThreadShellId = AbstractShell.getShellId();
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            AbstractShell.getServerShell((IPythonNature)nature, (ShellId)mainThreadShellId);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread2.setName("Shell starter");
            thread2.start();
            this.prefListener = PyEdit.createPrefChangeListener(this);
            this.getIndentPrefs().addTabChangedListener((ITabChangedListener)this);
            this.resetForceTabs();
            PyDevUiPrefs.getChainedPrefStore().addPropertyChangeListener(this.prefListener);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        PyEdit.this.pyEditScripting = new PyEditScripting();
                        PyEdit.this.addPyeditListener(PyEdit.this.pyEditScripting);
                    }
                    finally {
                        PyEdit.this.markInitFinished();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setName("PyEdit initializer");
            thread.start();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    public void onTabSettingsChanged(IIndentPrefs prefs) {
        PyEdit.onTabSettingsChanged(this);
    }

    private static void onTabSettingsChanged(IPySyntaxHighlightingAndCodeCompletionEditor editor) {
        ISourceViewer sourceViewer = (ISourceViewer)editor.getEditorSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IIndentPrefs indentPrefs = editor.getIndentPrefs();
        indentPrefs.regenerateIndentString();
        sourceViewer.getTextWidget().setTabs(indentPrefs.getTabWidth());
        editor.resetForceTabs();
        editor.resetIndentPrefixes();
    }

    public static IPropertyChangeListener createPrefChangeListener(final IPySyntaxHighlightingAndCodeCompletionEditor editor) {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                try {
                    String property = event.getProperty();
                    if (property.equals("TAB_WIDTH")) {
                        PyEdit.onTabSettingsChanged(editor);
                    } else if (property.equals("SUBSTITUTE_TABS")) {
                        PyEdit.onTabSettingsChanged(editor);
                    } else if (property.equals("GUESS_TAB_SUBSTITUTION")) {
                        PyEdit.onTabSettingsChanged(editor);
                    } else if (ColorAndStyleCache.isColorOrStyleProperty(property)) {
                        editor.getColorCache().reloadProperty(property);
                        editor.getEditConfiguration().updateSyntaxColorAndStyle();
                        ((ISourceViewer)editor.getEditorSourceViewer()).invalidateTextPresentation();
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
    }

    private void checkAddInvalidModuleNameMarker(IDocument doc, IFile file) {
        try {
            String name = file.getName();
            int i = name.lastIndexOf(46);
            if (i > 0) {
                String modName = name.substring(0, i);
                if (!PythonPathHelper.isValidModuleLastPart((String)modName)) {
                    this.addInvalidModuleMarker(doc, file, "Invalid name for Python module: " + modName + " (it'll not be analyzed)");
                    return;
                }
                if (!PythonPathHelper.isValidSourceFile((String)name)) {
                    this.addInvalidModuleMarker(doc, file, "Module: " + modName + " does not have a valid Python extension (it'll not be analyzed).");
                    return;
                }
            }
            this.removeInvalidModuleMarkers(file);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void removeInvalidModuleMarkers(IFile file) {
        try {
            if (file.exists()) {
                file.deleteMarkers(INVALID_MODULE_MARKER_TYPE, true, 0);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void addInvalidModuleMarker(IDocument doc, IFile fileAdapter, String msg) {
        PyMarkerUtils.MarkerInfo markerInfo = new PyMarkerUtils.MarkerInfo(doc, msg, INVALID_MODULE_MARKER_TYPE, 1, false, true, 0, 0, 0, 0, null);
        ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
        lst.add(markerInfo);
        PyMarkerUtils.replaceMarkers(lst, (IResource)fileAdapter, (String)INVALID_MODULE_MARKER_TYPE, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateHoverBehavior() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetInput(IEditorInput input) throws CoreException {
        Object oldFile;
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && (oldFile = (IFile)oldInput.getAdapter(IFile.class)) != null) {
            this.removeInvalidModuleMarkers((IFile)oldFile);
        }
        oldFile = this.lockHandle;
        synchronized (oldFile) {
            this.releaseCurrentHandle();
        }
        super.doSetInput(input);
        try {
            IDocument document = this.getDocument(input);
            if (input != null) {
                IFile newFile = (IFile)input.getAdapter(IFile.class);
                if (newFile != null) {
                    this.checkAddInvalidModuleNameMarker(document, newFile);
                }
                this.fixEncoding(input, document);
                PyParserManager.getPyParserManager((IEclipsePreferences)PydevPrefs.getEclipsePreferences()).attachParserTo((IBaseEditor)this);
                if (document != null) {
                    PyPartitionScanner.checkPartitionScanner((IDocument)document, (IGrammarVersionProvider)this.getGrammarVersionProvider());
                }
            }
            this.notifier.notifyInputChanged(oldInput, input);
            this.notifier.notifyOnSetDocument(document);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            PyEditTitle.invalidateTitle(this, input);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.isCythonFile()) {
                this.setTitleImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/cython_file.png")));
                this.getAutoEditStrategy().setCythonFile(true);
            } else {
                this.getAutoEditStrategy().setCythonFile(false);
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    void setEditorTitle(String title) {
        this.setPartName(title);
        this.firePropertyChange(257);
    }

    void setEditorImage(Image image) {
        this.setTitleImage(image);
    }

    private IDocument getDocument(IEditorInput input) {
        return this.getDocumentProvider().getDocument((Object)input);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        boolean keepOn;
        IDocument document = this.getDocument();
        try {
            keepOn = true;
            if (PydevSaveActionsPrefPage.getAutoformatOnlyWorkspaceFiles((IAdaptable)this) && this.getIFile() == null) {
                keepOn = false;
            }
        }
        catch (Exception e1) {
            Log.log((Throwable)e1);
            keepOn = false;
        }
        try {
            if (keepOn) {
                this.executeSaveActions(document);
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            if (keepOn && PydevSaveActionsPrefPage.getFormatBeforeSaving(this) && !this.isCythonFile()) {
                PySelection ps;
                IStatusLineManager statusLineManager = this.getStatusLineManager();
                IDocumentProvider documentProvider = this.getDocumentProvider();
                int[] regionsForSave = null;
                if (PyFormatterPreferences.getFormatOnlyChangedLines((IAdaptable)this)) {
                    if (documentProvider instanceof PyDocumentProvider) {
                        PyDocumentProvider pyDocumentProvider = (PyDocumentProvider)documentProvider;
                        ITextFileBuffer fileBuffer = pyDocumentProvider.getFileBuffer(this.getEditorInput());
                        if (fileBuffer != null) {
                            regionsForSave = ChangedLinesComputer.calculateChangedLines(fileBuffer, (IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
                        }
                    } else {
                        Log.log((String)("Was expecting PyDocumentProvider. Found: " + documentProvider));
                    }
                }
                if (!(regionsForSave != null && regionsForSave.length <= 0 || this.hasSyntaxError((ps = new PySelection(document, this.getTextSelection())).getDoc()))) {
                    PyFormatAction std = new PyFormatAction();
                    boolean throwSyntaxError = true;
                    try {
                        std.applyFormatAction((IPyFormatStdProvider)this, ps, regionsForSave, throwSyntaxError, this.getSelectionProvider());
                        statusLineManager.setErrorMessage(null);
                    }
                    catch (SyntaxErrorException e) {
                        statusLineManager.setErrorMessage(e.getMessage());
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.fixEncoding(this.getEditorInput(), document);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        super.performSave(overwrite, progressMonitor);
    }

    private void executeSaveActions(IDocument document) throws BadLocationException {
        if (PydevSaveActionsPrefPage.getDateFieldActionEnabled(this)) {
            MatchResult matchResult;
            String contents = document.get();
            String fieldName = PydevSaveActionsPrefPage.getDateFieldName(this);
            String fieldPattern = String.format("^%s(\\s*)=(\\s*[ur]{0,2}['\"]{1,3})(.+?)(['\"]{1,3})", fieldName);
            Pattern pattern = Pattern.compile(fieldPattern, 8);
            Matcher matcher = pattern.matcher(contents);
            if (matcher.find() && (matchResult = matcher.toMatchResult()).groupCount() == 4) {
                String spBefore = matchResult.group(1);
                String spAfterQuoteBegin = matchResult.group(2);
                String dateStr = matchResult.group(3);
                String quoteEnd = matchResult.group(4);
                String dateFormat = PydevSaveActionsPrefPage.getDateFieldFormat(this);
                Date nowDate = new Date();
                SimpleDateFormat ft = new SimpleDateFormat(dateFormat);
                try {
                    Date fieldDate = ft.parse(dateStr);
                    if (fieldDate.before(nowDate)) {
                        String newDateStr = ft.format(nowDate);
                        String replacement = String.valueOf(fieldName) + spBefore + "=" + spAfterQuoteBegin + newDateStr + quoteEnd;
                        document.replace(matchResult.start(), matchResult.end() - matchResult.start(), replacement);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (PydevSaveActionsPrefPage.getSortImportsOnSave(this)) {
            boolean automatic = true;
            PyOrganizeImports organizeImports = new PyOrganizeImports(automatic);
            try {
                organizeImports.formatAll(this.getDocument(), (IPyFormatStdProvider)this, this.getIFile(), true, true);
            }
            catch (SyntaxErrorException e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected BaseParserManager getParserManager() {
        return PyParserManager.getPyParserManager(null);
    }

    public boolean hasSyntaxError(IDocument doc) throws MisconfigurationException {
        BaseParser.ParseOutput reparse = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, (IGrammarVersionProvider)this, false));
        if (reparse.error != null) {
            this.getStatusLineManager().setErrorMessage(reparse.error.getMessage());
            return true;
        }
        return false;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    private void fixEncoding(final IEditorInput input, IDocument document) {
        if (input instanceof FileEditorInput) {
            String fileEncoding;
            final IFile file = (IFile)((FileEditorInput)input).getAdapter(IFile.class);
            try {
                fileEncoding = FileUtils.getPythonFileEncoding((IDocument)document, (String)file.getFullPath().toOSString());
            }
            catch (UnsupportedEncodingException e) {
                fileEncoding = null;
            }
            if (fileEncoding == null) {
                return;
            }
            final String encoding = fileEncoding;
            try {
                if (!encoding.equals(file.getCharset())) {
                    new Job("Change encoding"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                file.setCharset(encoding, monitor);
                                ((TextFileDocumentProvider)PyEdit.this.getDocumentProvider()).setEncoding((Object)input, encoding);
                                file.refreshLocal(2, null);
                            }
                            catch (CoreException e) {
                                Log.log((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public File getEditorFile() {
        IEditorInput editorInput;
        File editorFile = super.getEditorFile();
        if (editorFile == null && (editorInput = this.getEditorInput()) instanceof PydevFileEditorInput) {
            PydevFileEditorInput pyEditorInput = (PydevFileEditorInput)editorInput;
            return pyEditorInput.getPath().toFile();
        }
        return editorFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lockHandle;
        synchronized (object) {
            this.releaseCurrentHandle();
        }
        if (!this.disposed) {
            this.disposed = true;
            OpenEditors.removeOpenedEditor((IPyEdit)this);
            this.outlinePage = null;
            this.codeFoldingSetter = null;
            try {
                IFile iFile = this.getIFile();
                if (iFile != null) {
                    this.removeInvalidModuleMarkers(iFile);
                }
            }
            catch (Throwable e1) {
                Log.log((Throwable)e1);
            }
            try {
                this.onDispose.call(null);
                this.notifier.notifyOnDispose();
                PyDevUiPrefs.getChainedPrefStore().removePropertyChangeListener(this.prefListener);
                PyParserManager.getPyParserManager(null).notifyEditorDisposed((IBaseEditor)this);
                this.colorCache.dispose();
                this.pyEditScripting = null;
                this.cache.clear();
                this.cache = null;
                if (this.resourceManager != null) {
                    this.resourceManager.dispose();
                    this.resourceManager = null;
                }
                Collection e1 = this.registeredEditListeners;
                synchronized (e1) {
                    this.registeredEditListeners.clear();
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        try {
            MyResources resources = new MyResources();
            Object action = new ContentAssistAction((ResourceBundle)resources, "ContentAssistProposal.", (ITextEditor)this);
            action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
            this.setAction("ContentAssistProposal", (IAction)action);
            this.markAsStateDependentAction("ContentAssistProposal", true);
            PyOpenAction openAction = new PyOpenAction();
            this.setAction(ACTION_OPEN, (IAction)openAction);
            action = new OfflineAction(resources, "Pyedit.ScriptEngine.", this);
            action.setActionDefinitionId("org.python.pydev.editor.actions.scriptEngine");
            action.setId("org.python.pydev.editor.actions.scriptEngine");
            this.setAction("PyDevScriptEngine", (IAction)action);
            if (this.getIndentPrefs().getSmartLineMove()) {
                action = new PyMoveLineUpAction(resources, "Pyedit.MoveLinesUp.", this);
                action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
                action.setId("org.python.pydev.editor.actions.moveLineUp");
                this.setAction("MoveLineUp", (IAction)action);
                action = new PyMoveLineDownAction(resources, "Pyedit.MoveLinesDown.", this);
                action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
                action.setId("org.python.pydev.editor.actions.moveLineDown");
                this.setAction("MoveLineDown", (IAction)action);
            }
            this.notifier.notifyOnCreateActions((ListResourceBundle)resources);
            this.onCreateActions.call((Object)this);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{PYDEV_EDITOR_KEYBINDINGS_CONTEXT_ID});
    }

    public PyParser getParser() {
        return (PyParser)PyParserManager.getPyParserManager(null).getParser((IBaseEditor)this);
    }

    public IStatusLineManager getStatusLineManager() {
        return EditorUtils.getStatusLineManager((ITextEditor)this);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (OfflineActionTarget.class.equals((Object)adapter)) {
            IStatusLineManager manager;
            if (this.fOfflineActionTarget == null && (manager = this.getStatusLineManager()) != null) {
                this.fOfflineActionTarget = this.getSourceViewer() == null ? null : new OfflineActionTarget((ITextViewer)this.getSourceViewer(), manager, this);
            }
            return this.fOfflineActionTarget;
        }
        if (IProject.class.equals((Object)adapter)) {
            return this.getProject();
        }
        if (ICodeScannerKeywords.class.equals((Object)adapter)) {
            return new PyEditBasedCodeScannerKeywords(this);
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.getOutlinePage();
        }
        Object adaptable = this.onGetAdapter.call((Object)adapter);
        if (adaptable != null) {
            return adaptable;
        }
        return super.getAdapter(adapter);
    }

    public IOutlineModel createOutlineModel() {
        return new ParsedModel((IBaseEditor)this);
    }

    private IContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new PyOutlinePage(this);
        }
        return this.outlinePage;
    }

    public void setSelection(int offset, int length) {
        super.setSelection(offset, length);
    }

    public void revealModelNodes(ISimpleNode[] nodes) {
        if (nodes == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            int startOffset = -1;
            int endOffset = -1;
            PySelection selection = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this);
            ISimpleNode[] iSimpleNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ISimpleNode inode = iSimpleNodeArray[n2];
                SimpleNode node = (SimpleNode)inode;
                int nodeStartoffset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
                int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
                int nodeEndOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
                if (startOffset == -1 || nodeStartoffset < startOffset) {
                    startOffset = nodeStartoffset;
                }
                if (endOffset == -1 || nodeEndOffset > endOffset) {
                    endOffset = nodeEndOffset;
                }
                ++n2;
            }
            this.setSelection(startOffset, endOffset - startOffset);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void revealModelNode(SimpleNode node) {
        if (node == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            PySelection selection = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this);
            int offset = selection.getLineOffset(node.beginLine - 1) + node.beginColumn - 1;
            int[] colLineEnd = NodeUtils.getColLineEnd((SimpleNode)node);
            int endOffset = selection.getLineOffset(colLineEnd[0] - 1) + colLineEnd[1] - 1;
            int length = endOffset - offset;
            this.setSelection(offset, length);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void releaseCurrentHandle() {
        if (this.handle != null) {
            ((IModulesManager)this.handle.o2).popTemporaryModule((String)this.handle.o3, ((Integer)this.handle.o1).intValue());
            this.handle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parserChanged(ChangedParserInfoForObservers info) {
        block5: {
            this.errorDescription = info.errorInfo != null ? PyParser.createParserErrorMarkers((Throwable)info.errorInfo.error, (IAdaptable)info.file, (IDocument)info.doc) : null;
            this.ast = (SimpleNode)info.root;
            this.astModificationTimeStamp = info.docModificationStamp;
            try {
                String moduleName;
                File editorFile;
                IModulesManager modulesManager;
                ICodeCompletionASTManager astManager;
                IPythonNature pythonNature = this.getPythonNature();
                if (pythonNature == null || (astManager = pythonNature.getAstManager()) == null || (modulesManager = astManager.getModulesManager()) == null || (editorFile = this.getEditorFile()) == null || (moduleName = pythonNature.resolveModule(editorFile)) == null) break block5;
                Object object = this.lockHandle;
                synchronized (object) {
                    this.releaseCurrentHandle();
                    int modHandle = modulesManager.pushTemporaryModule(moduleName, (IModule)new SourceModule(moduleName, editorFile, this.ast, null, pythonNature));
                    this.handle = new Tuple3((Object)modHandle, (Object)modulesManager, (Object)moduleName);
                }
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
            }
        }
        this.fireModelChanged((ISimpleNode)this.ast);
        this.invalidateTextPresentationAsync();
    }

    private void invalidateTextPresentationAsync() {
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!PyEdit.this.isDisposed()) {
                    PyEdit.this.getSourceViewer().invalidateTextPresentation();
                }
            }
        });
    }

    public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc, long docModificationStamp) {
        throw new AssertionError((Object)"Implementing IParserObserver3: this should not be called anymore");
    }

    public void parserError(Throwable error, IAdaptable original, IDocument doc) {
        throw new AssertionError((Object)"Implementing IParserObserver3: this should not be called anymore");
    }

    public void parserError(ErrorParserInfoForObservers info) {
        this.errorDescription = PyParser.createParserErrorMarkers((Throwable)info.error, (IAdaptable)info.file, (IDocument)info.doc);
        this.fireParseErrorChanged(this.errorDescription);
    }

    public SimpleNode getAST() {
        return this.ast;
    }

    public long getAstModificationTimeStamp() {
        return this.astModificationTimeStamp;
    }

    public List<String[]> getInnerStructureFromLine(int line) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        List parseToKnowGloballyAccessiblePath = FastParser.parseToKnowGloballyAccessiblePath((IDocument)this.getDocument(), (int)line);
        for (stmtType stmtType2 : parseToKnowGloballyAccessiblePath) {
            String rep = NodeUtils.getRepresentationString((SimpleNode)stmtType2);
            String image = stmtType2 instanceof ClassDef ? "icons/new/class_obj.gif" : (stmtType2 instanceof FunctionDef ? "icons/new/method_obj.gif" : "icons/showerr_tsk.gif");
            ret.add(new String[]{rep, image});
        }
        return ret;
    }

    public static void openWithPathAndInnerStructure(String projectName, IPath path, List<String> innerStructure) throws MisconfigurationException {
        IEditorPart editor;
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project != null && (file = project.getFile(path)) != null && (editor = PyOpenEditor.doOpenEditor(file)) instanceof PyEdit) {
            PyEdit pyEdit = (PyEdit)editor;
            IPythonNature nature = pyEdit.getPythonNature();
            SourceModule mod = AbstractModule.createModuleFromDoc((String)nature.resolveModule((IResource)file), (File)file.getLocation().toFile(), (IDocument)pyEdit.getDocument(), (IPythonNature)nature, (boolean)false);
            StringBuffer tok = new StringBuffer(80);
            for (String s : innerStructure) {
                if (tok.length() > 0) {
                    tok.append('.');
                }
                tok.append(s);
            }
            try {
                Definition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)tok.toString(), (IPythonNature)nature, (ICompletionCache)new CompletionCache()), -1, -1, nature);
                ArrayList pointers = new ArrayList();
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])definitions);
                if (pointers.size() > 0) {
                    new PyOpenAction().run((ItemPointer)pointers.get(0));
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public ErrorDescription getErrorDescription() {
        return this.errorDescription;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        if (this.isCythonFile()) {
            return 777;
        }
        IPythonNature nature = this.getPythonNature();
        if (nature != null) {
            return nature.getGrammarVersion();
        }
        File editorFile = this.getEditorFile();
        if (editorFile == null) {
            throw new MisconfigurationException();
        }
        Tuple infoForFile = InterpreterManagersAPI.getInfoForFile((File)editorFile);
        if (infoForFile == null || infoForFile.o1 == null) {
            throw new MisconfigurationException();
        }
        return ((IPythonNature)infoForFile.o1).getGrammarVersion();
    }

    public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
        IPythonNature pythonNature = this.getPythonNature();
        if (pythonNature != null) {
            return pythonNature.getAdditionalGrammarVersions();
        }
        return null;
    }

    public IGrammarVersionProvider getGrammarVersionProvider() {
        return new IGrammarVersionProvider(){

            public int getGrammarVersion() throws MisconfigurationException {
                return PyEdit.this.getGrammarVersion();
            }

            public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                return PyEdit.this.getAdditionalGrammarVersions();
            }
        };
    }

    public boolean isCythonFile() {
        IFile iFile = this.getIFile();
        String fileName = null;
        if (iFile != null) {
            fileName = iFile.getName();
        } else {
            File editorFile = this.getEditorFile();
            if (editorFile != null) {
                fileName = editorFile.getName();
            }
        }
        return FileTypesPreferences.isCythonFile((String)fileName);
    }

    public IPythonNature getPythonNature() throws MisconfigurationException {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
        if (pythonNature != null) {
            return pythonNature;
        }
        pythonNature = PyEdit.addNature(this.getEditorInput());
        if (pythonNature != null) {
            return pythonNature;
        }
        File editorFile = this.getEditorFile();
        if (editorFile == null) {
            return null;
        }
        Tuple infoForFile = InterpreterManagersAPI.getInfoForFile((File)editorFile);
        if (infoForFile == null) {
            NotConfiguredInterpreterException e = new NotConfiguredInterpreterException();
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error: no interpreter configured", (String)"Interpreter not configured\n(Please, Configure it under window->preferences->PyDev)", (IStatus)SharedCorePlugin.makeStatus((int)4, (String)e.getMessage(), (Throwable)e));
            throw e;
        }
        pythonNature = (IPythonNature)infoForFile.o1;
        return pythonNature;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        try {
            this.setPreferenceStore(PyDevUiPrefs.getChainedPrefStore());
            this.setEditorContextMenuId(PY_EDIT_CONTEXT);
            this.setRulerContextMenuId(PY_EDIT_RULER_CONTEXT);
            this.setDocumentProvider((IDocumentProvider)PyDocumentProvider.instance);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    public Collection<ActionInfo> getOfflineActionDescriptions() {
        return this.offlineActionsManager.getOfflineActionDescriptions();
    }

    public void addOfflineActionListener(String key, IAction action) {
        this.offlineActionsManager.addOfflineActionListener(key, action);
    }

    public void addOfflineActionListener(String key, Object action, String description, boolean needsEnter) {
        this.offlineActionsManager.addOfflineActionListener(key, (IAction)action, description, needsEnter);
    }

    public boolean activatesAutomaticallyOn(String key) {
        return this.offlineActionsManager.activatesAutomaticallyOn(key);
    }

    public boolean hasOfflineAction(String key) {
        return this.offlineActionsManager.hasOfflineAction(key);
    }

    public boolean onOfflineAction(String requestedStr, OfflineActionTarget target) {
        return this.offlineActionsManager.onOfflineAction(requestedStr, target);
    }

    public synchronized LocalResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public Font getFont(FontData descriptor) throws DeviceResourceException {
        Font font = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)descriptor));
        return font;
    }

    public static void checkValidateState(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditorExtension2) {
            ITextEditorExtension2 editor = (ITextEditorExtension2)iEditorPart;
            editor.validateEditorInputState();
        }
    }

    public FormatStd getFormatStd() {
        return PyFormatterPreferences.getFormatStd((IAdaptable)this);
    }

    public void setMessage(boolean error, String message) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        statusLine.setMessage(error, message, null);
    }

    public void showInformationDialog(String title, String message) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)title, (String)message);
    }

    public int getPrintMarginColums() {
        return PyDevUiPrefs.getChainedPrefStore().getInt("printMarginColumn");
    }

    public void asyncExec(Runnable runnable) {
        RunInUiThread.async((Runnable)runnable);
    }

    public Class<Action> getActionClass() {
        return Action.class;
    }

    public Class<IPyCompletionProposal> getIPyCompletionProposalClass() {
        return IPyCompletionProposal.class;
    }

    public Class<PyCompletionProposal> getPyCompletionProposalClass() {
        return PyCompletionProposal.class;
    }

    public Class<UIConstants> getUIConstantsClass() {
        return UIConstants.class;
    }

    public Class<ScriptConsole> getScriptConsoleClass() {
        return ScriptConsole.class;
    }

    public Class<Display> getDisplayClass() {
        return Display.class;
    }

    public Class<Runnable> getRunnableClass() {
        return Runnable.class;
    }

    public Class<PySelection> getPySelectionClass() {
        return PySelection.class;
    }

    public Class<UIJob> getUIJobClass() {
        return UIJob.class;
    }

    public Class<IDocumentListener> getIDocumentListenerClass() {
        return IDocumentListener.class;
    }

    public Class<PythonCorrectionProcessor> getPythonCorrectionProcessorClass() {
        return PythonCorrectionProcessor.class;
    }

    public Class<IExecuteLineAction> getIExecuteLineActionClass() {
        return IExecuteLineAction.class;
    }

    public IStatus getOkStatus() {
        return Status.OK_STATUS;
    }

    public String toString() {
        return "PyEdit[" + this.getEditorFile() + "]";
    }

    public ICharacterPairMatcher2 getPairMatcher() {
        return new PythonPairMatcher();
    }

    public IScopesParser createScopesParser() {
        return new ScopesParser();
    }

    public static IPythonNature addNature(IEditorInput element) {
        IFile file;
        if (element instanceof FileEditorInput && (file = (IFile)((FileEditorInput)element).getAdapter(IFile.class)) != null) {
            try {
                return PythonNature.addNature((IProject)file.getProject(), null, null, null, null, null, null);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        return null;
    }

    public static class MyResources
    extends ListResourceBundle {
        static final Object[][] contents = new Object[][]{{"CorrectionAssist", "CorrectionAssist"}, {"ContentAssistProposal", "ContentAssistProposal"}, {"TemplateProposals", "TemplateProposals"}};

        @Override
        public Object[][] getContents() {
            return contents;
        }
    }
}

