/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.Queue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.FStringsAST;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.SimpleNode;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammar;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammarFactory;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.ITokenScanner;
import org.python.pydev.shared_core.partitioner.SubRuleToken;
import org.python.pydev.shared_core.partitioner.Token;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyFStringScanner
implements ITokenScanner {
    private Token fStringReturnToken;
    private Token fStringExpressionReturnToken;
    protected final ColorAndStyleCache colorCache;
    private final Queue<SubRuleToken> cachedSubTokens = new LinkedListWarningOnSlowOperations();
    private SubRuleToken curr = null;
    private int fOffset;
    private int fLen;

    public PyFStringScanner(ColorAndStyleCache colorCache) {
        this.colorCache = colorCache;
        this.updateColorAndStyle();
    }

    public void updateColorAndStyle() {
        this.fStringReturnToken = new Token((Object)this.colorCache.getUnicodeTextAttribute());
        this.fStringExpressionReturnToken = new Token((Object)this.colorCache.getStringTextAttribute());
    }

    public void setRange(IDocument document, int offset, int length) {
        String str;
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        this.checkRange(offset, length, documentLength);
        this.cachedSubTokens.clear();
        this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringReturnToken, offset, length));
        try {
            str = document.get(offset, length);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        FStringInfo fstringInfo = PyFStringScanner.extractFStringInfo(str);
        if (fstringInfo == null) {
            return;
        }
        String buf = fstringInfo.buf;
        int startInternalStrOffset = fstringInfo.startInternalStrOffset;
        int endInternalStrOffet = fstringInfo.endInternalStrOffet;
        if (buf.length() < 0) {
            return;
        }
        FStringsGrammar fStringsGrammar = FStringsGrammarFactory.createGrammar((String)buf);
        FStringsAST ast = null;
        try {
            ast = fStringsGrammar.f_string();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ast != null && ast.hasChildren()) {
            this.cachedSubTokens.clear();
            Document doc = new Document(buf.toString());
            int currOffset = 0;
            if (startInternalStrOffset != 0) {
                this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringReturnToken, offset, startInternalStrOffset));
            }
            Iterable fStringExpressions = ast.getFStringExpressions();
            for (SimpleNode node : fStringExpressions) {
                if (node.endLine <= node.beginLine && (node.endLine != node.beginLine || node.endColumn <= node.beginColumn)) continue;
                int startRelOffset = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(node.beginLine - 1), (int)(node.beginColumn - 1));
                int endRelOffset = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(node.endLine - 1), (int)node.endColumn);
                if (currOffset != startRelOffset) {
                    this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringReturnToken, offset + startInternalStrOffset + currOffset, startRelOffset - currOffset));
                }
                this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringExpressionReturnToken, offset + startInternalStrOffset + startRelOffset, endRelOffset - startRelOffset));
                currOffset = endRelOffset;
            }
            if (currOffset != doc.getLength()) {
                this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringReturnToken, offset + startInternalStrOffset + currOffset, doc.getLength() - currOffset));
            }
            if (endInternalStrOffet != 0) {
                this.cachedSubTokens.add(new SubRuleToken((IToken)this.fStringReturnToken, offset + startInternalStrOffset + doc.getLength(), endInternalStrOffet));
            }
        }
    }

    public static FStringInfo extractFStringInfo(String str) {
        ParsingUtils pu = ParsingUtils.create((Object)str);
        int len = pu.len();
        int startInternalStrOffset = 0;
        int endInternalStrOffet = 0;
        String buf = "";
        while (startInternalStrOffset < len) {
            char c = pu.charAt(startInternalStrOffset);
            if (c == '\'' || c == '\"') {
                if (startInternalStrOffset > 2) {
                    return null;
                }
                try {
                    int endPos = pu.getLiteralEnd(startInternalStrOffset, c);
                    boolean isMulti = pu.isMultiLiteral(startInternalStrOffset, c);
                    if (isMulti) {
                        boolean reachedEndBecauseOfEndOfString;
                        boolean bl = reachedEndBecauseOfEndOfString = endPos <= (startInternalStrOffset += 3);
                        if (!reachedEndBecauseOfEndOfString) {
                            int i = endPos - 2;
                            while (i < endPos) {
                                if (pu.charAt(i) != c) {
                                    reachedEndBecauseOfEndOfString = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (reachedEndBecauseOfEndOfString) {
                            buf = str.substring(startInternalStrOffset, endPos);
                            endInternalStrOffet = 0;
                            break;
                        }
                        buf = str.substring(startInternalStrOffset, endPos - 2);
                        endInternalStrOffet = 3;
                        break;
                    }
                    boolean reachedEndBecauseOfEndOfString = endPos <= ++startInternalStrOffset || endPos >= pu.len();
                    buf = str.substring(startInternalStrOffset, endPos);
                    if (reachedEndBecauseOfEndOfString) {
                        endInternalStrOffet = 0;
                        break;
                    }
                    endInternalStrOffet = 1;
                    break;
                }
                catch (SyntaxErrorException e) {
                    return null;
                }
            }
            ++startInternalStrOffset;
        }
        return new FStringInfo(startInternalStrOffset, endInternalStrOffet, buf);
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public int getTokenLength() {
        return this.fLen;
    }

    public IToken nextToken() {
        this.curr = this.cachedSubTokens.poll();
        if (this.curr != null) {
            this.fOffset = this.curr.offset;
            this.fLen = this.curr.len;
            return this.curr.token;
        }
        this.fOffset += this.fLen;
        this.fLen = 0;
        return Token.EOF;
    }

    public static class FStringInfo {
        public final int startInternalStrOffset;
        public final int endInternalStrOffet;
        public final String buf;

        public FStringInfo(int startInternalStrOffset, int endInternalStrOffet, String buf) {
            this.startInternalStrOffset = startInternalStrOffset;
            this.endInternalStrOffet = endInternalStrOffet;
            this.buf = buf;
        }
    }
}

