/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.parser.PyParser;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.structure.Tuple;

class OrganizeImportsFixesUnused {
    OrganizeImportsFixesUnused() {
    }

    public boolean beforePerformArrangeImports(PySelection ps, PyEdit edit, IFile f) {
        int oldSelection = ps.getRegion().getOffset();
        IDocumentExtension4 doc = (IDocumentExtension4)ps.getDoc();
        if (edit != null) {
            if (!this.ensureParsed(edit)) {
                return true;
            }
            long docTime = doc.getModificationStamp();
            if (docTime != edit.getAstModificationTimeStamp()) {
                return true;
            }
            ErrorDescription errorDescription = edit.getErrorDescription();
            if (errorDescription != null) {
                return true;
            }
        }
        try {
            this.findAndDeleteUnusedImports(ps, edit, doc, f);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        ps.setSelection(oldSelection, oldSelection);
        return true;
    }

    private void findAndDeleteUnusedImports(PySelection ps, PyEdit edit, IDocumentExtension4 doc, IFile f) throws Exception {
        Iterator<MarkerAnnotationAndPosition> it;
        if (edit != null) {
            it = edit.getPySourceViewer().getMarkerIterator();
        } else {
            IMarker[] markers = f.findMarkers("com.python.pydev.analysis.pydev_analysis_problemmarker", true, 0);
            MarkerAnnotationAndPosition[] maap = new MarkerAnnotationAndPosition[markers.length];
            int ix = 0;
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                int start = (Integer)m.getAttribute("charStart");
                int end = (Integer)m.getAttribute("charEnd");
                maap[ix++] = new MarkerAnnotationAndPosition((SimpleMarkerAnnotation)new MarkerAnnotation(m), new Position(start, end - start));
                ++n2;
            }
            it = Arrays.asList(maap).iterator();
        }
        ArrayList<MarkerAnnotationAndPosition> unusedImportsMarkers = this.getUnusedImports(it);
        this.sortInReverseDocumentOrder(unusedImportsMarkers);
        this.deleteImports(doc, ps, unusedImportsMarkers);
    }

    private ArrayList<MarkerAnnotationAndPosition> getUnusedImports(Iterator<MarkerAnnotationAndPosition> it) throws CoreException {
        ArrayList<MarkerAnnotationAndPosition> unusedImportsMarkers = new ArrayList<MarkerAnnotationAndPosition>();
        while (it.hasNext()) {
            Integer attribute;
            MarkerAnnotationAndPosition marker = it.next();
            String type = marker.markerAnnotation.getMarker().getType();
            if (type == null || !type.equals("com.python.pydev.analysis.pydev_analysis_problemmarker") || (attribute = Integer.valueOf(marker.markerAnnotation.getMarker().getAttribute("PYDEV_TYPE", -1))) == null || !attribute.equals(1)) continue;
            unusedImportsMarkers.add(marker);
        }
        return unusedImportsMarkers;
    }

    private void sortInReverseDocumentOrder(ArrayList<MarkerAnnotationAndPosition> unusedImportsMarkers) {
        Collections.sort(unusedImportsMarkers, new Comparator<MarkerAnnotationAndPosition>(){

            @Override
            public int compare(MarkerAnnotationAndPosition arg0, MarkerAnnotationAndPosition arg1) {
                try {
                    return this.getCharStart(arg1) - this.getCharStart(arg0);
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                    return 0;
                }
            }

            private int getCharStart(MarkerAnnotationAndPosition arg0) throws CoreException {
                IMarker marker = arg0.markerAnnotation.getMarker();
                int i = (Integer)marker.getAttribute("charStart");
                return i;
            }
        });
    }

    private void deleteImports(IDocumentExtension4 doc, PySelection ps, Iterable<MarkerAnnotationAndPosition> markers) throws BadLocationException, CoreException {
        for (MarkerAnnotationAndPosition m : markers) {
            this.deleteImport(ps, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureParsed(PyEdit edit) {
        final PyParser parser = edit.getParser();
        final boolean[] notified = new boolean[1];
        final Object sentinel = new Object();
        parser.addPostParseListener(new PyParser.IPostParserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void participantsNotified(Object ... argsToReparse) {
                OrganizeImportsFixesUnused organizeImportsFixesUnused = OrganizeImportsFixesUnused.this;
                synchronized (organizeImportsFixesUnused) {
                    parser.removePostParseListener((PyParser.IPostParserListener)this);
                    if (argsToReparse.length == 2 && argsToReparse[1] == sentinel) {
                        notified[0] = true;
                        OrganizeImportsFixesUnused.this.notify();
                    }
                }
            }
        });
        long initial = System.currentTimeMillis();
        while (System.currentTimeMillis() - initial < 5000L) {
            OrganizeImportsFixesUnused organizeImportsFixesUnused;
            if (parser.forceReparse(new Object[]{new Tuple((Object)"AnalysisParserObserver:force:inThisThread", (Object)true), sentinel})) {
                organizeImportsFixesUnused = this;
                synchronized (organizeImportsFixesUnused) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    break;
                }
            }
            organizeImportsFixesUnused = this;
            synchronized (organizeImportsFixesUnused) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private void deleteImport(PySelection ps, MarkerAnnotationAndPosition markerInfo) throws BadLocationException, CoreException {
        IMarker marker = markerInfo.markerAnnotation.getMarker();
        Integer start = (Integer)marker.getAttribute("charStart");
        Integer end = (Integer)marker.getAttribute("charEnd");
        IDocument doc = ps.getDoc();
        while (start > 0) {
            char c;
            try {
                c = doc.getChar(start - 1);
            }
            catch (Exception e) {
                break;
            }
            if (c == '\r' || c == '\n' || !Character.isWhitespace(c) && c != ',') break;
            start = start - 1;
        }
        ps.setSelection(start.intValue(), end.intValue());
        ps.deleteSelection();
    }
}

