/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.OrganizeImportsFixesUnused;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.organize_imports.ImportArranger;
import org.python.pydev.editor.actions.organize_imports.Pep8ImportArranger;
import org.python.pydev.jython.JythonModules;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.utils.DocUtils;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

public class PyOrganizeImports
extends PyAction
implements IFormatter {
    private final boolean automatic;

    public PyOrganizeImports() {
        this.automatic = false;
    }

    public PyOrganizeImports(boolean automatic) {
        this.automatic = automatic;
    }

    public void run(IAction action) {
        block7: {
            try {
                if (!this.canModifyEditor()) {
                    return;
                }
                PyEdit pyEdit = this.getPyEdit();
                PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)pyEdit);
                IDocument doc = ps.getDoc();
                if (ps.getStartLineIndex() == ps.getEndLineIndex()) {
                    this.organizeImports(pyEdit, doc, null, ps);
                    break block7;
                }
                DocumentRewriteSession session = TextSelectionUtils.startWrite((IDocument)doc);
                try {
                    ps.performSimpleSort(doc, ps.getStartLineIndex(), ps.getEndLineIndex());
                }
                finally {
                    TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                PyOrganizeImports.beep((Exception)e);
            }
        }
    }

    private void organizeImports(PyEdit edit, IDocument doc, IFile f, PySelection ps) throws MisconfigurationException, PythonNatureWithoutProjectException {
        String fileContents;
        DocumentRewriteSession session = null;
        String endLineDelim = ps.getEndLineDelim();
        List participants = null;
        if (f == null && !this.automatic) {
            participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
            for (IOrganizeImports organizeImports : participants) {
                if (organizeImports.beforePerformArrangeImports(ps, edit, f)) continue;
                return;
            }
        }
        if ((fileContents = doc.get()).contains("isort:skip_file") || fileContents.length() == 0) {
            return;
        }
        PyEdit projectAdaptable = edit != null ? edit : f;
        String indentStr = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get((IAdaptable)f).getIndentationString();
        session = TextSelectionUtils.startWrite((IDocument)doc);
        try {
            IPythonNature pythonNature;
            boolean removeUnusedImports = false;
            if (!this.automatic && (removeUnusedImports = ImportsPreferencesPage.getDeleteUnusedImports((IAdaptable)projectAdaptable))) {
                new OrganizeImportsFixesUnused().beforePerformArrangeImports(ps, edit, f);
            }
            HashSet<String> knownThirdParty = new HashSet<String>();
            String importEngine = ImportsPreferencesPage.getImportEngine((IAdaptable)projectAdaptable);
            if (edit != null && (pythonNature = edit.getPythonNature()) != null) {
                String name;
                int i;
                ModulesKey modulesKey;
                IInterpreterInfo projectInterpreter = pythonNature.getProjectInterpreter();
                ISystemModulesManager modulesManager = projectInterpreter.getModulesManager();
                ModulesKey[] onlyDirectModules = modulesManager.getOnlyDirectModules();
                HashSet<String> stdLib = new HashSet<String>();
                ModulesKey[] modulesKeyArray = onlyDirectModules;
                int n = onlyDirectModules.length;
                int n2 = 0;
                while (n2 < n) {
                    modulesKey = modulesKeyArray[n2];
                    if (modulesKey.file == null) {
                        i = modulesKey.name.indexOf(46);
                        name = i < 0 ? modulesKey.name : modulesKey.name.substring(0, i);
                        stdLib.add(name);
                    }
                    ++n2;
                }
                modulesKeyArray = onlyDirectModules;
                n = onlyDirectModules.length;
                n2 = 0;
                while (n2 < n) {
                    modulesKey = modulesKeyArray[n2];
                    i = modulesKey.name.indexOf(46);
                    name = i < 0 ? modulesKey.name : modulesKey.name.substring(0, i);
                    if (modulesKey.file != null && modulesKey.file.toString().contains("site-packages")) {
                        stdLib.remove(name);
                        knownThirdParty.add(name);
                    }
                    ++n2;
                }
            }
            switch (importEngine) {
                case "IMPORT_ENGINE_ISORT": {
                    String isortResult;
                    IPath location;
                    File targetFile;
                    if (fileContents.length() <= 0) break;
                    File file = targetFile = edit != null ? edit.getEditorFile() : null;
                    if (targetFile == null && f != null && (location = f.getLocation()) != null) {
                        targetFile = location.toFile();
                    }
                    if ((isortResult = JythonModules.makeISort((String)fileContents, (File)targetFile, knownThirdParty)) == null) break;
                    try {
                        DocUtils.updateDocRangeWithContents((IDocument)doc, (String)fileContents, (String)isortResult.toString());
                    }
                    catch (Exception e) {
                        Log.log((String)StringUtils.format((String)"Error trying to apply isort result. Curr doc:\n>>>%s\n<<<.\nNew doc:\\n>>>%s\\n<<<.", (Object[])new Object[]{fileContents, isortResult.toString()}), (Throwable)e);
                    }
                    break;
                }
                case "IMPORT_ENGINE_REGULAR_SORT": {
                    PyOrganizeImports.performArrangeImports(doc, removeUnusedImports, endLineDelim, indentStr, this.automatic, (IPyFormatStdProvider)edit);
                    break;
                }
                default: {
                    if (f == null) {
                        f = edit.getIFile();
                    }
                    IProject p = f != null ? f.getProject() : null;
                    PyOrganizeImports.pep8PerformArrangeImports(doc, removeUnusedImports, endLineDelim, p, indentStr, this.automatic, (IPyFormatStdProvider)edit);
                }
            }
            if (participants != null) {
                for (IOrganizeImports organizeImports : participants) {
                    organizeImports.afterPerformArrangeImports(ps, edit);
                }
            }
        }
        finally {
            TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
        }
    }

    public static void performArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new ImportArranger(doc, removeUnusedImports, endLineDelim, indentStr, automatic, edit).perform();
    }

    public static void pep8PerformArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, IProject prj, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        new Pep8ImportArranger(doc, removeUnusedImports, endLineDelim, prj, indentStr, automatic, edit).perform();
    }

    public static void performArrangeImports(Document doc, String endLineDelim, String indentStr, IPyFormatStdProvider edit) {
        PyOrganizeImports.performArrangeImports((IDocument)doc, false, endLineDelim, indentStr, false, edit);
    }

    public static void performPep8ArrangeImports(Document doc, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        IProject project = null;
        PyOrganizeImports.pep8PerformArrangeImports((IDocument)doc, false, endLineDelim, project, indentStr, automatic, edit);
    }

    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        try {
            this.organizeImports((PyEdit)edit, doc, f, new PySelection(doc));
        }
        catch (MisconfigurationException | PythonNatureWithoutProjectException e) {
            Log.log((Throwable)e);
        }
    }

    public void formatSelection(IDocument doc, int[] regionsToFormat, IPyFormatStdProvider edit, PySelection ps) {
        throw new UnsupportedOperationException();
    }
}

