/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.autoedit.PyAutoIndentStrategy;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;
import org.python.pydev.shared_core.utils.IDocumentCommand;
import org.python.pydev.shared_ui.editor.ITextViewerExtensionAutoEditions;

public class PyPeerLinker {
    private IIndentPrefs prefs;
    private int linkOffset;
    private int linkExitPos;
    private int linkLen;

    public void setIndentPrefs(IIndentPrefs prefs) {
        this.prefs = prefs;
    }

    public static VerifyKeyListener createVerifyKeyListener(final TextViewer viewer) {
        return new VerifyKeyListener(){
            private final PyPeerLinker pyPeerLinker = new PyPeerLinker();

            public void verifyKey(VerifyEvent event) {
                if (!event.doit) {
                    return;
                }
                switch (event.character) {
                    case '\"': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (viewer != null && viewer.isEditable()) {
                    boolean blockSelection = false;
                    try {
                        blockSelection = viewer.getTextWidget().getBlockSelection();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!blockSelection) {
                        ITextViewerExtensionAutoEditions autoEditions;
                        if (viewer instanceof ITextViewerExtensionAutoEditions && !(autoEditions = (ITextViewerExtensionAutoEditions)viewer).getAutoEditionsEnabled()) {
                            return;
                        }
                        ISelection selection = viewer.getSelection();
                        if (selection instanceof ITextSelection) {
                            IAdaptable adaptable = viewer instanceof IAdaptable ? (IAdaptable)viewer : new IAdaptable(){

                                public <T> T getAdapter(Class<T> adapter) {
                                    return null;
                                }
                            };
                            this.pyPeerLinker.setIndentPrefs((IIndentPrefs)new DefaultIndentPrefs(adaptable));
                            ITextSelection textSelection = (ITextSelection)selection;
                            PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextViewer)viewer, textSelection);
                            if (this.pyPeerLinker.perform(ps, event.character, viewer)) {
                                event.doit = false;
                            }
                        }
                    }
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean perform(PySelection ps, char c, TextViewer viewer) {
        this.linkOffset = -1;
        this.linkExitPos = -1;
        this.linkLen = 0;
        boolean literal = true;
        boolean open = true;
        switch (c) {
            case '\"': 
            case '\'': {
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                open = false;
            }
            case '(': 
            case '[': 
            case '{': {
                literal = false;
                break;
            }
            default: {
                return false;
            }
        }
        if (literal ? !this.prefs.getAutoLiterals() : !this.prefs.getAutoParentesis()) {
            return false;
        }
        try {
            IDocument doc = ps.getDoc();
            String contentType = ParsingUtils.getContentType((IDocument)ps.getDoc(), (int)ps.getAbsoluteCursorOffset());
            boolean isDefaultContext = contentType.equals("__dftl_partition_content_type");
            if (!isDefaultContext) {
                return false;
            }
            DocCmd docCmd = new DocCmd(ps.getAbsoluteCursorOffset(), ps.getSelLength(), "" + c);
            if (literal ? !this.handleLiteral(doc, (IDocumentCommand)docCmd, ps, isDefaultContext, this.prefs) : !this.handleBrackets(ps, c, doc, docCmd, viewer, open)) {
                return false;
            }
            if (this.linkOffset == -1) return true;
            if (this.linkExitPos == -1) {
                return true;
            }
            if (open && this.prefs.getAutoLink()) {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(doc, this.linkOffset, this.linkLen, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                if (viewer == null) {
                    return true;
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, (ITextViewer)viewer);
                ui.setSimpleMode(true);
                LinkedModeUI.IExitPolicy policy = new LinkedModeUI.IExitPolicy(){

                    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
                        return null;
                    }
                };
                ui.setExitPolicy(policy);
                ui.setExitPosition((ITextViewer)viewer, this.linkExitPos, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
                IRegion newSelection = ui.getSelectedRegion();
                viewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                return true;
            }
            viewer.setSelectedRange(this.linkOffset, this.linkLen);
            return true;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return true;
    }

    private boolean handleBrackets(PySelection ps, char c, IDocument doc, DocCmd docCmd, TextViewer viewer, boolean open) throws BadLocationException {
        if (!open) {
            PyAutoIndentStrategy strategy = new PyAutoIndentStrategy(null);
            strategy.setIndentPrefs(this.prefs);
            if (strategy.canSkipCloseParenthesis(doc, (IDocumentCommand)docCmd) && viewer != null) {
                viewer.setSelectedRange(docCmd.offset + 1, 0);
                return true;
            }
            return false;
        }
        if (c == '(') {
            PyAutoIndentStrategy.handleParens((IDocument)doc, (IDocumentCommand)docCmd, (IIndentPrefs)this.prefs, (boolean)false);
            docCmd.doExecute(doc);
            if (docCmd.shiftsCaret) {
                if (viewer != null) {
                    viewer.setSelectedRange(docCmd.offset + docCmd.text.length(), 0);
                }
            } else {
                this.linkOffset = docCmd.caretOffset;
                this.linkLen = 0;
                this.linkExitPos = docCmd.offset + docCmd.text.length();
            }
        } else {
            char peer = StringUtils.getPeer((char)c);
            if (PyAutoIndentStrategy.shouldClose((PySelection)ps, (char)c, (char)peer)) {
                int offset = ps.getAbsoluteCursorOffset();
                doc.replace(offset, ps.getSelLength(), StringUtils.getWithClosedPeer((char)c));
                this.linkOffset = offset + 1;
                this.linkLen = 0;
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
            } else {
                docCmd.doExecute(doc);
                if (viewer != null) {
                    viewer.setSelectedRange(docCmd.offset + docCmd.text.length(), 0);
                }
            }
        }
        return true;
    }

    private boolean handleLiteral(IDocument document, IDocumentCommand command, PySelection ps, boolean isDefaultContext, IIndentPrefs prefs) throws BadLocationException {
        boolean hasMatchesAfter;
        String cursorLineContents;
        int offset = ps.getAbsoluteCursorOffset();
        if (command.getLength() > 0) {
            String selectedText = ps.getSelectedText();
            if (selectedText.indexOf(13) != -1 || selectedText.indexOf(10) != -1) {
                FastStringBuffer buf = new FastStringBuffer(selectedText.length() + 10);
                buf.appendN(command.getText(), 3);
                buf.append(selectedText);
                buf.appendN(command.getText(), 3);
                document.replace(offset, ps.getSelLength(), buf.toString());
                this.linkOffset = offset + 3;
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + 3;
            } else {
                document.replace(offset, ps.getSelLength(), String.valueOf(command.getText()) + selectedText + command.getText());
                this.linkOffset = offset + 1;
                this.linkLen = selectedText.length();
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
            }
            return true;
        }
        char literalChar = command.getText().charAt(0);
        try {
            char nextChar = ps.getCharAfterCurrentOffset();
            if (Character.isJavaIdentifierPart(nextChar)) {
                return false;
            }
        }
        catch (BadLocationException nextChar) {
            // empty catch block
        }
        if ((cursorLineContents = ps.getCursorLineContents()).indexOf(literalChar) == -1) {
            if (!isDefaultContext) {
                return false;
            }
            document.replace(offset, ps.getSelLength(), String.valueOf(command.getText()) + command.getText());
            this.linkOffset = offset + 1;
            this.linkLen = 0;
            this.linkExitPos = this.linkOffset + this.linkLen + 1;
            return true;
        }
        boolean balanced = this.isLiteralBalanced(cursorLineContents);
        Tuple beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(literalChar);
        int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
        int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
        boolean hasMatchesBefore = matchesBefore != 0;
        boolean bl = hasMatchesAfter = matchesAfter != 0;
        if (!hasMatchesBefore && !hasMatchesAfter) {
            if (balanced) {
                if (!isDefaultContext) {
                    return false;
                }
                document.replace(offset, ps.getSelLength(), String.valueOf(command.getText()) + command.getText());
                this.linkOffset = offset + 1;
                this.linkLen = 0;
                this.linkExitPos = this.linkOffset + this.linkLen + 1;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private boolean isLiteralBalanced(String cursorLineContents) {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)cursorLineContents, (boolean)true);
        int offset = 0;
        int end = cursorLineContents.length();
        boolean balanced = true;
        while (offset < end) {
            int eaten;
            char curr;
            if ((curr = cursorLineContents.charAt(offset++)) != '\"' && curr != '\'') continue;
            try {
                eaten = parsingUtils.eatLiterals(null, offset - 1) + 1;
            }
            catch (SyntaxErrorException e) {
                balanced = false;
                break;
            }
            if (eaten <= offset) continue;
            offset = eaten;
        }
        return balanced;
    }

    int getLinkLen() {
        return this.linkLen;
    }

    int getLinkExitPos() {
        return this.linkExitPos;
    }

    int getLinkOffset() {
        return this.linkOffset;
    }
}

