/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.utils.AsynchronousProgressMonitorDialog;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterPreferencesPage;

public class PySelectInterpreter
extends PyAction {
    public void run(IAction action) {
        try {
            PyEdit editor = this.getPyEdit();
            IPythonNature nature = editor.getPythonNature();
            if (nature != null) {
                IInterpreterManager interpreterManager = nature.getRelatedInterpreterManager();
                IInterpreterInfo[] interpreterInfos = interpreterManager.getInterpreterInfos();
                if (interpreterInfos == null || interpreterInfos.length == 0) {
                    PyDialogHelpers.openWarning("No interpreters available", "Unable to change default interpreter because no interpreters are available (add more interpreters in the related preferences page).");
                    return;
                }
                if (interpreterInfos.length == 1) {
                    PyDialogHelpers.openWarning("Only 1 interpreters available", "Unable to change default interpreter because only 1 interpreter is configured (add more interpreters in the related preferences page).");
                    return;
                }
                IWorkbenchWindow workbenchWindow = EditorUtils.getActiveWorkbenchWindow();
                Assert.isNotNull((Object)workbenchWindow);
                SelectionDialog listDialog = AbstractInterpreterPreferencesPage.createChooseIntepreterInfoDialog(workbenchWindow, interpreterInfos, "Select interpreter to be made the default.", false);
                int open = listDialog.open();
                if (open != 0 || listDialog.getResult().length != 1) {
                    return;
                }
                Object[] result = listDialog.getResult();
                if (result == null || result.length == 0) {
                    return;
                }
                IInterpreterInfo selectedInterpreter = (IInterpreterInfo)result[0];
                if (selectedInterpreter != interpreterInfos[0]) {
                    Arrays.sort(interpreterInfos, (a, b) -> {
                        if (a == selectedInterpreter) {
                            return -1;
                        }
                        if (b == selectedInterpreter) {
                            return 1;
                        }
                        return 0;
                    });
                    Shell shell = EditorUtils.getShell();
                    this.setInterpreterInfosWithProgressDialog(interpreterManager, interpreterInfos, shell);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void setInterpreterInfosWithProgressDialog(final IInterpreterManager interpreterManager, final IInterpreterInfo[] interpreterInfos, Shell shell) {
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(shell);
        monitorDialog.setBlockOnOpen(false);
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Restoring PYTHONPATH", -1);
                    try {
                        HashSet interpreterNamesToRestore = new HashSet();
                        interpreterManager.setInfos(interpreterInfos, interpreterNamesToRestore, monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            monitorDialog.run(true, true, operation);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

