/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions.organize_imports;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.organize_imports.ImportArranger;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

public class Pep8ImportArranger
extends ImportArranger {
    final ImportClassifier classifier;
    private int classification = -1;
    private boolean foundDocComment = false;

    static String getModuleName(ImportHandle imp) {
        String module = ((ImportHandle.ImportHandleInfo)imp.getImportInfo().get(0)).getFromImportStr();
        if (module == null) {
            module = (String)((ImportHandle.ImportHandleInfo)imp.getImportInfo().get(0)).getImportedStr().get(0);
        }
        return module;
    }

    static int getImportType(ImportHandle imp) {
        String module = ((ImportHandle.ImportHandleInfo)imp.getImportInfo().get(0)).getFromImportStr();
        if (module != null) {
            return 2;
        }
        return 1;
    }

    public Pep8ImportArranger(IDocument doc, boolean removeUnusedImports, String endLineDelim, IProject prj, String indentStr, boolean automatic, IPyFormatStdProvider edit) {
        super(doc, removeUnusedImports, endLineDelim, indentStr, automatic, edit);
        this.classifier = this.getClassifier(prj);
    }

    private ImportClassifier getClassifier(IProject p) {
        if (p != null) {
            try {
                return new PathImportClassifier(p);
            }
            catch (MisconfigurationException misconfigurationException) {
            }
            catch (PythonNatureWithoutProjectException pythonNatureWithoutProjectException) {
                // empty catch block
            }
        }
        return new DummyImportClassifier();
    }

    @Override
    public void perform() {
        this.perform(false, this.edit);
    }

    @Override
    protected void sortImports(List<Tuple3<Integer, String, ImportHandle>> list) {
        Collections.sort(list, new Comparator<Tuple3<Integer, String, ImportHandle>>(){

            @Override
            public int compare(Tuple3<Integer, String, ImportHandle> o1, Tuple3<Integer, String, ImportHandle> o2) {
                int type2;
                int type1;
                int class2;
                int class1 = Pep8ImportArranger.this.classifier.classify((ImportHandle)o1.o3);
                if (class1 != (class2 = Pep8ImportArranger.this.classifier.classify((ImportHandle)o2.o3))) {
                    return class1 - class2;
                }
                if (ImportsPreferencesPage.getSortFromImportsFirst((IAdaptable)Pep8ImportArranger.this.edit) && (type1 = Pep8ImportArranger.getImportType((ImportHandle)o1.o3)) != (type2 = Pep8ImportArranger.getImportType((ImportHandle)o2.o3))) {
                    return type2 - type1;
                }
                int rslt = Pep8ImportArranger.getModuleName((ImportHandle)o1.o3).compareTo(Pep8ImportArranger.getModuleName((ImportHandle)o2.o3));
                if (rslt != 0) {
                    return rslt;
                }
                return ((String)o1.o2).compareTo((String)o2.o2);
            }
        });
    }

    @Override
    protected void writeImports(List<Tuple3<Integer, String, ImportHandle>> list, FastStringBuffer all) {
        super.writeImports(list, all);
        if (all.startsWith(this.endLineDelim)) {
            int i = this.endLineDelim.length();
            while (i > 0) {
                all.deleteFirst();
                --i;
            }
        }
    }

    @Override
    protected void beforeImport(Tuple3<Integer, String, ImportHandle> element, FastStringBuffer all) {
        int c = this.classifier.classify((ImportHandle)element.o3);
        if (c != this.classification) {
            all.append(this.endLineDelim);
            this.classification = c;
        }
    }

    @Override
    protected void beforeImports(FastStringBuffer all) {
        if (this.foundDocComment) {
            all.append(this.endLineDelim);
        }
    }

    @Override
    protected void afterImports(FastStringBuffer all) {
        all.append(this.endLineDelim);
        all.append(this.endLineDelim);
    }

    @Override
    protected int insertImportsHere(int lineOfFirstOldImport) {
        return this.skipOverDocComment(lineOfFirstOldImport) - 1;
    }

    private SkipLineType findLineType(String line, SkipLineType state) {
        SkipLineType[] skipLineTypeArray = SkipLineType.values();
        int n = skipLineTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkipLineType slt = skipLineTypeArray[n2];
            if (slt.matches(line, state)) {
                return slt;
            }
            ++n2;
        }
        throw new IllegalStateException("No match");
    }

    private int skipOverDocComment(int firstOldImportLine) {
        try {
            SkipLineType parseState = SkipLineType.DummyHaventFoundStartDocComment;
            int l = firstOldImportLine;
            while (true) {
                IRegion lineInfo = this.doc.getLineInformation(l);
                String line = this.doc.get(lineInfo.getOffset(), lineInfo.getLength());
                SkipLineType slt = this.findLineType(line, parseState);
                switch (slt) {
                    case MidDocComment: 
                    case Comment: {
                        break;
                    }
                    case Code: {
                        if (!parseState.passedDocComment()) {
                            return firstOldImportLine;
                        }
                        this.foundDocComment = true;
                        return l;
                    }
                    case BlankLine: {
                        this.addNewLinesToImports = true;
                        --l;
                        this.doc.replace(lineInfo.getOffset(), lineInfo.getLength() + this.endLineDelim.length(), "");
                        break;
                    }
                    case SingleQuoteDocComment: 
                    case DoubleQuoteDocComment: {
                        if (slt.matchesStartAndEnd(line)) {
                            parseState = SkipLineType.DummyHaveFoundEndDocComment;
                            break;
                        }
                        parseState = slt;
                        break;
                    }
                    case EndDocComment: {
                        parseState = SkipLineType.DummyHaveFoundEndDocComment;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.valueOf(slt.name()) + " not expected");
                    }
                }
                ++l;
            }
        }
        catch (BadLocationException badLocationException) {
            return firstOldImportLine;
        }
    }

    static final class DummyImportClassifier
    extends ImportClassifier {
        DummyImportClassifier() {
        }

        @Override
        int classify(ImportHandle imp) {
            String module = Pep8ImportArranger.getModuleName(imp);
            if (module.equals("__future__")) {
                return 0;
            }
            if (module.startsWith(".")) {
                return 4;
            }
            return 3;
        }
    }

    static abstract class ImportClassifier {
        static final int FUTURE = 0;
        static final int SYSTEM = 1;
        static final int THIRD_PARTY = 2;
        static final int OUR_CODE = 3;
        static final int RELATIVE = 4;

        ImportClassifier() {
        }

        abstract int classify(ImportHandle var1);
    }

    private static abstract class ImportType {
        static final int IMPORT = 1;
        static final int FROM = 2;

        private ImportType() {
        }
    }

    static class PathImportClassifier
    extends ImportClassifier {
        private List<String> externalSourcePaths;
        private ISystemModulesManager manager;
        private IPythonNature nature;
        private IProjectModulesManager projectModulesManager;
        private Map<Object, Integer> mapToClassification = new HashMap<Object, Integer>();

        PathImportClassifier(IProject project) throws MisconfigurationException, PythonNatureWithoutProjectException {
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            if (nature != null) {
                try {
                    String externalProjectSourcePath = nature.getPythonPathNature().getProjectExternalSourcePath(true);
                    this.externalSourcePaths = StringUtils.splitAndRemoveEmptyTrimmed((String)externalProjectSourcePath, (char)'|');
                    this.manager = nature.getProjectInterpreter().getModulesManager();
                    this.projectModulesManager = (IProjectModulesManager)nature.getAstManager().getModulesManager();
                    this.nature = nature;
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
        }

        @Override
        int classify(ImportHandle imp) {
            String module = Pep8ImportArranger.getModuleName(imp);
            Integer currClassification = this.mapToClassification.get(module);
            if (currClassification != null) {
                return currClassification;
            }
            int classification = this.classifyInternal(module);
            this.mapToClassification.put(module, classification);
            return classification;
        }

        private int classifyInternal(String module) {
            if (module.equals("__future__")) {
                return 0;
            }
            if (module.startsWith(".")) {
                return 4;
            }
            if (this.nature == null) {
                return 3;
            }
            BaseModuleRequest moduleRequest = new BaseModuleRequest(true);
            IModule mod = this.manager.getModule(module, this.nature, false, (IModuleRequestState)moduleRequest);
            if (mod == null) {
                File file;
                mod = this.projectModulesManager.getModuleInDirectManager(module, this.nature, false, (IModuleRequestState)moduleRequest);
                if (mod != null && (file = mod.getFile()) != null) {
                    String fileAbsolutePath = FileUtils.getFileAbsolutePath((File)file);
                    int len = this.externalSourcePaths.size();
                    int i = 0;
                    while (i < len) {
                        String path = this.externalSourcePaths.get(i);
                        if (fileAbsolutePath.startsWith(path)) {
                            return 2;
                        }
                        ++i;
                    }
                }
                return 3;
            }
            File file = mod.getFile();
            if (file != null && file.getAbsolutePath().contains("site-packages")) {
                return 2;
            }
            return 1;
        }
    }

    private static enum SkipLineType {
        EndDocComment{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return startDocComment.isEndDocComment(line.trim());
            }

            @Override
            boolean isEndDocComment(String nextLine) {
                return true;
            }
        }
        ,
        MidDocComment{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return !startDocComment.isDummy();
            }
        }
        ,
        SingleQuoteDocComment("'''"),
        DoubleQuoteDocComment("\"\"\""),
        BlankLine{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return line.trim().isEmpty();
            }
        }
        ,
        Comment{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return line.trim().startsWith("#");
            }
        }
        ,
        Code{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return true;
            }
        }
        ,
        DummyHaventFoundStartDocComment{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return false;
            }

            @Override
            boolean isDummy() {
                return true;
            }
        }
        ,
        DummyHaveFoundEndDocComment{

            @Override
            boolean matches(String line, SkipLineType startDocComment) {
                return false;
            }

            @Override
            boolean isDummy() {
                return true;
            }

            @Override
            public boolean passedDocComment() {
                return true;
            }
        };

        final String prefix;
        final boolean isStartDocComment;

        private SkipLineType(String prefix, boolean isDocComment) {
            this.prefix = prefix;
            this.isStartDocComment = isDocComment;
        }

        private SkipLineType() {
            this(null, false);
        }

        private SkipLineType(String prefix) {
            this(prefix, true);
        }

        boolean matches(String line, SkipLineType startDocComment) {
            return line.startsWith(this.prefix);
        }

        boolean matchesStartAndEnd(String line) {
            if (this.prefix == null) {
                return false;
            }
            return (line = line.trim()).length() >= 2 * this.prefix.length() && line.startsWith(this.prefix) && line.endsWith(this.prefix);
        }

        boolean isEndDocComment(String nextLine) {
            return this.isStartDocComment && nextLine.trim().endsWith(this.prefix);
        }

        boolean isDummy() {
            return false;
        }

        public boolean passedDocComment() {
            return false;
        }
    }
}

