/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class ContentAssistHackingAroundBugs {
    public static void fixAssistBugs(final ContentAssistant assistant) {
        if (PlatformUtils.isLinuxPlatform()) {
            assistant.addCompletionListener(new ICompletionListener(){
                Table fTable;
                Listener fKeyDownListener;
                boolean fCalled = false;

                public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                    if (this.fCalled) {
                        return;
                    }
                    this.fCalled = true;
                    try {
                        Field fProposalPopupField = ContentAssistant.class.getDeclaredField("fProposalPopup");
                        fProposalPopupField.setAccessible(true);
                        final Object completionProposalPopup = fProposalPopupField.get(assistant);
                        Field fProposalTableField = completionProposalPopup.getClass().getDeclaredField("fProposalTable");
                        fProposalTableField.setAccessible(true);
                        Table table = (Table)fProposalTableField.get(completionProposalPopup);
                        if (table == null || table.isDisposed()) {
                            return;
                        }
                        this.fKeyDownListener = new Listener(){

                            public void handleEvent(Event event) {
                                if (event.character == '\n' || event.character == '\r') {
                                    try {
                                        Method m = completionProposalPopup.getClass().getDeclaredMethod("insertSelectedProposalWithMask", Integer.TYPE);
                                        m.setAccessible(true);
                                        m.invoke(completionProposalPopup, event.stateMask);
                                    }
                                    catch (Throwable e) {
                                        Log.log((Throwable)e);
                                    }
                                }
                            }
                        };
                        table.addListener(1, this.fKeyDownListener);
                        this.fTable = table;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void assistSessionStarted(ContentAssistEvent event) {
                }

                public void assistSessionEnded(ContentAssistEvent event) {
                    if (this.fCalled) {
                        this.fCalled = false;
                        if (this.fTable != null && !this.fTable.isDisposed() && this.fKeyDownListener != null) {
                            this.fTable.removeListener(1, this.fKeyDownListener);
                        }
                        this.fTable = null;
                        this.fKeyDownListener = null;
                    }
                }
            });
        }
    }
}

