/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.codecompletion.IPyTemplateCompletionProcessor;
import org.python.pydev.editor.codecompletion.templates.PyDocumentTemplateContext;
import org.python.pydev.editor.templates.TemplateHelper;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PyTemplateCompletionProcessor
extends TemplateCompletionProcessor
implements IPyTemplateCompletionProcessor {
    private String currentContext;

    protected Template[] getTemplates(String contextTypeId) {
        return TemplateHelper.getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return TemplateHelper.getContextTypeRegistry().getContextType(this.currentContext);
    }

    protected Image getImage(Template template) {
        return ImageCache.asImage((IImageHandle)this.getImageHandle());
    }

    private IImageHandle getImageHandle() {
        return SharedUiPlugin.getImageCache().get("icons/template.gif");
    }

    @Override
    public void addTemplateProposals(ITextViewer viewer, int documentOffset, List<ICompletionProposalHandle> propList) {
        IDocument doc = viewer.getDocument();
        this.currentContext = doc.getLength() == 0 ? "org.python.pydev.editor.templates.python.modules" : "org.python.pydev.editor.templates.python";
        String str = this.extractPrefix(viewer, documentOffset);
        ICompletionProposal[] templateProposals = this.computeCompletionProposals(viewer, documentOffset);
        int j = 0;
        while (j < templateProposals.length) {
            if (templateProposals[j].getDisplayString().startsWith(str)) {
                propList.add((ICompletionProposalHandle)templateProposals[j]);
            }
            ++j;
        }
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return (ICompletionProposal)CompletionProposalFactory.get().createPyTemplateProposal(template, context, region, this.getImageHandle(), relevance);
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        return PyDocumentTemplateContext.createContext(contextType, viewer, region);
    }
}

