/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.ImageCache;

public class PyCompletionProposal
implements ICompletionProposal,
IPyCompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalHandle {
    protected String fDisplayString;
    protected String fReplacementString;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected IImageHandle fImage;
    protected IContextInformation fContextInformation;
    protected String fAdditionalProposalInfo;
    protected int priority;
    protected IPyCompletionProposal.ICompareContext fCompareContext;
    public int onApplyAction = 1;
    public String fArgs;

    public IPyCompletionProposal.ICompareContext getCompareContext() {
        return this.fCompareContext;
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority, IPyCompletionProposal.ICompareContext compareContext) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null, priority, compareContext);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null, priority, null);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, IPyCompletionProposal.ICompareContext compareContext) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, 1, "", compareContext);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, 1, "", null);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args, null);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, IPyCompletionProposal.ICompareContext compareContext) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        if (displayString == null) {
            displayString = replacementString;
        }
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.priority = priority;
        this.onApplyAction = onApplyAction;
        this.fArgs = args;
        this.fCompareContext = compareContext;
    }

    public void apply(IDocument document) {
        switch (this.onApplyAction) {
            case 2: {
                break;
            }
            case 1: {
                try {
                    document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case 3: {
                try {
                    if (this.fArgs.length() <= 0) break;
                    String args = this.fArgs.substring(1, this.fArgs.length() - 1);
                    document.replace(this.fReplacementOffset + this.fReplacementLength, 0, args);
                }
                catch (BadLocationException x) {
                    Log.log((Throwable)x);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
            }
        }
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public Point getSelection(IDocument document) {
        if (this.onApplyAction == 2) {
            return null;
        }
        if (this.onApplyAction == 1) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        if (this.onApplyAction == 3) {
            return new Point(this.fReplacementOffset + this.fCursorPosition - 1, 0);
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return ImageCache.asImage((IImageHandle)this.fImage);
    }

    public final String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public int hashCode() {
        return this.getDisplayString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PyCompletionProposal)) {
            return false;
        }
        PyCompletionProposal c = (PyCompletionProposal)obj;
        return this.getDisplayString().equals(c.getDisplayString());
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isAutoInsertable() {
        return this.onApplyAction == 2 || this.onApplyAction == 3;
    }

    public int getOverrideBehavior(ICompletionProposalHandle curr) {
        return 0;
    }
}

